/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.annotations;

import org.teavm.javaxservlet.ServletContextAttributeListener;
import org.teavm.javaxservlet.ServletContextListener;
import org.teavm.javaxservlet.ServletRequestAttributeListener;
import org.teavm.javaxservlet.ServletRequestListener;
import org.teavm.javaxservlet.annotation.WebListener;
import org.teavm.javaxservlet.http.HttpSessionAttributeListener;
import org.teavm.javaxservlet.http.HttpSessionIdListener;
import org.teavm.javaxservlet.http.HttpSessionListener;
import org.teavm.jetty.servlet.ListenerHolder;
import org.teavm.jetty.servlet.Source;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.util.resource.Resource;
import org.teavm.jetty.webapp.DiscoveredAnnotation;
import org.teavm.jetty.webapp.MetaData;
import org.teavm.jetty.webapp.Origin;
import org.teavm.jetty.webapp.WebAppContext;

public class WebListenerAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = Log.getLogger(WebListenerAnnotation.class);

    public WebListenerAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public WebListenerAnnotation(WebAppContext context, String className, Resource resource) {
        super(context, className, resource);
    }

    @Override
    public void apply() {
        Class<?> clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn(this._className + " cannot be loaded", new Object[0]);
            return;
        }
        try {
            if (ServletContextListener.class.isAssignableFrom(clazz) || ServletContextAttributeListener.class.isAssignableFrom(clazz) || ServletRequestListener.class.isAssignableFrom(clazz) || ServletRequestAttributeListener.class.isAssignableFrom(clazz) || HttpSessionListener.class.isAssignableFrom(clazz) || HttpSessionAttributeListener.class.isAssignableFrom(clazz) || HttpSessionIdListener.class.isAssignableFrom(clazz)) {
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOrigin(clazz.getName() + ".listener") == Origin.NotSet) {
                    ListenerHolder h = this._context.getServletHandler().newListenerHolder(new Source(Source.Origin.ANNOTATION, clazz.getName()));
                    h.setHeldClass(clazz);
                    this._context.getServletHandler().addListener(h);
                    metaData.setOrigin(clazz.getName() + ".listener", clazz.getAnnotation(WebListener.class), clazz);
                }
            } else {
                LOG.warn(clazz.getName() + " does not implement one of the servlet listener interfaces", new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }
}

