/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.annotations;

import java.util.ArrayList;
import java.util.List;
import org.teavm.javaxservlet.ServletSecurityElement;
import org.teavm.javaxservlet.annotation.ServletSecurity;
import org.teavm.jetty.annotations.AnnotationIntrospector;
import org.teavm.jetty.security.ConstraintAware;
import org.teavm.jetty.security.ConstraintMapping;
import org.teavm.jetty.security.ConstraintSecurityHandler;
import org.teavm.jetty.servlet.ServletHolder;
import org.teavm.jetty.servlet.ServletMapping;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.util.security.Constraint;
import org.teavm.jetty.webapp.WebAppContext;

public class ServletSecurityAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = Log.getLogger(ServletSecurityAnnotationHandler.class);
    private WebAppContext _context;

    public ServletSecurityAnnotationHandler(WebAppContext wac) {
        super(false);
        this._context = wac;
    }

    public void doHandle(Class clazz) {
        List<ConstraintMapping> constraintMappings;
        if (!(this._context.getSecurityHandler() instanceof ConstraintAware)) {
            LOG.warn("SecurityHandler not ConstraintAware, skipping security annotation processing", new Object[0]);
            return;
        }
        ServletSecurity servletSecurity = clazz.getAnnotation(ServletSecurity.class);
        if (servletSecurity == null) {
            return;
        }
        List<ServletMapping> servletMappings = this.getServletMappings(clazz.getCanonicalName());
        if (this.constraintsExist(servletMappings, constraintMappings = ((ConstraintAware)((Object)this._context.getSecurityHandler())).getConstraintMappings())) {
            LOG.warn("Constraints already defined for " + clazz.getName() + ", skipping ServletSecurity annotation", new Object[0]);
            return;
        }
        constraintMappings = new ArrayList<ConstraintMapping>();
        ServletSecurityElement securityElement = new ServletSecurityElement(servletSecurity);
        for (ServletMapping sm : servletMappings) {
            for (String url : sm.getPathSpecs()) {
                this._context.getMetaData().setOrigin("constraint.url." + url, servletSecurity, clazz);
                constraintMappings.addAll(ConstraintSecurityHandler.createConstraintsWithMappingsForPath(clazz.getName(), url, securityElement));
            }
        }
        ConstraintAware securityHandler = (ConstraintAware)((Object)this._context.getSecurityHandler());
        for (ConstraintMapping m : constraintMappings) {
            securityHandler.addConstraintMapping(m);
        }
        securityHandler.checkPathsWithUncoveredHttpMethods();
    }

    protected Constraint makeConstraint(Class servlet, String[] rolesAllowed, ServletSecurity.EmptyRoleSemantic permitOrDeny, ServletSecurity.TransportGuarantee transport) {
        return ConstraintSecurityHandler.createConstraint(servlet.getName(), rolesAllowed, permitOrDeny, transport);
    }

    protected List<ServletMapping> getServletMappings(String className) {
        ServletMapping[] mappings;
        ArrayList<ServletMapping> results = new ArrayList<ServletMapping>();
        for (ServletMapping mapping : mappings = this._context.getServletHandler().getServletMappings()) {
            ServletHolder holder = this._context.getServletHandler().getServlet(mapping.getServletName());
            if (holder.getClassName() == null || !holder.getClassName().equals(className)) continue;
            results.add(mapping);
        }
        return results;
    }

    protected boolean constraintsExist(List<ServletMapping> servletMappings, List<ConstraintMapping> constraintMappings) {
        boolean exists = false;
        for (ServletMapping mapping : servletMappings) {
            String[] pathSpecs = mapping.getPathSpecs();
            if (pathSpecs == null) continue;
            block1: for (int i = 0; constraintMappings != null && i < constraintMappings.size() && !exists; ++i) {
                for (int j = 0; j < pathSpecs.length; ++j) {
                    if (!pathSpecs[j].equals(constraintMappings.get(i).getPathSpec())) continue;
                    exists = true;
                    continue block1;
                }
            }
        }
        return exists;
    }
}

