/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.annotations;

import java.util.List;
import org.teavm.jetty.plus.annotation.ContainerInitializer;
import org.teavm.jetty.servlet.ServletContextHandler;
import org.teavm.jetty.util.component.AbstractLifeCycle;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.webapp.WebAppContext;

public class ServletContainerInitializersStarter
extends AbstractLifeCycle
implements ServletContextHandler.ServletContainerInitializerCaller {
    private static final Logger LOG = Log.getLogger(ServletContainerInitializersStarter.class);
    WebAppContext _context;

    public ServletContainerInitializersStarter(WebAppContext context) {
        this._context = context;
    }

    @Override
    public void doStart() {
        List initializers = (List)this._context.getAttribute("org.teavm.jetty.containerInitializers");
        if (initializers == null) {
            return;
        }
        for (ContainerInitializer i : initializers) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Calling ServletContainerInitializer " + i.getTarget().getClass().getName(), new Object[0]);
                }
                i.callStartup(this._context);
            }
            catch (Exception e) {
                LOG.warn(e);
                throw new RuntimeException(e);
            }
        }
    }
}

