/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.annotations;

import java.lang.annotation.Annotation;
import javax.annotation.security.RunAs;
import org.teavm.javaxservlet.Servlet;
import org.teavm.jetty.annotations.AnnotationIntrospector;
import org.teavm.jetty.servlet.ServletHolder;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.webapp.Descriptor;
import org.teavm.jetty.webapp.MetaData;
import org.teavm.jetty.webapp.WebAppContext;

public class RunAsAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = Log.getLogger(RunAsAnnotationHandler.class);
    protected WebAppContext _context;

    public RunAsAnnotationHandler(WebAppContext wac) {
        super(false);
        this._context = wac;
    }

    public void doHandle(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        RunAs runAs = clazz.getAnnotation(RunAs.class);
        if (runAs != null) {
            String role = runAs.value();
            if (role != null) {
                for (ServletHolder holder : this._context.getServletHandler().getServlets(clazz)) {
                    MetaData metaData = this._context.getMetaData();
                    Descriptor d = metaData.getOriginDescriptor(holder.getName() + ".servlet.run-as");
                    if (d != null) continue;
                    metaData.setOrigin(holder.getName() + ".servlet.run-as", (Annotation)runAs, clazz);
                    holder.setRunAsRole(role);
                }
            } else {
                LOG.warn("Bad value for @RunAs annotation on class " + clazz.getName(), new Object[0]);
            }
        }
    }

    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation) {
        LOG.warn("@RunAs annotation not applicable for fields: " + className + "." + fieldName, new Object[0]);
    }

    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation) {
        LOG.warn("@RunAs annotation ignored on method: " + className + "." + methodName + " " + signature, new Object[0]);
    }
}

