/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.teavm.javaxservlet.AsyncListener;
import org.teavm.javaxservlet.Filter;
import org.teavm.javaxservlet.Servlet;
import org.teavm.javaxservlet.ServletContextAttributeListener;
import org.teavm.javaxservlet.ServletContextListener;
import org.teavm.javaxservlet.ServletRequestAttributeListener;
import org.teavm.javaxservlet.ServletRequestListener;
import org.teavm.javaxservlet.http.HttpSessionAttributeListener;
import org.teavm.javaxservlet.http.HttpSessionIdListener;
import org.teavm.javaxservlet.http.HttpSessionListener;
import org.teavm.javaxservlet.http.HttpUpgradeHandler;
import org.teavm.jetty.annotations.AnnotationIntrospector;
import org.teavm.jetty.plus.annotation.Injection;
import org.teavm.jetty.plus.annotation.InjectionCollection;
import org.teavm.jetty.plus.jndi.NamingEntryUtil;
import org.teavm.jetty.util.log.Log;
import org.teavm.jetty.util.log.Logger;
import org.teavm.jetty.webapp.MetaData;
import org.teavm.jetty.webapp.WebAppContext;

public class ResourceAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = Log.getLogger(ResourceAnnotationHandler.class);
    protected static final List<Class<?>> ENV_ENTRY_TYPES = Arrays.asList(String.class, Character.class, Integer.class, Boolean.class, Double.class, Byte.class, Short.class, Long.class, Float.class);
    protected WebAppContext _context;

    public ResourceAnnotationHandler(WebAppContext wac) {
        super(true);
        this._context = wac;
    }

    @Override
    public void doHandle(Class<?> clazz) {
        if (this.supportsResourceInjection(clazz)) {
            this.handleClass(clazz);
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                this.handleMethod(clazz, methods[i]);
            }
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                this.handleField(clazz, fields[i]);
            }
        }
    }

    public void handleClass(Class<?> clazz) {
        Resource resource = clazz.getAnnotation(Resource.class);
        if (resource != null) {
            String name = resource.name();
            String mappedName = resource.mappedName();
            if (name == null || name.trim().equals("")) {
                throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
            }
            try {
                if (!NamingEntryUtil.bindToENC(this._context, name, mappedName) && !NamingEntryUtil.bindToENC(this._context.getServer(), name, mappedName)) {
                    throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                }
            }
            catch (NamingException e) {
                LOG.warn(e);
            }
        }
    }

    public void handleField(Class<?> clazz, Field field) {
        block16: {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource != null) {
                Injection injection;
                if (Modifier.isStatic(field.getModifiers())) {
                    LOG.warn("Skipping Resource annotation on " + clazz.getName() + "." + field.getName() + ": cannot be static", new Object[0]);
                    return;
                }
                if (Modifier.isFinal(field.getModifiers())) {
                    LOG.warn("Skipping Resource annotation on " + clazz.getName() + "." + field.getName() + ": cannot be final", new Object[0]);
                    return;
                }
                String name = clazz.getName() + "/" + field.getName();
                name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
                Class<?> type = field.getType();
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOriginDescriptor("resource-ref." + name + ".injection") != null) {
                    return;
                }
                InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.teavm.jetty.injectionCollection");
                if (injections == null) {
                    injections = new InjectionCollection();
                    this._context.setAttribute("org.teavm.jetty.injectionCollection", injections);
                }
                if ((injection = injections.getInjection(name, clazz, field)) == null) {
                    try {
                        boolean bound = NamingEntryUtil.bindToENC(this._context, name, mappedName);
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(this._context.getServer(), name, mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(null, name, mappedName);
                        }
                        if (!bound) {
                            try {
                                InitialContext ic = new InitialContext();
                                String nameInEnvironment = mappedName != null ? mappedName : name;
                                ic.lookup("java:comp/env/" + nameInEnvironment);
                                bound = true;
                            }
                            catch (NameNotFoundException e) {
                                bound = false;
                            }
                        }
                        if (bound) {
                            LOG.debug("Bound " + (mappedName == null ? name : mappedName) + " as " + name, new Object[0]);
                            injection = new Injection(clazz, field, type, name, mappedName);
                            injections.add(injection);
                            metaData.setOrigin("resource-ref." + name + ".injection", (Annotation)resource, clazz);
                        } else if (!this.isEnvEntryType(type)) {
                            throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                        }
                    }
                    catch (NamingException e) {
                        if (this.isEnvEntryType(type)) break block16;
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    public void handleMethod(Class<?> clazz, Method method) {
        block18: {
            Resource resource = method.getAnnotation(Resource.class);
            if (resource != null) {
                Injection injection;
                if (Modifier.isStatic(method.getModifiers())) {
                    LOG.warn("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": cannot be static", new Object[0]);
                    return;
                }
                if (!method.getName().startsWith("set")) {
                    LOG.warn("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": invalid java bean, does not start with 'set'", new Object[0]);
                    return;
                }
                if (method.getParameterCount() != 1) {
                    LOG.warn("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": invalid java bean, not single argument to method", new Object[0]);
                    return;
                }
                if (Void.TYPE != method.getReturnType()) {
                    LOG.warn("Skipping Resource annotation on " + clazz.getName() + "." + method.getName() + ": invalid java bean, not void", new Object[0]);
                    return;
                }
                String name = method.getName().substring(3);
                name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
                name = clazz.getName() + "/" + name;
                name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
                Class<?> paramType = method.getParameterTypes()[0];
                Class resourceType = resource.type();
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOriginDescriptor("resource-ref." + name + ".injection") != null) {
                    return;
                }
                InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.teavm.jetty.injectionCollection");
                if (injections == null) {
                    injections = new InjectionCollection();
                    this._context.setAttribute("org.teavm.jetty.injectionCollection", injections);
                }
                if ((injection = injections.getInjection(name, clazz, method, paramType)) == null) {
                    try {
                        boolean bound = NamingEntryUtil.bindToENC(this._context, name, mappedName);
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(this._context.getServer(), name, mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(null, name, mappedName);
                        }
                        if (!bound) {
                            try {
                                InitialContext ic = new InitialContext();
                                String nameInEnvironment = mappedName != null ? mappedName : name;
                                ic.lookup("java:comp/env/" + nameInEnvironment);
                                bound = true;
                            }
                            catch (NameNotFoundException e) {
                                bound = false;
                            }
                        }
                        if (bound) {
                            LOG.debug("Bound " + (mappedName == null ? name : mappedName) + " as " + name, new Object[0]);
                            injection = new Injection(clazz, method, paramType, resourceType, name, mappedName);
                            injections.add(injection);
                            metaData.setOrigin("resource-ref." + name + ".injection", (Annotation)resource, clazz);
                        } else if (!this.isEnvEntryType(paramType)) {
                            throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                        }
                    }
                    catch (NamingException e) {
                        if (this.isEnvEntryType(paramType)) break block18;
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    public boolean supportsResourceInjection(Class<?> c) {
        return Servlet.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || ServletContextListener.class.isAssignableFrom(c) || ServletContextAttributeListener.class.isAssignableFrom(c) || ServletRequestListener.class.isAssignableFrom(c) || ServletRequestAttributeListener.class.isAssignableFrom(c) || HttpSessionListener.class.isAssignableFrom(c) || HttpSessionAttributeListener.class.isAssignableFrom(c) || HttpSessionIdListener.class.isAssignableFrom(c) || AsyncListener.class.isAssignableFrom(c) || HttpUpgradeHandler.class.isAssignableFrom(c);
    }

    public boolean isEnvEntryType(Class<?> clazz) {
        return ENV_ENTRY_TYPES.contains(clazz);
    }
}

