/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PreDestroy;
import org.teavm.javaxservlet.AsyncListener;
import org.teavm.javaxservlet.Filter;
import org.teavm.javaxservlet.Servlet;
import org.teavm.javaxservlet.ServletContextAttributeListener;
import org.teavm.javaxservlet.ServletContextListener;
import org.teavm.javaxservlet.ServletRequestAttributeListener;
import org.teavm.javaxservlet.ServletRequestListener;
import org.teavm.javaxservlet.http.HttpSessionAttributeListener;
import org.teavm.javaxservlet.http.HttpSessionIdListener;
import org.teavm.javaxservlet.http.HttpSessionListener;
import org.teavm.javaxservlet.http.HttpUpgradeHandler;
import org.teavm.jetty.annotations.AnnotationIntrospector;
import org.teavm.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.teavm.jetty.plus.annotation.PreDestroyCallback;
import org.teavm.jetty.webapp.MetaData;
import org.teavm.jetty.webapp.Origin;
import org.teavm.jetty.webapp.WebAppContext;

public class PreDestroyAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    WebAppContext _context;

    public PreDestroyAnnotationHandler(WebAppContext wac) {
        super(true);
        this._context = wac;
    }

    public void doHandle(Class clazz) {
        if (this.supportsPreDestroy(clazz)) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.isAnnotationPresent(PreDestroy.class)) continue;
                if (m.getParameterCount() != 0) {
                    throw new IllegalStateException(m + " has parameters");
                }
                if (m.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException(m + " is not void");
                }
                if (m.getExceptionTypes().length != 0) {
                    throw new IllegalStateException(m + " throws checked exceptions");
                }
                if (Modifier.isStatic(m.getModifiers())) {
                    throw new IllegalStateException(m + " is static");
                }
                MetaData metaData = this._context.getMetaData();
                Origin origin = metaData.getOrigin("pre-destroy");
                if (origin != null && (origin == Origin.WebXml || origin == Origin.WebDefaults || origin == Origin.WebOverride)) {
                    return;
                }
                PreDestroyCallback callback = new PreDestroyCallback(clazz, m.getName());
                LifeCycleCallbackCollection lifecycles = (LifeCycleCallbackCollection)this._context.getAttribute("org.teavm.jetty.lifecyleCallbackCollection");
                if (lifecycles == null) {
                    lifecycles = new LifeCycleCallbackCollection();
                    this._context.setAttribute("org.teavm.jetty.lifecyleCallbackCollection", lifecycles);
                }
                lifecycles.add(callback);
            }
        }
    }

    public boolean supportsPreDestroy(Class c) {
        return Servlet.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || ServletContextListener.class.isAssignableFrom(c) || ServletContextAttributeListener.class.isAssignableFrom(c) || ServletRequestListener.class.isAssignableFrom(c) || ServletRequestAttributeListener.class.isAssignableFrom(c) || HttpSessionListener.class.isAssignableFrom(c) || HttpSessionAttributeListener.class.isAssignableFrom(c) || HttpSessionIdListener.class.isAssignableFrom(c) || AsyncListener.class.isAssignableFrom(c) || HttpUpgradeHandler.class.isAssignableFrom(c);
    }
}

