/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import org.teavm.javaxservlet.AsyncListener;
import org.teavm.javaxservlet.Filter;
import org.teavm.javaxservlet.Servlet;
import org.teavm.javaxservlet.ServletContextAttributeListener;
import org.teavm.javaxservlet.ServletContextListener;
import org.teavm.javaxservlet.ServletRequestAttributeListener;
import org.teavm.javaxservlet.ServletRequestListener;
import org.teavm.javaxservlet.http.HttpSessionAttributeListener;
import org.teavm.javaxservlet.http.HttpSessionIdListener;
import org.teavm.javaxservlet.http.HttpSessionListener;
import org.teavm.javaxservlet.http.HttpUpgradeHandler;
import org.teavm.jetty.annotations.AnnotationIntrospector;
import org.teavm.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.teavm.jetty.plus.annotation.PostConstructCallback;
import org.teavm.jetty.webapp.MetaData;
import org.teavm.jetty.webapp.Origin;
import org.teavm.jetty.webapp.WebAppContext;

public class PostConstructAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    protected WebAppContext _context;

    public PostConstructAnnotationHandler(WebAppContext wac) {
        super(true);
        this._context = wac;
    }

    public void doHandle(Class clazz) {
        if (this.supportsPostConstruct(clazz)) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.isAnnotationPresent(PostConstruct.class)) continue;
                if (m.getParameterCount() != 0) {
                    throw new IllegalStateException(m + " has parameters");
                }
                if (m.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException(m + " is not void");
                }
                if (m.getExceptionTypes().length != 0) {
                    throw new IllegalStateException(m + " throws checked exceptions");
                }
                if (Modifier.isStatic(m.getModifiers())) {
                    throw new IllegalStateException(m + " is static");
                }
                MetaData metaData = this._context.getMetaData();
                Origin origin = metaData.getOrigin("post-construct");
                if (origin != null && (origin == Origin.WebXml || origin == Origin.WebDefaults || origin == Origin.WebOverride)) {
                    return;
                }
                PostConstructCallback callback = new PostConstructCallback(clazz, m.getName());
                LifeCycleCallbackCollection lifecycles = (LifeCycleCallbackCollection)this._context.getAttribute("org.teavm.jetty.lifecyleCallbackCollection");
                if (lifecycles == null) {
                    lifecycles = new LifeCycleCallbackCollection();
                    this._context.setAttribute("org.teavm.jetty.lifecyleCallbackCollection", lifecycles);
                }
                lifecycles.add(callback);
            }
        }
    }

    public boolean supportsPostConstruct(Class c) {
        return Servlet.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || ServletContextListener.class.isAssignableFrom(c) || ServletContextAttributeListener.class.isAssignableFrom(c) || ServletRequestListener.class.isAssignableFrom(c) || ServletRequestAttributeListener.class.isAssignableFrom(c) || HttpSessionListener.class.isAssignableFrom(c) || HttpSessionAttributeListener.class.isAssignableFrom(c) || HttpSessionIdListener.class.isAssignableFrom(c) || AsyncListener.class.isAssignableFrom(c) || HttpUpgradeHandler.class.isAssignableFrom(c);
    }
}

