/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jetty.annotations;

import org.teavm.javaxservlet.MultipartConfigElement;
import org.teavm.javaxservlet.Servlet;
import org.teavm.javaxservlet.annotation.MultipartConfig;
import org.teavm.jetty.annotations.AnnotationIntrospector;
import org.teavm.jetty.servlet.ServletHolder;
import org.teavm.jetty.webapp.Descriptor;
import org.teavm.jetty.webapp.MetaData;
import org.teavm.jetty.webapp.WebAppContext;

public class MultiPartConfigAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    protected WebAppContext _context;

    public MultiPartConfigAnnotationHandler(WebAppContext context) {
        super(false);
        this._context = context;
    }

    public void doHandle(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        MultipartConfig multi = clazz.getAnnotation(MultipartConfig.class);
        if (multi == null) {
            return;
        }
        MetaData metaData = this._context.getMetaData();
        for (ServletHolder holder : this._context.getServletHandler().getServlets(clazz)) {
            Descriptor d = metaData.getOriginDescriptor(holder.getName() + ".servlet.multipart-config");
            if (d != null) continue;
            metaData.setOrigin(holder.getName() + ".servlet.multipart-config", multi, clazz);
            holder.getRegistration().setMultipartConfig(new MultipartConfigElement(multi));
        }
    }
}

