/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.teavm.jackson.core.JsonGenerator;
import org.teavm.jackson.core.JsonToken;
import org.teavm.jackson.core.type.WritableTypeId;
import org.teavm.jackson.databind.JavaType;
import org.teavm.jackson.databind.JsonMappingException;
import org.teavm.jackson.databind.JsonNode;
import org.teavm.jackson.databind.SerializerProvider;
import org.teavm.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.teavm.jackson.databind.jsontype.TypeSerializer;
import org.teavm.jackson.databind.ser.std.StdSerializer;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

