/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.teavm.jackson.core.JsonGenerator;
import org.teavm.jackson.core.JsonToken;
import org.teavm.jackson.core.type.WritableTypeId;
import org.teavm.jackson.databind.JavaType;
import org.teavm.jackson.databind.JsonMappingException;
import org.teavm.jackson.databind.JsonNode;
import org.teavm.jackson.databind.SerializerProvider;
import org.teavm.jackson.databind.annotation.JacksonStdImpl;
import org.teavm.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import org.teavm.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import org.teavm.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.teavm.jackson.databind.jsontype.TypeSerializer;
import org.teavm.jackson.databind.node.ObjectNode;
import org.teavm.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

