/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.teavm.backend.c.CTarget;
import org.teavm.backend.c.generate.CNameProvider;
import org.teavm.backend.javascript.JavaScriptTarget;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.backend.wasm.WasmTarget;
import org.teavm.callgraph.CallGraph;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationBuilder;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.dependency.DependencyAnalyzerFactory;
import org.teavm.dependency.FastDependencyAnalyzer;
import org.teavm.dependency.PreciseDependencyAnalyzer;
import org.teavm.diagnostics.DefaultProblemTextConsumer;
import org.teavm.diagnostics.Problem;
import org.teavm.diagnostics.ProblemTextConsumer;
import org.teavm.junit.CRunStrategy;
import org.teavm.junit.HtmlUnitRunStrategy;
import org.teavm.junit.RunKind;
import org.teavm.junit.SkipJVM;
import org.teavm.junit.TeaVMProperties;
import org.teavm.junit.TeaVMProperty;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestEntryPoint;
import org.teavm.junit.TestEntryPointTransformer;
import org.teavm.junit.TestExceptionPlugin;
import org.teavm.junit.TestNativeEntryPoint;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunCallback;
import org.teavm.junit.TestRunStrategy;
import org.teavm.junit.TestRunner;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationValue;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.PreOptimizingClassHolderSource;
import org.teavm.model.ReferenceCache;
import org.teavm.model.ValueType;
import org.teavm.parsing.ClasspathClassHolderSource;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMTarget;
import org.teavm.vm.spi.TeaVMHost;

public class TeaVMTestRunner
extends org.junit.runner.Runner
implements Filterable {
    static final String JUNIT3_BASE_CLASS = "junit.framework.TestCase";
    static final MethodReference JUNIT3_BEFORE = new MethodReference("junit.framework.TestCase", "setUp", new ValueType[]{ValueType.VOID});
    static final MethodReference JUNIT3_AFTER = new MethodReference("junit.framework.TestCase", "tearDown", new ValueType[]{ValueType.VOID});
    static final String JUNIT4_TEST = "org.junit.Test";
    static final String JUNIT4_BEFORE = "org.junit.Before";
    static final String JUNIT4_AFTER = "org.junit.After";
    private static final String PATH_PARAM = "teavm.junit.target";
    private static final String JS_RUNNER = "teavm.junit.js.runner";
    private static final String THREAD_COUNT = "teavm.junit.threads";
    private static final String JS_ENABLED = "teavm.junit.js";
    static final String JS_DECODE_STACK = "teavm.junit.js.decodeStack";
    private static final String C_ENABLED = "teavm.junit.c";
    private static final String WASM_ENABLED = "teavm.junit.wasm";
    private static final String C_COMPILER = "teavm.junit.c.compiler";
    private static final String C_LINE_NUMBERS = "teavm.junit.c.lineNumbers";
    private static final String MINIFIED = "teavm.junit.minified";
    private static final String OPTIMIZED = "teavm.junit.optimized";
    private static final String FAST_ANALYSIS = "teavm.junit.fastAnalysis";
    private static final int stopTimeout = 15000;
    private Class<?> testClass;
    private ClassHolderSource classSource;
    private ClassLoader classLoader;
    private Description suiteDescription;
    private static Map<ClassLoader, ClassHolderSource> classSources = new WeakHashMap<ClassLoader, ClassHolderSource>();
    private File outputDir;
    private Map<Method, Description> descriptions = new HashMap<Method, Description>();
    private static Map<RunKind, RunnerKindInfo> runners = new HashMap<RunKind, RunnerKindInfo>();
    private static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private CountDownLatch latch;
    private List<Method> filteredChildren;
    private ReferenceCache referenceCache = new ReferenceCache();

    public TeaVMTestRunner(Class<?> testClass) throws InitializationError {
        String cCommand;
        String runStrategyName;
        this.testClass = testClass;
        this.classLoader = TeaVMTestRunner.class.getClassLoader();
        this.classSource = this.getClassSource(this.classLoader);
        String outputPath = System.getProperty(PATH_PARAM);
        if (outputPath != null) {
            this.outputDir = new File(outputPath);
        }
        if ((runStrategyName = System.getProperty(JS_RUNNER)) != null) {
            HtmlUnitRunStrategy jsRunStrategy;
            switch (runStrategyName) {
                case "htmlunit": {
                    jsRunStrategy = new HtmlUnitRunStrategy();
                    break;
                }
                case "": 
                case "none": {
                    jsRunStrategy = null;
                    break;
                }
                default: {
                    throw new InitializationError("Unknown run strategy: " + runStrategyName);
                }
            }
            TeaVMTestRunner.runners.get((Object)((Object)RunKind.JAVASCRIPT)).strategy = jsRunStrategy;
        }
        if ((cCommand = System.getProperty(C_COMPILER)) != null) {
            TeaVMTestRunner.runners.get((Object)((Object)RunKind.C)).strategy = new CRunStrategy(cCommand);
        }
    }

    public Description getDescription() {
        if (this.suiteDescription == null) {
            this.suiteDescription = Description.createSuiteDescription(this.testClass);
            for (Method child : this.getFilteredChildren()) {
                this.suiteDescription.addChild(this.describeChild(child));
            }
        }
        return this.suiteDescription;
    }

    public void run(RunNotifier notifier) {
        List<Method> children = this.getFilteredChildren();
        this.latch = new CountDownLatch(children.size());
        notifier.fireTestStarted(this.getDescription());
        for (Method child : children) {
            this.runChild(child, notifier);
        }
        try {
            while (!this.latch.await(1000L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        notifier.fireTestFinished(this.getDescription());
    }

    private List<Method> getChildren() {
        ArrayList<Method> children = new ArrayList<Method>();
        HashSet<String> foundMethods = new HashSet<String>();
        for (Class<?> cls = this.testClass; cls != Object.class && !cls.getName().equals(JUNIT3_BASE_CLASS); cls = cls.getSuperclass()) {
            for (Method method : cls.getDeclaredMethods()) {
                if (!foundMethods.add(method.getName()) || !this.isTestMethod(method)) continue;
                children.add(method);
            }
        }
        return children;
    }

    private boolean isTestMethod(Method method) {
        if (TestCase.class.isAssignableFrom(method.getDeclaringClass())) {
            return method.getName().startsWith("test") && method.getName().length() > 4 && Character.isUpperCase(method.getName().charAt(4));
        }
        return method.isAnnotationPresent(Test.class);
    }

    private List<Method> getFilteredChildren() {
        if (this.filteredChildren == null) {
            this.filteredChildren = this.getChildren();
        }
        return this.filteredChildren;
    }

    private Description describeChild(Method child) {
        return this.descriptions.computeIfAbsent(child, method -> Description.createTestDescription(this.testClass, (String)method.getName()));
    }

    private void runChild(Method child, RunNotifier notifier) {
        Description description = this.describeChild(child);
        notifier.fireTestStarted(description);
        if (child.isAnnotationPresent(Ignore.class)) {
            notifier.fireTestIgnored(description);
            this.latch.countDown();
            return;
        }
        boolean ran = false;
        boolean success = true;
        ClassHolder classHolder = this.classSource.get(child.getDeclaringClass().getName());
        MethodHolder methodHolder = classHolder.getMethod(this.getDescriptor(child));
        HashSet expectedExceptions = new HashSet();
        for (String exceptionName : this.getExpectedExceptions(methodHolder)) {
            try {
                expectedExceptions.add(Class.forName(exceptionName, false, this.classLoader));
            }
            catch (ClassNotFoundException e) {
                notifier.fireTestFailure(new Failure(description, (Throwable)e));
                notifier.fireTestFinished(description);
                this.latch.countDown();
                return;
            }
        }
        if (!child.isAnnotationPresent(SkipJVM.class) && !this.testClass.isAnnotationPresent(SkipJVM.class)) {
            ran = true;
            success = this.runInJvm(child, notifier, expectedExceptions);
        }
        if (success && this.outputDir != null) {
            int[] configurationIndex = new int[]{0};
            ArrayList<Consumer<Boolean>> onSuccess = new ArrayList<Consumer<Boolean>>();
            ArrayList<TestRun> runs = new ArrayList<TestRun>();
            onSuccess.add(runSuccess -> {
                if (runSuccess.booleanValue() && configurationIndex[0] < runs.size()) {
                    int n = configurationIndex[0];
                    configurationIndex[0] = n + 1;
                    this.submitRun((TestRun)runs.get(n));
                } else {
                    notifier.fireTestFinished(description);
                    this.latch.countDown();
                }
            });
            try {
                TestRun run;
                File outputPath = this.getOutputPath(child);
                this.copyJsFilesTo(outputPath);
                for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getJavaScriptConfigurations()) {
                    run = this.compile(child, notifier, RunKind.JAVASCRIPT, m -> this.compileToJs(m, configuration, outputPath), (Consumer)onSuccess.get(0));
                    if (run == null) continue;
                    runs.add(run);
                }
                for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getCConfigurations()) {
                    run = this.compile(child, notifier, RunKind.C, m -> this.compileToC(m, configuration, outputPath), (Consumer)onSuccess.get(0));
                    if (run == null) continue;
                    runs.add(run);
                }
                for (TeaVMTestConfiguration<JavaScriptTarget> teaVMTestConfiguration : this.getWasmConfigurations()) {
                    run = this.compile(child, notifier, RunKind.WASM, m -> this.compileToWasm(m, configuration, outputPath), (Consumer)onSuccess.get(0));
                    if (run == null) continue;
                    runs.add(run);
                }
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(description, e));
                notifier.fireTestFinished(description);
                this.latch.countDown();
                return;
            }
            ((Consumer)onSuccess.get(0)).accept(true);
        } else {
            if (!ran) {
                notifier.fireTestIgnored(description);
            }
            notifier.fireTestFinished(description);
            this.latch.countDown();
        }
    }

    private String[] getExpectedExceptions(MethodHolder method) {
        AnnotationHolder annot = method.getAnnotations().get(JUNIT4_TEST);
        if (annot == null) {
            return new String[0];
        }
        AnnotationValue expected = annot.getValue("expected");
        if (expected == null) {
            return new String[0];
        }
        ValueType result = expected.getJavaClass();
        return new String[]{((ValueType.Object)result).getClassName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private boolean runInJvm(Method child, RunNotifier notifier, Set<Class<?>> expectedExceptions) {
        Runner runner;
        Object instance;
        Description description = this.describeChild(child);
        try {
            instance = this.testClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            notifier.fireTestFailure(new Failure(description, (Throwable)e));
            return false;
        }
        if (!TestCase.class.isAssignableFrom(this.testClass)) {
            runner = new JUnit4Runner(instance, child);
        } else {
            runner = new JUnit3Runner(instance);
            ((TestCase)instance).setName(child.getName());
        }
        ArrayList classes = new ArrayList();
        for (Class<?> cls = instance.getClass(); cls != null; cls = cls.getSuperclass()) {
            classes.add(cls);
        }
        Collections.reverse(classes);
        for (Class c : classes) {
            for (Method method : c.getMethods()) {
                if (!method.isAnnotationPresent(Before.class)) continue;
                try {
                    method.invoke(instance, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    notifier.fireTestFailure(new Failure(description, e.getTargetException()));
                }
                catch (IllegalAccessException e) {
                    notifier.fireTestFailure(new Failure(description, (Throwable)e));
                }
            }
        }
        try {
            boolean expectedCaught = false;
            try {
                runner.run();
            }
            catch (Throwable e) {
                boolean wasExpected = false;
                for (Class<?> expected : expectedExceptions) {
                    if (!expected.isInstance(e)) continue;
                    expectedCaught = true;
                    wasExpected = true;
                }
                if (!wasExpected) {
                    notifier.fireTestFailure(new Failure(description, e));
                    boolean bl = false;
                    Collections.reverse(classes);
                    for (Class c : classes) {
                        for (Method method : c.getMethods()) {
                            if (!method.isAnnotationPresent(After.class)) continue;
                            try {
                                method.invoke(instance, new Object[0]);
                            }
                            catch (InvocationTargetException e2) {
                                notifier.fireTestFailure(new Failure(description, e2.getTargetException()));
                            }
                            catch (IllegalAccessException e3) {
                                notifier.fireTestFailure(new Failure(description, (Throwable)e3));
                            }
                        }
                    }
                    return bl;
                }
                boolean bl = false;
                Collections.reverse(classes);
                for (Class c : classes) {
                    for (Method method : c.getMethods()) {
                        if (!method.isAnnotationPresent(After.class)) continue;
                        try {
                            method.invoke(instance, new Object[0]);
                        }
                        catch (InvocationTargetException e4) {
                            notifier.fireTestFailure(new Failure(description, e4.getTargetException()));
                        }
                        catch (IllegalAccessException e5) {
                            notifier.fireTestFailure(new Failure(description, (Throwable)e5));
                        }
                    }
                }
                return bl;
            }
            if (!expectedCaught && !expectedExceptions.isEmpty()) {
                notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)((Object)new AssertionError((Object)"Expected exception was not thrown"))));
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Collections.reverse(classes);
            for (Class c : classes) {
                for (Method method : c.getMethods()) {
                    if (!method.isAnnotationPresent(After.class)) continue;
                    try {
                        method.invoke(instance, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        notifier.fireTestFailure(new Failure(description, e.getTargetException()));
                    }
                    catch (IllegalAccessException e) {
                        notifier.fireTestFailure(new Failure(description, (Throwable)e));
                    }
                }
            }
        }
    }

    private TestRun compile(Method child, final RunNotifier notifier, RunKind kind, CompileFunction compiler, final Consumer<Boolean> onComplete) {
        CompileResult compileResult;
        final Description description = this.describeChild(child);
        try {
            compileResult = compiler.compile(child);
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(description, (Throwable)e));
            notifier.fireTestFinished(description);
            this.latch.countDown();
            return null;
        }
        if (!compileResult.success) {
            notifier.fireTestFailure(new Failure(description, (Throwable)((Object)new AssertionError((Object)compileResult.errorMessage))));
            return null;
        }
        TestRunCallback callback = new TestRunCallback(){

            @Override
            public void complete() {
                onComplete.accept(true);
            }

            @Override
            public void error(Throwable e) {
                notifier.fireTestFailure(new Failure(description, e));
                onComplete.accept(false);
            }
        };
        return new TestRun(compileResult.file.getParentFile(), child, description, compileResult.file.getName(), kind, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitRun(TestRun run) {
        Class<TeaVMTestRunner> clazz = TeaVMTestRunner.class;
        synchronized (TeaVMTestRunner.class) {
            RunnerKindInfo info = runners.get((Object)run.getKind());
            if (info.strategy == null) {
                run.getCallback().complete();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (info.runner == null) {
                info.runner = new TestRunner(info.strategy);
                try {
                    info.runner.setNumThreads(Integer.parseInt(System.getProperty(THREAD_COUNT, "1")));
                }
                catch (NumberFormatException e) {
                    info.runner.setNumThreads(1);
                }
                info.runner.init();
            }
            info.runner.run(run);
            if (info.cleanupFuture != null) {
                info.cleanupFuture.cancel(false);
                info.cleanupFuture = null;
            }
            RunKind kind = run.getKind();
            info.cleanupFuture = executor.schedule(() -> TeaVMTestRunner.cleanupRunner(kind), 15000L, TimeUnit.MILLISECONDS);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupRunner(RunKind kind) {
        Class<TeaVMTestRunner> clazz = TeaVMTestRunner.class;
        synchronized (TeaVMTestRunner.class) {
            RunnerKindInfo info = runners.get((Object)kind);
            info.cleanupFuture = null;
            info.runner.stop();
            info.runner = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private File getOutputPath(Method method) {
        File path = this.outputDir;
        path = new File(path, this.testClass.getName().replace('.', '/'));
        path = new File(path, method.getName());
        path.mkdirs();
        return path;
    }

    private void copyJsFilesTo(File path) throws IOException {
        this.resourceToFile("org/teavm/backend/wasm/wasm-runtime.js", new File(path, "test.wasm-runtime.js"));
        this.resourceToFile("teavm-run-test.html", new File(path, "run-test.html"));
        this.resourceToFile("teavm-run-test-wasm.html", new File(path, "run-test-wasm.html"));
    }

    private CompileResult compileToJs(Method method, TeaVMTestConfiguration<JavaScriptTarget> configuration, File path) {
        boolean decodeStack = Boolean.parseBoolean(System.getProperty(JS_DECODE_STACK, "true"));
        DebugInformationBuilder debugEmitter = new DebugInformationBuilder(new ReferenceCache());
        Supplier<JavaScriptTarget> targetSupplier = () -> {
            JavaScriptTarget target = new JavaScriptTarget();
            if (decodeStack) {
                target.setDebugEmitter((DebugInformationEmitter)debugEmitter);
                target.setStackTraceIncluded(true);
            }
            return target;
        };
        CompilePostProcessor postBuild = null;
        if (decodeStack) {
            postBuild = (vm, file) -> {
                DebugInformation debugInfo = debugEmitter.getDebugInformation();
                File sourceMapsFile = new File(file.getPath() + ".map");
                File debugFile = new File(file.getPath() + ".teavmdbg");
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8);){
                        writer.write("\n//# sourceMappingURL=");
                        writer.write(sourceMapsFile.getName());
                    }
                    var7_8 = null;
                    try (OutputStreamWriter sourceMapsOut = new OutputStreamWriter((OutputStream)new FileOutputStream(sourceMapsFile), StandardCharsets.UTF_8);){
                        debugInfo.writeAsSourceMaps((Writer)sourceMapsOut, "", file.getPath());
                    }
                    catch (Throwable throwable) {
                        var7_8 = throwable;
                        throw throwable;
                    }
                    var7_8 = null;
                    try (FileOutputStream out = new FileOutputStream(debugFile);){
                        debugInfo.write((OutputStream)out);
                    }
                    catch (Throwable throwable) {
                        var7_8 = throwable;
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return this.compileTest(method, configuration, targetSupplier, TestEntryPoint.class.getName(), path, ".js", postBuild, false);
    }

    private CompileResult compileToC(Method method, TeaVMTestConfiguration<CTarget> configuration, File path) {
        CompilePostProcessor postBuild = (vm, file) -> {
            try {
                this.resourceToFile("teavm-CMakeLists.txt", new File(file.getParent(), "CMakeLists.txt"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this.compileTest(method, configuration, this::createCTarget, TestNativeEntryPoint.class.getName(), path, ".c", postBuild, true);
    }

    private CTarget createCTarget() {
        CTarget cTarget = new CTarget((NameProvider)new CNameProvider());
        cTarget.setLineNumbersGenerated(Boolean.parseBoolean(System.getProperty(C_LINE_NUMBERS, "false")));
        return cTarget;
    }

    private CompileResult compileToWasm(Method method, TeaVMTestConfiguration<WasmTarget> configuration, File path) {
        return this.compileTest(method, configuration, WasmTarget::new, TestNativeEntryPoint.class.getName(), path, ".wasm", null, false);
    }

    private <T extends TeaVMTarget> CompileResult compileTest(Method method, TeaVMTestConfiguration<T> configuration, Supplier<T> targetSupplier, String entryPoint, File path, String extension, CompilePostProcessor postBuild, boolean separateDir) {
        File outputFile;
        CompileResult result = new CompileResult();
        StringBuilder simpleName = new StringBuilder();
        simpleName.append("test");
        String suffix = configuration.getSuffix();
        if (!suffix.isEmpty() && !separateDir) {
            simpleName.append('-').append(suffix);
        }
        if (separateDir) {
            outputFile = new File(new File(path, simpleName.toString()), "test" + extension);
        } else {
            simpleName.append(extension);
            outputFile = new File(path, simpleName.toString());
        }
        result.file = outputFile;
        ClassLoader classLoader = TeaVMTestRunner.class.getClassLoader();
        ClassHolder classHolder = this.classSource.get(method.getDeclaringClass().getName());
        MethodHolder methodHolder = classHolder.getMethod(this.getDescriptor(method));
        TeaVMTarget target = (TeaVMTarget)targetSupplier.get();
        configuration.apply(target);
        DependencyAnalyzerFactory dependencyAnalyzerFactory = PreciseDependencyAnalyzer::new;
        boolean fastAnalysis = Boolean.parseBoolean(System.getProperty(FAST_ANALYSIS));
        if (fastAnalysis) {
            dependencyAnalyzerFactory = FastDependencyAnalyzer::new;
        }
        TeaVM vm = new TeaVMBuilder(target).setClassLoader(classLoader).setClassSource((ClassReaderSource)this.classSource).setReferenceCache(this.referenceCache).setDependencyAnalyzerFactory(dependencyAnalyzerFactory).build();
        Properties properties = new Properties();
        this.applyProperties(method.getDeclaringClass(), properties);
        vm.setProperties(properties);
        configuration.apply(vm);
        vm.installPlugins();
        new TestExceptionPlugin().install((TeaVMHost)vm);
        new TestEntryPointTransformer(methodHolder.getReference(), this.testClass.getName()).install((TeaVMHost)vm);
        vm.entryPoint(entryPoint);
        if (fastAnalysis) {
            vm.setOptimizationLevel(TeaVMOptimizationLevel.SIMPLE);
            vm.addVirtualMethods(m -> true);
        }
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        vm.build((BuildTarget)new DirectoryBuildTarget(outputFile.getParentFile()), outputFile.getName());
        if (!vm.getProblemProvider().getProblems().isEmpty()) {
            result.success = false;
            result.errorMessage = this.buildErrorMessage(vm);
        } else if (postBuild != null) {
            postBuild.process(vm, outputFile);
        }
        return result;
    }

    private List<TeaVMTestConfiguration<JavaScriptTarget>> getJavaScriptConfigurations() {
        ArrayList<TeaVMTestConfiguration<JavaScriptTarget>> configurations = new ArrayList<TeaVMTestConfiguration<JavaScriptTarget>>();
        if (Boolean.parseBoolean(System.getProperty(JS_ENABLED, "true"))) {
            configurations.add(TeaVMTestConfiguration.JS_DEFAULT);
            if (Boolean.getBoolean(MINIFIED)) {
                configurations.add(TeaVMTestConfiguration.JS_MINIFIED);
            }
            if (Boolean.getBoolean(OPTIMIZED)) {
                configurations.add(TeaVMTestConfiguration.JS_OPTIMIZED);
            }
        }
        return configurations;
    }

    private List<TeaVMTestConfiguration<WasmTarget>> getWasmConfigurations() {
        ArrayList<TeaVMTestConfiguration<WasmTarget>> configurations = new ArrayList<TeaVMTestConfiguration<WasmTarget>>();
        if (Boolean.getBoolean(WASM_ENABLED)) {
            configurations.add(TeaVMTestConfiguration.WASM_DEFAULT);
            if (Boolean.getBoolean(OPTIMIZED)) {
                configurations.add(TeaVMTestConfiguration.WASM_OPTIMIZED);
            }
        }
        return configurations;
    }

    private List<TeaVMTestConfiguration<CTarget>> getCConfigurations() {
        ArrayList<TeaVMTestConfiguration<CTarget>> configurations = new ArrayList<TeaVMTestConfiguration<CTarget>>();
        if (Boolean.getBoolean(C_ENABLED)) {
            configurations.add(TeaVMTestConfiguration.C_DEFAULT);
            if (Boolean.getBoolean(OPTIMIZED)) {
                configurations.add(TeaVMTestConfiguration.C_OPTIMIZED);
            }
        }
        return configurations;
    }

    private void applyProperties(Class<?> cls, Properties result) {
        TeaVMProperties properties;
        if (cls.getSuperclass() != null) {
            this.applyProperties(cls.getSuperclass(), result);
        }
        if ((properties = cls.getAnnotation(TeaVMProperties.class)) != null) {
            for (TeaVMProperty property : properties.value()) {
                result.setProperty(property.key(), property.value());
            }
        }
    }

    private MethodDescriptor getDescriptor(Method method) {
        ValueType[] signature = (ValueType[])Stream.concat(Arrays.stream(method.getParameterTypes()).map(ValueType::parse), Stream.of(ValueType.parse(method.getReturnType()))).toArray(ValueType[]::new);
        return new MethodDescriptor(method.getName(), signature);
    }

    private String buildErrorMessage(TeaVM vm) {
        CallGraph cg = vm.getDependencyInfo().getCallGraph();
        DefaultProblemTextConsumer consumer = new DefaultProblemTextConsumer();
        StringBuilder sb = new StringBuilder();
        for (Problem problem : vm.getProblemProvider().getProblems()) {
            consumer.clear();
            problem.render((ProblemTextConsumer)consumer);
            sb.append(consumer.getText());
            TeaVMProblemRenderer.renderCallStack((CallGraph)cg, (CallLocation)problem.getLocation(), (StringBuilder)sb);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void resourceToFile(String resource, File fileName) throws IOException {
        try (InputStream input = TeaVMTestRunner.class.getClassLoader().getResourceAsStream(resource);
             FileOutputStream output = new FileOutputStream(fileName);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    private ClassHolderSource getClassSource(ClassLoader classLoader) {
        return classSources.computeIfAbsent(classLoader, cl -> new PreOptimizingClassHolderSource((ClassHolderSource)new ClasspathClassHolderSource(classLoader, this.referenceCache)));
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<Method> iterator = this.getFilteredChildren().iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (filter.shouldRun(this.describeChild(method))) {
                filter.apply((Object)method);
                continue;
            }
            iterator.remove();
        }
    }

    static {
        for (RunKind kind : RunKind.values()) {
            runners.put(kind, new RunnerKindInfo());
            runners.put(kind, new RunnerKindInfo());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Class<TeaVMTestRunner> clazz = TeaVMTestRunner.class;
            synchronized (TeaVMTestRunner.class) {
                for (RunnerKindInfo info : runners.values()) {
                    if (info.runner == null) continue;
                    info.cleanupFuture = null;
                    info.runner.stop();
                    info.runner.waitForCompletion();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }));
    }

    static interface CompileFunction {
        public CompileResult compile(Method var1);
    }

    static class CompileResult {
        boolean success = true;
        String errorMessage;
        File file;

        CompileResult() {
        }
    }

    static interface CompilePostProcessor {
        public void process(TeaVM var1, File var2);
    }

    class JUnit3Runner
    implements Runner {
        Object instance;

        JUnit3Runner(Object instance) {
            this.instance = instance;
        }

        @Override
        public void run() throws Throwable {
            ((TestCase)this.instance).runBare();
        }
    }

    class JUnit4Runner
    implements Runner {
        Object instance;
        Method child;

        JUnit4Runner(Object instance, Method child) {
            this.instance = instance;
            this.child = child;
        }

        @Override
        public void run() throws Throwable {
            try {
                this.child.invoke(this.instance, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    static interface Runner {
        public void run() throws Throwable;
    }

    static class RunnerKindInfo {
        volatile TestRunner runner;
        volatile TestRunStrategy strategy;
        volatile ScheduledFuture<?> cleanupFuture;

        RunnerKindInfo() {
        }
    }
}

