/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.SourceLocation;
import org.teavm.junit.TestRunCallback;
import org.teavm.model.MethodReference;

final class RhinoResultParser {
    private static Pattern pattern = Pattern.compile("(([A-Za-z_$]+)\\(\\))?@.+:([0-9]+)");
    private static Pattern lineSeparator = Pattern.compile("\\r\\n|\r|\n");
    private DebugInformation debugInformation;
    private String[] script;

    RhinoResultParser(File debugFile) {
        if (debugFile != null) {
            this.debugInformation = RhinoResultParser.getDebugInformation(debugFile);
            this.script = RhinoResultParser.getScript(new File(debugFile.getParentFile(), debugFile.getName().substring(0, debugFile.getName().length() - 9)));
        }
    }

    void parseResult(Scriptable result, TestRunCallback callback) {
        String status;
        if (result == null) {
            callback.complete();
            return;
        }
        switch (status = result.get("status", result).toString()) {
            case "ok": {
                callback.complete();
                break;
            }
            case "exception": {
                String decodedName;
                String className = String.valueOf(result.get("className", result));
                if (this.debugInformation != null && (decodedName = this.debugInformation.getClassNameByJsName(className)) != null) {
                    className = decodedName;
                }
                String message = String.valueOf(result.get("message", result));
                String stack = result.get("stack", result).toString();
                StackTraceElement[] decodedStack = null;
                if (this.debugInformation != null) {
                    ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
                    elements.addAll(Arrays.asList(this.decodeStack(stack)));
                    List<StackTraceElement> currentElements = Arrays.asList(Thread.currentThread().getStackTrace());
                    elements.addAll(currentElements.subList(2, currentElements.size()));
                    decodedStack = elements.toArray(new StackTraceElement[0]);
                    stack = "";
                } else {
                    stack = "\n" + stack;
                }
                Object e = className.equals("java.lang.AssertionError") ? new AssertionError((Object)(message + stack)) : new RuntimeException(className + ": " + message + stack);
                if (decodedStack != null) {
                    ((Throwable)e).setStackTrace(decodedStack);
                }
                callback.error((Throwable)e);
                break;
            }
        }
    }

    StackTraceElement[] decodeStack(String stack) {
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        for (String line : lineSeparator.split(stack)) {
            String fileName;
            String methodName;
            String className;
            String scriptLine;
            int column;
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            String functionName = matcher.group(2);
            int lineNumber = Integer.parseInt(matcher.group(3)) - 1;
            MethodReference method = this.debugInformation.getMethodAt(lineNumber, column = RhinoResultParser.firstNonSpace(scriptLine = this.script[lineNumber]));
            if (method != null) {
                className = method.getClassName();
                methodName = method.getName();
            } else {
                className = "<JS>";
                methodName = functionName != null ? functionName : "<unknown_function>";
            }
            SourceLocation location = this.debugInformation.getSourceLocation(lineNumber, column);
            if (location != null && location.getFileName() != null) {
                fileName = location.getFileName();
                fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                lineNumber = location.getLine();
            } else {
                fileName = "test.js";
                ++lineNumber;
            }
            elements.add(new StackTraceElement(className, methodName, fileName, lineNumber));
        }
        return elements.toArray(new StackTraceElement[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DebugInformation getDebugInformation(File debugFile) {
        try (FileInputStream input = new FileInputStream(debugFile);){
            DebugInformation debugInformation = DebugInformation.read((InputStream)input);
            return debugInformation;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private static String[] getScript(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int firstNonSpace(String s) {
        int i;
        for (i = 0; i < s.length() && s.charAt(i) == ' '; ++i) {
        }
        return i;
    }
}

