/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunStrategy;

class CRunStrategy
implements TestRunStrategy {
    private String compilerCommand;

    CRunStrategy(String compilerCommand) {
        this.compilerCommand = compilerCommand;
    }

    @Override
    public void beforeThread() {
    }

    @Override
    public void afterThread() {
    }

    @Override
    public void runTest(TestRun run) throws IOException {
        try {
            String exeName = "run_test";
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                exeName = exeName + ".exe";
            }
            File outputFile = new File(run.getBaseDirectory(), exeName);
            ArrayList<String> compilerOutput = new ArrayList<String>();
            boolean compilerSuccess = this.runCompiler(run.getBaseDirectory(), compilerOutput);
            if (!compilerSuccess) {
                run.getCallback().error(new RuntimeException("C compiler error:\n" + this.mergeLines(compilerOutput)));
                return;
            }
            this.writeLines(compilerOutput);
            ArrayList<String> runtimeOutput = new ArrayList<String>();
            ArrayList<String> stdout = new ArrayList<String>();
            outputFile.setExecutable(true);
            this.runProcess(new ProcessBuilder(outputFile.getPath()).start(), runtimeOutput, stdout);
            if (!stdout.isEmpty() && ((String)stdout.get(stdout.size() - 1)).equals("SUCCESS")) {
                this.writeLines(runtimeOutput);
                run.getCallback().complete();
            } else {
                run.getCallback().error(new RuntimeException("Test failed:\n" + this.mergeLines(runtimeOutput)));
            }
        }
        catch (InterruptedException e) {
            run.getCallback().complete();
        }
    }

    private String mergeLines(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private void writeLines(List<String> lines) {
        for (String line : lines) {
            System.out.println(line);
        }
    }

    private boolean runCompiler(File inputDir, List<String> output) throws IOException, InterruptedException {
        String command = new File(this.compilerCommand).getAbsolutePath();
        return this.runProcess(new ProcessBuilder(command).directory(inputDir).start(), output, new ArrayList<String>());
    }

    private boolean runProcess(Process process, List<String> output, List<String> stdout) throws InterruptedException {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        ConcurrentLinkedQueue<String> lines = new ConcurrentLinkedQueue<String>();
        Thread thread = new Thread(() -> {
            try {
                String line;
                while ((line = stderr.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        thread.setDaemon(true);
        thread.start();
        try {
            String line;
            while ((line = stdin.readLine()) != null) {
                lines.add(line);
                stdout.add(line);
                if (lines.size() <= 10000) continue;
                output.addAll(lines);
                process.destroy();
                return false;
            }
        }
        catch (IOException line) {
            // empty catch block
        }
        boolean result = process.waitFor() == 0;
        output.addAll(lines);
        return result;
    }
}

