/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.teavm.backend.javascript.JavaScriptTarget;
import org.teavm.callgraph.CallGraph;
import org.teavm.diagnostics.DefaultProblemTextConsumer;
import org.teavm.diagnostics.Problem;
import org.teavm.diagnostics.ProblemTextConsumer;
import org.teavm.junit.ExceptionHelper;
import org.teavm.junit.HtmlUnitRunStrategy;
import org.teavm.junit.SeleniumRunStrategy;
import org.teavm.junit.SkipJVM;
import org.teavm.junit.TeaVMProperties;
import org.teavm.junit.TeaVMProperty;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestEntryPoint;
import org.teavm.junit.TestEntryPointTransformer;
import org.teavm.junit.TestExceptionPlugin;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunCallback;
import org.teavm.junit.TestRunStrategy;
import org.teavm.junit.TestRunner;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.PreOptimizingClassHolderSource;
import org.teavm.model.ValueType;
import org.teavm.parsing.ClasspathClassHolderSource;
import org.teavm.testing.JUnitTestAdapter;
import org.teavm.testing.TestAdapter;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.TeaVMTarget;
import org.teavm.vm.spi.TeaVMHost;

public class TeaVMTestRunner
extends Runner
implements Filterable {
    private static final String PATH_PARAM = "teavm.junit.target";
    private static final String RUNNER = "teavm.junit.js.runner";
    private static final String THREAD_COUNT = "teavm.junit.js.threads";
    private static final String SELENIUM_URL = "teavm.junit.js.selenium.url";
    private static final int stopTimeout = 15000;
    private Class<?> testClass;
    private ClassHolder classHolder;
    private ClassLoader classLoader;
    private Description suiteDescription;
    private static Map<ClassLoader, ClassHolderSource> classSources = new WeakHashMap<ClassLoader, ClassHolderSource>();
    private File outputDir;
    private TestAdapter testAdapter = new JUnitTestAdapter();
    private Map<Method, Description> descriptions = new HashMap<Method, Description>();
    private TestRunStrategy runStrategy;
    private static volatile TestRunner runner;
    private static ScheduledThreadPoolExecutor executor;
    private static volatile ScheduledFuture<?> cleanupFuture;
    private CountDownLatch latch;
    private List<Method> filteredChildren;

    public TeaVMTestRunner(Class<?> testClass) throws InitializationError {
        String runStrategyName;
        this.testClass = testClass;
        this.classLoader = TeaVMTestRunner.class.getClassLoader();
        ClassHolderSource classSource = TeaVMTestRunner.getClassSource(this.classLoader);
        this.classHolder = classSource.get(testClass.getName());
        String outputPath = System.getProperty(PATH_PARAM);
        if (outputPath != null) {
            this.outputDir = new File(outputPath);
        }
        if ((runStrategyName = System.getProperty(RUNNER)) != null) {
            switch (runStrategyName) {
                case "selenium": {
                    try {
                        this.runStrategy = new SeleniumRunStrategy(new URL(System.getProperty(SELENIUM_URL)));
                        break;
                    }
                    catch (MalformedURLException e) {
                        throw new InitializationError((Throwable)e);
                    }
                }
                case "htmlunit": {
                    this.runStrategy = new HtmlUnitRunStrategy();
                    break;
                }
                case "": 
                case "none": {
                    this.runStrategy = null;
                    break;
                }
                default: {
                    throw new InitializationError("Unknown run strategy: " + runStrategyName);
                }
            }
        }
    }

    public Description getDescription() {
        if (this.suiteDescription == null) {
            this.suiteDescription = Description.createSuiteDescription(this.testClass);
            for (Method child : this.getFilteredChildren()) {
                this.suiteDescription.getChildren().add(this.describeChild(child));
            }
        }
        return this.suiteDescription;
    }

    public void run(RunNotifier notifier) {
        List<Method> children = this.getFilteredChildren();
        this.latch = new CountDownLatch(children.size());
        notifier.fireTestStarted(this.getDescription());
        for (Method child : children) {
            this.runChild(child, notifier);
        }
        try {
            while (!this.latch.await(1000L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        notifier.fireTestFinished(this.getDescription());
    }

    private List<Method> getChildren() {
        ArrayList<Method> children = new ArrayList<Method>();
        for (Method method : this.testClass.getDeclaredMethods()) {
            MethodHolder methodHolder = this.classHolder.getMethod(this.getDescriptor(method));
            if (!this.testAdapter.acceptMethod((MethodReader)methodHolder)) continue;
            children.add(method);
        }
        return children;
    }

    private List<Method> getFilteredChildren() {
        if (this.filteredChildren == null) {
            this.filteredChildren = this.getChildren();
        }
        return this.filteredChildren;
    }

    private Description describeChild(Method child) {
        return this.descriptions.computeIfAbsent(child, method -> Description.createTestDescription(this.testClass, (String)method.getName()));
    }

    private void runChild(Method child, RunNotifier notifier) {
        notifier.fireTestStarted(this.describeChild(child));
        boolean ran = false;
        boolean success = true;
        MethodHolder methodHolder = this.classHolder.getMethod(this.getDescriptor(child));
        HashSet expectedExceptions = new HashSet();
        for (String exceptionName : this.testAdapter.getExpectedExceptions((MethodReader)methodHolder)) {
            try {
                expectedExceptions.add(Class.forName(exceptionName, false, this.classLoader));
            }
            catch (ClassNotFoundException e) {
                notifier.fireTestFailure(new Failure(this.describeChild(child), (Throwable)e));
                notifier.fireTestFinished(this.describeChild(child));
                this.latch.countDown();
                return;
            }
        }
        if (!child.isAnnotationPresent(SkipJVM.class) && !child.getDeclaringClass().isAnnotationPresent(SkipJVM.class)) {
            ran = true;
            success = this.runInJvm(child, notifier, expectedExceptions);
        }
        Description description = this.describeChild(child);
        if (success && this.outputDir != null) {
            List<TeaVMTestConfiguration> configurations = this.getConfigurations();
            int[] configurationIndex = new int[]{0};
            ArrayList<Consumer<Boolean>> onSuccess = new ArrayList<Consumer<Boolean>>();
            ArrayList<TestRun> runs = new ArrayList<TestRun>();
            onSuccess.add(runSuccess -> {
                if (runSuccess.booleanValue() && configurationIndex[0] < runs.size()) {
                    int n = configurationIndex[0];
                    configurationIndex[0] = n + 1;
                    this.submitRun((TestRun)runs.get(n));
                } else {
                    notifier.fireTestFinished(description);
                    this.latch.countDown();
                }
            });
            for (TeaVMTestConfiguration configuration : configurations) {
                try {
                    TestRun run = this.compileByTeaVM(child, notifier, configuration, (Consumer)onSuccess.get(0));
                    if (run == null) continue;
                    runs.add(run);
                }
                catch (Throwable e) {
                    notifier.fireTestFailure(new Failure(description, e));
                    notifier.fireTestFinished(description);
                    this.latch.countDown();
                    return;
                }
            }
            ((Consumer)onSuccess.get(0)).accept(true);
        } else {
            if (!ran) {
                notifier.fireTestIgnored(description);
            }
            notifier.fireTestFinished(description);
            this.latch.countDown();
        }
    }

    private boolean runInJvm(Method child, RunNotifier notifier, Set<Class<?>> expectedExceptions) {
        boolean expectedCaught;
        block7: {
            Object instance;
            try {
                instance = this.testClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                notifier.fireTestFailure(new Failure(this.describeChild(child), (Throwable)e));
                return false;
            }
            expectedCaught = false;
            try {
                child.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                notifier.fireTestFailure(new Failure(this.describeChild(child), (Throwable)e));
                return false;
            }
            catch (InvocationTargetException e) {
                boolean wasExpected = false;
                for (Class<?> expected : expectedExceptions) {
                    if (!expected.isInstance(e.getTargetException())) continue;
                    expectedCaught = true;
                    wasExpected = true;
                }
                if (wasExpected) break block7;
                notifier.fireTestFailure(new Failure(this.describeChild(child), e.getTargetException()));
                return false;
            }
        }
        if (!expectedCaught && !expectedExceptions.isEmpty()) {
            notifier.fireTestAssumptionFailed(new Failure(this.describeChild(child), (Throwable)((Object)new AssertionError((Object)"Expected exception was not thrown"))));
            return false;
        }
        return true;
    }

    private TestRun compileByTeaVM(Method child, final RunNotifier notifier, TeaVMTestConfiguration configuration, final Consumer<Boolean> onComplete) {
        CompileResult compileResult;
        final Description description = this.describeChild(child);
        try {
            compileResult = this.compileTest(child, configuration);
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(description, (Throwable)e));
            return null;
        }
        if (!compileResult.success) {
            notifier.fireTestFailure(new Failure(description, (Throwable)((Object)new AssertionError((Object)compileResult.errorMessage))));
            return null;
        }
        if (this.runStrategy == null) {
            return null;
        }
        TestRunCallback callback = new TestRunCallback(){

            @Override
            public void complete() {
                onComplete.accept(true);
            }

            @Override
            public void error(Throwable e) {
                notifier.fireTestFailure(new Failure(description, e));
                onComplete.accept(false);
            }
        };
        return new TestRun(compileResult.file.getParentFile(), child, new MethodReference(this.testClass.getName(), this.getDescriptor(child)), description, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitRun(TestRun run) {
        Class<TeaVMTestRunner> clazz = TeaVMTestRunner.class;
        synchronized (TeaVMTestRunner.class) {
            if (this.runStrategy == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (runner == null) {
                runner = new TestRunner(this.runStrategy);
                try {
                    runner.setNumThreads(Integer.parseInt(System.getProperty(THREAD_COUNT, "1")));
                }
                catch (NumberFormatException e) {
                    runner.setNumThreads(1);
                }
                runner.init();
            }
            runner.run(run);
            if (cleanupFuture != null) {
                cleanupFuture.cancel(false);
                cleanupFuture = null;
            }
            cleanupFuture = executor.schedule(TeaVMTestRunner::cleanupRunner, 15000L, TimeUnit.MILLISECONDS);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupRunner() {
        Class<TeaVMTestRunner> clazz = TeaVMTestRunner.class;
        synchronized (TeaVMTestRunner.class) {
            cleanupFuture = null;
            runner.stop();
            runner = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private CompileResult compileTest(Method method, TeaVMTestConfiguration configuration) throws IOException {
        File outputFile;
        CompileResult result = new CompileResult();
        File path = this.outputDir;
        path = new File(path, method.getDeclaringClass().getName().replace('.', '/'));
        path = new File(path, method.getName());
        path.mkdirs();
        StringBuilder simpleName = new StringBuilder();
        simpleName.append("test");
        String suffix = configuration.getSuffix();
        if (!suffix.isEmpty()) {
            simpleName.append('-').append(suffix);
        }
        simpleName.append(".js");
        result.file = outputFile = new File(path, simpleName.toString());
        this.resourceToFile("org/teavm/backend/javascript/runtime.js", new File(path, "runtime.js"));
        this.resourceToFile("teavm-run-test.html", new File(path, "run-test.html"));
        ClassLoader classLoader = TeaVMTestRunner.class.getClassLoader();
        ClassHolderSource classSource = TeaVMTestRunner.getClassSource(classLoader);
        MethodHolder methodHolder = this.classHolder.getMethod(this.getDescriptor(method));
        Class runnerType = this.testAdapter.getRunner((MethodReader)methodHolder);
        JavaScriptTarget jsTarget = new JavaScriptTarget();
        configuration.apply(jsTarget);
        TeaVM vm = new TeaVMBuilder((TeaVMTarget)jsTarget).setClassLoader(classLoader).setClassSource(classSource).build();
        vm.setIncremental(false);
        configuration.apply(vm);
        vm.installPlugins();
        new TestExceptionPlugin().install((TeaVMHost)vm);
        new TestEntryPointTransformer(runnerType.getName(), methodHolder.getReference()).install((TeaVMHost)vm);
        Properties properties = new Properties();
        this.applyProperties(method.getDeclaringClass(), properties);
        vm.setProperties(properties);
        MethodReference exceptionMsg = new MethodReference(ExceptionHelper.class, "showException", new Class[]{Throwable.class, String.class});
        vm.entryPoint("runTest", new MethodReference(TestEntryPoint.class, "run", new Class[]{Void.TYPE})).async();
        vm.entryPoint("extractException", exceptionMsg);
        vm.build((BuildTarget)new DirectoryBuildTarget(outputFile.getParentFile()), outputFile.getName());
        if (!vm.getProblemProvider().getProblems().isEmpty()) {
            result.success = false;
            result.errorMessage = this.buildErrorMessage(vm);
        }
        return result;
    }

    private List<TeaVMTestConfiguration> getConfigurations() {
        ArrayList<TeaVMTestConfiguration> configurations = new ArrayList<TeaVMTestConfiguration>();
        configurations.add(TeaVMTestConfiguration.DEFAULT);
        if (Boolean.parseBoolean(System.getProperty("teavm.junit.minified", "false"))) {
            configurations.add(TeaVMTestConfiguration.MINIFIED);
        }
        if (Boolean.parseBoolean(System.getProperty("teavm.junit.optimized", "false"))) {
            configurations.add(TeaVMTestConfiguration.OPTIMIZED);
        }
        return configurations;
    }

    private void applyProperties(Class<?> cls, Properties result) {
        TeaVMProperties properties;
        if (cls.getSuperclass() != null) {
            this.applyProperties(cls.getSuperclass(), result);
        }
        if ((properties = cls.getAnnotation(TeaVMProperties.class)) != null) {
            for (TeaVMProperty property : properties.value()) {
                result.setProperty(property.key(), property.value());
            }
        }
    }

    private MethodDescriptor getDescriptor(Method method) {
        ValueType[] signature = (ValueType[])Stream.concat(Arrays.stream(method.getParameterTypes()).map(ValueType::parse), Stream.of(ValueType.parse(method.getReturnType()))).toArray(ValueType[]::new);
        return new MethodDescriptor(method.getName(), signature);
    }

    private String buildErrorMessage(TeaVM vm) {
        CallGraph cg = vm.getDependencyInfo().getCallGraph();
        DefaultProblemTextConsumer consumer = new DefaultProblemTextConsumer();
        StringBuilder sb = new StringBuilder();
        for (Problem problem : vm.getProblemProvider().getProblems()) {
            consumer.clear();
            problem.render((ProblemTextConsumer)consumer);
            sb.append(consumer.getText());
            TeaVMProblemRenderer.renderCallStack((CallGraph)cg, (CallLocation)problem.getLocation(), (StringBuilder)sb);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void resourceToFile(String resource, File fileName) throws IOException {
        try (InputStream input = TeaVMTestRunner.class.getClassLoader().getResourceAsStream(resource);
             FileOutputStream output = new FileOutputStream(fileName);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    private static ClassHolderSource getClassSource(ClassLoader classLoader) {
        return classSources.computeIfAbsent(classLoader, cl -> new PreOptimizingClassHolderSource((ClassHolderSource)new ClasspathClassHolderSource(classLoader)));
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<Method> iterator = this.getFilteredChildren().iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (filter.shouldRun(this.describeChild(method))) {
                filter.apply((Object)method);
                continue;
            }
            iterator.remove();
        }
    }

    static {
        executor = new ScheduledThreadPoolExecutor(1);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Class<TeaVMTestRunner> clazz = TeaVMTestRunner.class;
            synchronized (TeaVMTestRunner.class) {
                if (runner != null) {
                    cleanupFuture = null;
                    runner.stop();
                    runner.waitForCompletion();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }));
    }

    static class CompileResult {
        boolean success = true;
        String errorMessage;
        File file;

        CompileResult() {
        }
    }
}

