/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunStrategy;

class TestRunner {
    private int numThreads = 1;
    private TestRunStrategy strategy;
    private BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    private CountDownLatch latch;
    private volatile boolean stopped;

    TestRunner(TestRunStrategy strategy) {
        this.strategy = strategy;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void init() {
        this.latch = new CountDownLatch(this.numThreads);
        for (int i = 0; i < this.numThreads; ++i) {
            new Thread(() -> {
                this.strategy.beforeThread();
                while (!this.stopped || !this.taskQueue.isEmpty()) {
                    Runnable task;
                    try {
                        task = this.taskQueue.poll(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (task == null) continue;
                    task.run();
                }
                this.strategy.afterThread();
                this.latch.countDown();
            }).start();
        }
    }

    private void addTask(Runnable runnable) {
        this.taskQueue.add(runnable);
    }

    public void stop() {
        this.stopped = true;
        this.taskQueue.add(() -> {});
    }

    public void waitForCompletion() {
        try {
            while (!this.latch.await(1000L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException e) {}
    }

    public void run(TestRun run) {
        this.addTask(() -> this.runImpl(run));
    }

    private void runImpl(TestRun run) {
        try {
            String status;
            String result = this.strategy.runTest(run);
            if (result == null) {
                run.getCallback().complete();
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode resultObject = (ObjectNode)mapper.readTree(result);
            switch (status = resultObject.get("status").asText()) {
                case "ok": {
                    run.getCallback().complete();
                    break;
                }
                case "exception": {
                    String stack = resultObject.get("stack").asText();
                    String exception = resultObject.has("exception") ? resultObject.get("exception").asText() : null;
                    run.getCallback().error((Throwable)((Object)new AssertionError((Object)(exception + "\n" + stack))));
                    break;
                }
            }
        }
        catch (Exception e) {
            run.getCallback().error(e);
        }
    }
}

