/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import org.junit.Test;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.junit.TestEntryPoint;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

class TestEntryPointTransformer
implements ClassHolderTransformer,
TeaVMPlugin {
    private String runnerClassName;
    private MethodReference testMethod;

    TestEntryPointTransformer(String runnerClassName, MethodReference testMethod) {
        this.runnerClassName = runnerClassName;
        this.testMethod = testMethod;
    }

    public void install(TeaVMHost host) {
        host.add((ClassHolderTransformer)this);
    }

    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        if (cls.getName().equals(TestEntryPoint.class.getName())) {
            for (MethodHolder method : cls.getMethods()) {
                if (method.getName().equals("createRunner")) {
                    method.setProgram(this.generateRunnerProgram(method, innerSource));
                    method.getModifiers().remove(ElementModifier.NATIVE);
                    continue;
                }
                if (!method.getName().equals("launchTest")) continue;
                method.setProgram(this.generateLaunchProgram(method, innerSource));
                method.getModifiers().remove(ElementModifier.NATIVE);
            }
        }
    }

    private Program generateRunnerProgram(MethodHolder method, ClassReaderSource innerSource) {
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassReaderSource)innerSource);
        pe.construct(this.runnerClassName, new ValueEmitter[0]).returnValue();
        return pe.getProgram();
    }

    private Program generateLaunchProgram(MethodHolder method, ClassReaderSource innerSource) {
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassReaderSource)innerSource);
        ValueEmitter testCaseVar = pe.getField(TestEntryPoint.class, "testCase", Object.class);
        pe.when(testCaseVar.isNull()).thenDo(() -> pe.setField(TestEntryPoint.class, "testCase", pe.construct(this.testMethod.getClassName(), new ValueEmitter[0]).cast(Object.class)));
        pe.getField(TestEntryPoint.class, "testCase", Object.class).cast(ValueType.object((String)this.testMethod.getClassName())).invokeSpecial(this.testMethod, new ValueEmitter[0]);
        MethodReader testMethodReader = innerSource.resolve(this.testMethod);
        AnnotationReader testAnnotation = testMethodReader.getAnnotations().get(Test.class.getName());
        AnnotationValue throwsValue = testAnnotation.getValue("expected");
        if (throwsValue != null) {
            BasicBlock handler = pe.getProgram().createBasicBlock();
            TryCatchBlock tryCatch = new TryCatchBlock();
            tryCatch.setExceptionType(((ValueType.Object)throwsValue.getJavaClass()).getClassName());
            tryCatch.setHandler(handler);
            pe.getBlock().getTryCatchBlocks().add(tryCatch);
            BasicBlock nextBlock = pe.getProgram().createBasicBlock();
            pe.jump(nextBlock);
            pe.enter(nextBlock);
            pe.construct(AssertionError.class, new ValueEmitter[]{pe.constant("Expected exception not thrown")}).raise();
            pe.enter(handler);
            pe.exit();
        } else {
            pe.exit();
        }
        return pe.getProgram();
    }
}

