/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeJavaObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.io.IOUtils;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunStrategy;

class HtmlUnitRunStrategy
implements TestRunStrategy {
    private ThreadLocal<WebClient> webClient = new ThreadLocal();
    private ThreadLocal<HtmlPage> page = new ThreadLocal();
    private int runs;

    HtmlUnitRunStrategy() {
    }

    @Override
    public void beforeThread() {
        this.init();
    }

    @Override
    public void afterThread() {
        this.cleanUp();
    }

    @Override
    public String runTest(TestRun run) throws IOException {
        if (++this.runs == 50) {
            this.runs = 0;
            this.cleanUp();
            this.init();
        }
        try {
            this.page.set((HtmlPage)this.webClient.get().getPage("about:blank"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.page.get().executeJavaScript(this.readFile(new File(run.getBaseDirectory(), "runtime.js")));
        this.page.get().executeJavaScript(this.readFile(new File(run.getBaseDirectory(), "test.js")));
        AsyncResult asyncResult = new AsyncResult();
        Function function = (Function)this.page.get().executeJavaScript(this.readResource("teavm-htmlunit-adapter.js")).getJavaScriptResult();
        Object[] args = new Object[]{new NativeJavaObject((Scriptable)function, (Object)asyncResult, AsyncResult.class)};
        this.page.get().executeJavaScriptFunctionIfPossible(function, (Scriptable)function, args, (DomNode)this.page.get());
        return (String)asyncResult.getResult();
    }

    private void cleanUp() {
        this.page.get().cleanUp();
        for (WebWindow window : this.webClient.get().getWebWindows()) {
            window.getJobManager().removeAllJobs();
        }
        this.page.remove();
        this.webClient.get().close();
        this.webClient.remove();
    }

    private void init() {
        this.webClient.set(new WebClient(BrowserVersion.CHROME));
    }

    private String readFile(File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            String string = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return string;
        }
    }

    private String readResource(String resourceName) throws IOException {
        try (InputStream input = HtmlUnitRunStrategy.class.getClassLoader().getResourceAsStream(resourceName);){
            if (input == null) {
                String string = "";
                return string;
            }
            String string = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return string;
        }
    }

    public class AsyncResult {
        private CountDownLatch latch = new CountDownLatch(1);
        private Object result;

        public void complete(Object result) {
            this.result = result;
            this.latch.countDown();
        }

        public Object getResult() {
            try {
                this.latch.await(5L, TimeUnit.SECONDS);
                return this.result;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
    }
}

