/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.teavm.backend.c.CTarget;
import org.teavm.backend.c.generate.CNameProvider;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.junit.CRunStrategy;
import org.teavm.junit.CompilePostProcessor;
import org.teavm.junit.CompileResult;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestNativeEntryPoint;
import org.teavm.junit.TestPlatform;
import org.teavm.junit.TestPlatformSupport;
import org.teavm.junit.TestRunStrategy;
import org.teavm.junit.TestUtil;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ReferenceCache;
import org.teavm.vm.TeaVM;

class CPlatformSupport
extends TestPlatformSupport<CTarget> {
    CPlatformSupport(ClassHolderSource classSource, ReferenceCache referenceCache) {
        super(classSource, referenceCache);
    }

    @Override
    TestRunStrategy createRunStrategy(File outputDir) {
        String cCommand = System.getProperty("teavm.junit.c.compiler");
        if (cCommand != null) {
            return new CRunStrategy(cCommand);
        }
        return null;
    }

    @Override
    TestPlatform getPlatform() {
        return TestPlatform.C;
    }

    @Override
    String getPath() {
        return "c";
    }

    @Override
    String getExtension() {
        return "";
    }

    @Override
    boolean isEnabled() {
        return Boolean.getBoolean("teavm.junit.c");
    }

    @Override
    List<TeaVMTestConfiguration<CTarget>> getConfigurations() {
        ArrayList<TeaVMTestConfiguration<CTarget>> configurations = new ArrayList<TeaVMTestConfiguration<CTarget>>();
        configurations.add(TeaVMTestConfiguration.C_DEFAULT);
        if (Boolean.getBoolean("teavm.junit.optimized")) {
            configurations.add(TeaVMTestConfiguration.C_OPTIMIZED);
        }
        return configurations;
    }

    @Override
    CompileResult compile(Consumer<TeaVM> additionalProcessing, String baseName, TeaVMTestConfiguration<CTarget> configuration, File path, AnnotatedElement element) {
        CompilePostProcessor postBuild = (vm, file) -> {
            try {
                TestUtil.resourceToFile("teavm-CMakeLists.txt", new File(file.getParent(), "CMakeLists.txt"), Collections.emptyMap());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this.compile(configuration, this::createCTarget, TestNativeEntryPoint.class.getName(), path, "", postBuild, additionalProcessing, baseName);
    }

    private CTarget createCTarget() {
        CTarget cTarget = new CTarget((NameProvider)new CNameProvider());
        cTarget.setLineNumbersGenerated(Boolean.parseBoolean(System.getProperty("teavm.junit.c.lineNumbers", "false")));
        return cTarget;
    }

    @Override
    boolean usesFileName() {
        return false;
    }
}

