/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.teavm.backend.wasm.WasmRuntimeType;
import org.teavm.backend.wasm.WasmTarget;
import org.teavm.browserrunner.BrowserRunner;
import org.teavm.junit.BaseWebAssemblyPlatformSupport;
import org.teavm.junit.BrowserRunStrategy;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestPlatform;
import org.teavm.junit.TestRunStrategy;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.MethodReference;
import org.teavm.model.ReferenceCache;

class WebAssemblyPlatformSupport
extends BaseWebAssemblyPlatformSupport {
    WebAssemblyPlatformSupport(ClassHolderSource classSource, ReferenceCache referenceCache) {
        super(classSource, referenceCache);
    }

    @Override
    TestRunStrategy createRunStrategy(File outputDir) {
        String runStrategyName = System.getProperty("teavm.junit.wasm.runner");
        return runStrategyName != null ? new BrowserRunStrategy(outputDir, "WASM", BrowserRunner.pickBrowser((String)runStrategyName)) : null;
    }

    @Override
    TestPlatform getPlatform() {
        return TestPlatform.WEBASSEMBLY;
    }

    @Override
    String getPath() {
        return "wasm";
    }

    @Override
    boolean isEnabled() {
        return Boolean.getBoolean("teavm.junit.wasm");
    }

    @Override
    List<TeaVMTestConfiguration<WasmTarget>> getConfigurations() {
        ArrayList<TeaVMTestConfiguration<WasmTarget>> configurations = new ArrayList<TeaVMTestConfiguration<WasmTarget>>();
        configurations.add(TeaVMTestConfiguration.WASM_DEFAULT);
        if (Boolean.getBoolean("teavm.junit.optimized")) {
            configurations.add(TeaVMTestConfiguration.WASM_OPTIMIZED);
        }
        return configurations;
    }

    @Override
    protected WasmRuntimeType getRuntimeType() {
        return WasmRuntimeType.TEAVM;
    }

    @Override
    void additionalOutput(File outputPath, File outputPathForMethod, TeaVMTestConfiguration<?> configuration, MethodReference reference) {
        this.htmlOutput(outputPath, outputPathForMethod, configuration, reference, "teavm-run-test-wasm.html");
    }

    @Override
    void additionalSingleTestOutput(File outputPathForMethod, TeaVMTestConfiguration<?> configuration, MethodReference reference) {
        this.htmlSingleTestOutput(outputPathForMethod, configuration, "teavm-run-test-wasm.html");
    }
}

