/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.plugin;

import java.util.HashMap;
import java.util.Map;
import org.teavm.jso.JSObject;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;

class NativeJavascriptClassRepository {
    private ClassReaderSource classSource;
    private Map<String, Boolean> knownJavaScriptClasses = new HashMap<String, Boolean>();
    private Map<String, Boolean> knownJavaScriptImplementations = new HashMap<String, Boolean>();

    public NativeJavascriptClassRepository(ClassReaderSource classSource) {
        this.classSource = classSource;
        this.knownJavaScriptClasses.put(JSObject.class.getName(), true);
    }

    public boolean isJavaScriptClass(String className) {
        Boolean known = this.knownJavaScriptClasses.get(className);
        if (known == null) {
            known = this.examineIfJavaScriptClass(className);
            this.knownJavaScriptClasses.put(className, known);
        }
        return known;
    }

    public boolean isJavaScriptImplementation(String className) {
        Boolean known = this.knownJavaScriptImplementations.get(className);
        if (known == null) {
            known = this.examineIfJavaScriptImplementation(className);
            this.knownJavaScriptImplementations.put(className, known);
        }
        return known;
    }

    private boolean examineIfJavaScriptClass(String className) {
        ClassReader cls = this.classSource.get(className);
        if (cls == null || !cls.hasModifier(ElementModifier.INTERFACE) && !cls.hasModifier(ElementModifier.ABSTRACT)) {
            return false;
        }
        for (String iface : cls.getInterfaces()) {
            if (!this.isJavaScriptClass(iface)) continue;
            return true;
        }
        return cls.getParent() != null && !cls.getParent().equals(cls.getName()) && this.isJavaScriptClass(cls.getParent());
    }

    private boolean examineIfJavaScriptImplementation(String className) {
        if (this.isJavaScriptClass(className)) {
            return false;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return false;
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && this.isJavaScriptClass(cls.getParent())) {
            return true;
        }
        for (String iface : cls.getInterfaces()) {
            if (!this.isJavaScriptClass(iface)) continue;
            return true;
        }
        return false;
    }
}

