/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.javascript.spi.GeneratedBy;
import org.teavm.javascript.spi.Sync;
import org.teavm.jso.JS;
import org.teavm.jso.JSArray;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSBooleanArray;
import org.teavm.jso.JSConstructor;
import org.teavm.jso.JSDoubleArray;
import org.teavm.jso.JSFunctor;
import org.teavm.jso.JSIndexer;
import org.teavm.jso.JSIntArray;
import org.teavm.jso.JSMethod;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;
import org.teavm.jso.JSStringArray;
import org.teavm.jso.plugin.FunctorImpl;
import org.teavm.jso.plugin.JSBodyGenerator;
import org.teavm.jso.plugin.JSBodyImpl;
import org.teavm.jso.plugin.NativeJavascriptClassRepository;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.ProgramReader;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.util.InstructionVariableMapper;
import org.teavm.model.util.ModelUtils;
import org.teavm.model.util.ProgramUtils;

class JavascriptNativeProcessor {
    private ClassReaderSource classSource;
    private Program program;
    private List<Instruction> replacement = new ArrayList<Instruction>();
    private NativeJavascriptClassRepository nativeRepos;
    private Diagnostics diagnostics;
    private int methodIndexGenerator;
    private Map<MethodReference, MethodReader> overridenMethodCache = new HashMap<MethodReference, MethodReader>();

    public JavascriptNativeProcessor(ClassReaderSource classSource) {
        this.classSource = classSource;
        this.nativeRepos = new NativeJavascriptClassRepository(classSource);
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public boolean isNative(String className) {
        return this.nativeRepos.isJavaScriptClass(className);
    }

    public boolean isNativeImplementation(String className) {
        return this.nativeRepos.isJavaScriptImplementation(className);
    }

    public void setDiagnostics(Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
    }

    public MethodReference isFunctor(String className) {
        if (!this.nativeRepos.isJavaScriptImplementation(className)) {
            return null;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return null;
        }
        HashMap<MethodDescriptor, MethodReference> methods = new HashMap<MethodDescriptor, MethodReference>();
        this.getFunctorMethods(className, new HashSet<String>(), methods);
        if (methods.size() == 1) {
            return (MethodReference)methods.values().iterator().next();
        }
        return null;
    }

    private void getFunctorMethods(String className, Set<String> visited, Map<MethodDescriptor, MethodReference> methods) {
        MethodReference method;
        if (!visited.add(className)) {
            return;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return;
        }
        if (cls.getAnnotations().get(JSFunctor.class.getName()) != null && this.isProperFunctor(cls) && !methods.containsKey((method = ((MethodReader)cls.getMethods().iterator().next()).getReference()).getDescriptor())) {
            methods.put(method.getDescriptor(), method);
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName())) {
            this.getFunctorMethods(cls.getParent(), visited, methods);
        }
        for (String iface : cls.getInterfaces()) {
            this.getFunctorMethods(iface, visited, methods);
        }
    }

    public void processClass(ClassHolder cls) {
        HashSet<MethodDescriptor> preservedMethods = new HashSet<MethodDescriptor>();
        for (String iface : cls.getInterfaces()) {
            if (!this.nativeRepos.isJavaScriptClass(iface)) continue;
            this.addPreservedMethods(iface, preservedMethods);
        }
    }

    private void addPreservedMethods(String ifaceName, Set<MethodDescriptor> methods) {
        ClassReader iface = this.classSource.get(ifaceName);
        for (MethodReader method : iface.getMethods()) {
            methods.add(method.getDescriptor());
        }
        for (String superIfaceName : iface.getInterfaces()) {
            this.addPreservedMethods(superIfaceName, methods);
        }
    }

    public void processFinalMethods(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            int i;
            if (method.hasModifier(ElementModifier.STATIC) || !method.hasModifier(ElementModifier.FINAL) || method.getProgram() == null || method.getProgram().basicBlockCount() <= 0) continue;
            ValueType[] staticSignature = JavascriptNativeProcessor.getStaticSignature(method.getReference());
            MethodHolder callerMethod = new MethodHolder(new MethodDescriptor(method.getName() + "$static", staticSignature));
            callerMethod.getModifiers().add(ElementModifier.STATIC);
            final Program program = ProgramUtils.copy((ProgramReader)method.getProgram());
            program.createVariable();
            InstructionVariableMapper variableMapper = new InstructionVariableMapper(){

                protected Variable map(Variable var) {
                    return program.variableAt(var.getIndex() + 1);
                }
            };
            for (i = program.variableCount() - 1; i > 0; --i) {
                program.variableAt(i).getDebugNames().addAll(program.variableAt(i - 1).getDebugNames());
                program.variableAt(i - 1).getDebugNames().clear();
            }
            for (i = 0; i < program.basicBlockCount(); ++i) {
                BasicBlock block = program.basicBlockAt(i);
                for (Instruction insn : block.getInstructions()) {
                    insn.acceptVisitor((InstructionVisitor)variableMapper);
                }
                for (Phi phi : block.getPhis()) {
                    phi.setReceiver(program.variableAt(phi.getReceiver().getIndex() + 1));
                    for (Incoming incoming : phi.getIncomings()) {
                        incoming.setValue(program.variableAt(incoming.getValue().getIndex() + 1));
                    }
                }
                for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                    if (tryCatch.getExceptionVariable() == null) continue;
                    tryCatch.setExceptionVariable(program.variableAt(tryCatch.getExceptionVariable().getIndex() + 1));
                }
            }
            callerMethod.setProgram(program);
            ModelUtils.copyAnnotations((AnnotationContainerReader)method.getAnnotations(), (AnnotationContainer)callerMethod.getAnnotations());
            cls.addMethod(callerMethod);
        }
    }

    private MethodReader getOverridenMethod(MethodReader finalMethod) {
        MethodReference ref = finalMethod.getReference();
        if (!this.overridenMethodCache.containsKey(ref)) {
            this.overridenMethodCache.put(ref, this.findOverridenMethod(finalMethod.getOwnerName(), finalMethod));
        }
        return this.overridenMethodCache.get(ref);
    }

    private MethodReader findOverridenMethod(String className, MethodReader finalMethod) {
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return null;
        }
        MethodReader method = cls.getMethod(finalMethod.getDescriptor());
        if (method != null && !method.getOwnerName().equals(finalMethod.getOwnerName())) {
            return method;
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && (method = this.findOverridenMethod(cls.getParent(), finalMethod)) != null) {
            return method;
        }
        for (String iface : cls.getInterfaces()) {
            method = this.findOverridenMethod(iface, finalMethod);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public void addFunctorField(ClassHolder cls, MethodReference method) {
        if (cls.getAnnotations().get(FunctorImpl.class.getName()) != null) {
            return;
        }
        FieldHolder field = new FieldHolder("$$jso_functor$$");
        field.setLevel(AccessLevel.PUBLIC);
        field.setType(ValueType.parse(JSObject.class));
        cls.addField(field);
        AnnotationHolder annot = new AnnotationHolder(FunctorImpl.class.getName());
        annot.getValues().put("value", new AnnotationValue(method.getDescriptor().toString()));
        cls.getAnnotations().add(annot);
    }

    public void makeSync(ClassHolder cls) {
        HashSet<MethodDescriptor> methods = new HashSet<MethodDescriptor>();
        this.findInheritedMethods((ClassReader)cls, methods, new HashSet<String>());
        for (MethodHolder method : cls.getMethods()) {
            if (!methods.contains(method.getDescriptor()) || method.getAnnotations().get(Sync.class.getName()) != null) continue;
            AnnotationHolder annot = new AnnotationHolder(Sync.class.getName());
            method.getAnnotations().add(annot);
        }
    }

    private void findInheritedMethods(ClassReader cls, Set<MethodDescriptor> methods, Set<String> visited) {
        block5: {
            ClassReader parentCls;
            block4: {
                if (!visited.add(cls.getName())) {
                    return;
                }
                if (!this.isNative(cls.getName())) break block4;
                for (MethodReader method : cls.getMethods()) {
                    if (method.hasModifier(ElementModifier.STATIC) || method.hasModifier(ElementModifier.FINAL) || method.getLevel() == AccessLevel.PRIVATE) continue;
                    methods.add(method.getDescriptor());
                }
                break block5;
            }
            if (!this.isNativeImplementation(cls.getName())) break block5;
            if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && (parentCls = this.classSource.get(cls.getParent())) != null) {
                this.findInheritedMethods(parentCls, methods, visited);
            }
            for (String iface : cls.getInterfaces()) {
                ClassReader parentCls2 = this.classSource.get(iface);
                if (parentCls2 == null) continue;
                this.findInheritedMethods(parentCls2, methods, visited);
            }
        }
    }

    private static ValueType[] getStaticSignature(MethodReference method) {
        ValueType[] signature = method.getSignature();
        ValueType[] staticSignature = new ValueType[signature.length + 1];
        for (int i = 0; i < signature.length; ++i) {
            staticSignature[i + 1] = signature[i];
        }
        staticSignature[0] = ValueType.object((String)method.getClassName());
        return staticSignature;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void processProgram(MethodHolder methodToProcess) {
        this.program = methodToProcess.getProgram();
        int i = 0;
        while (i < this.program.basicBlockCount()) {
            BasicBlock block = this.program.basicBlockAt(i);
            List instructions = block.getInstructions();
            for (int j = 0; j < instructions.size(); ++j) {
                block26: {
                    CallLocation callLocation;
                    MethodReader method;
                    InvokeInstruction invoke;
                    block28: {
                        block27: {
                            String propertyName;
                            AnnotationReader annot;
                            Instruction insn = (Instruction)instructions.get(j);
                            if (!(insn instanceof InvokeInstruction) || !this.nativeRepos.isJavaScriptClass((invoke = (InvokeInstruction)insn).getMethod().getClassName())) continue;
                            this.replacement.clear();
                            method = this.getMethod(invoke.getMethod());
                            if (method == null || method.hasModifier(ElementModifier.STATIC)) continue;
                            if (method.hasModifier(ElementModifier.FINAL)) {
                                MethodReader overriden = this.getOverridenMethod(method);
                                if (overriden != null) {
                                    CallLocation callLocation2 = new CallLocation(methodToProcess.getReference(), insn.getLocation());
                                    this.diagnostics.error(callLocation2, "JS final method {{m0}} overrides {{M1}}. Overriding final method of overlay types is prohibited.", new Object[]{method.getReference(), overriden.getReference()});
                                }
                                if (method.getProgram() != null && method.getProgram().basicBlockCount() > 0) {
                                    invoke.setMethod(new MethodReference(method.getOwnerName(), method.getName() + "$static", JavascriptNativeProcessor.getStaticSignature(method.getReference())));
                                    invoke.getArguments().add(0, invoke.getInstance());
                                    invoke.setInstance(null);
                                }
                                invoke.setType(InvocationType.SPECIAL);
                                continue;
                            }
                            callLocation = new CallLocation(methodToProcess.getReference(), insn.getLocation());
                            if (method.getAnnotations().get(JSProperty.class.getName()) == null) break block27;
                            if (this.isProperGetter(method.getDescriptor())) {
                                annot = method.getAnnotations().get(JSProperty.class.getName());
                                propertyName = annot.getValue("value") != null ? annot.getValue("value").getString() : (method.getName().charAt(0) == 'i' ? this.cutPrefix(method.getName(), 2) : this.cutPrefix(method.getName(), 3));
                                Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
                                this.addPropertyGet(propertyName, invoke.getInstance(), result, invoke.getLocation());
                                if (result != null) {
                                    result = this.unwrap(callLocation, result, method.getResultType());
                                    this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
                                }
                                break block26;
                            } else if (this.isProperSetter(method.getDescriptor())) {
                                annot = method.getAnnotations().get(JSProperty.class.getName());
                                propertyName = annot.getValue("value") != null ? annot.getValue("value").getString() : this.cutPrefix(method.getName(), 3);
                                Variable wrapped = this.wrapArgument(callLocation, (Variable)invoke.getArguments().get(0), method.parameterType(0));
                                this.addPropertySet(propertyName, invoke.getInstance(), wrapped, invoke.getLocation());
                                break block26;
                            } else {
                                this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript property declaration", new Object[]{invoke.getMethod()});
                                continue;
                            }
                        }
                        if (method.getAnnotations().get(JSIndexer.class.getName()) == null) break block28;
                        if (this.isProperGetIndexer(method.getDescriptor())) {
                            Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
                            this.addIndexerGet(invoke.getInstance(), this.wrap((Variable)invoke.getArguments().get(0), method.parameterType(0), invoke.getLocation()), result, invoke.getLocation());
                            if (result != null) {
                                result = this.unwrap(callLocation, result, method.getResultType());
                                this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
                            }
                            break block26;
                        } else if (this.isProperSetIndexer(method.getDescriptor())) {
                            Variable index = this.wrap((Variable)invoke.getArguments().get(0), method.parameterType(0), invoke.getLocation());
                            Variable value = this.wrap((Variable)invoke.getArguments().get(1), method.parameterType(1), invoke.getLocation());
                            this.addIndexerSet(invoke.getInstance(), index, value, invoke.getLocation());
                            break block26;
                        } else {
                            this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript indexer declaration", new Object[]{invoke.getMethod()});
                            continue;
                        }
                    }
                    String name = method.getName();
                    AnnotationReader constructorAnnot = method.getAnnotations().get(JSConstructor.class.getName());
                    boolean isConstructor = false;
                    if (constructorAnnot != null) {
                        if (!this.isSupportedType(method.getResultType())) {
                            this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript constructor declaration", new Object[]{invoke.getMethod()});
                            continue;
                        }
                        AnnotationValue nameVal = constructorAnnot.getValue("value");
                        String string = name = nameVal != null ? constructorAnnot.getValue("value").getString() : "";
                        if (name.isEmpty()) {
                            if (!method.getName().startsWith("new") || method.getName().length() == 3) {
                                this.diagnostics.error(callLocation, "Method {{m0}} is not declared as a native JavaScript constructor, but its name does not satisfy conventions", new Object[]{invoke.getMethod()});
                                continue;
                            }
                            name = method.getName().substring(3);
                        }
                        isConstructor = true;
                    } else {
                        AnnotationValue redefinedMethodName;
                        ValueType[] methodAnnot = method.getAnnotations().get(JSMethod.class.getName());
                        if (methodAnnot != null && (redefinedMethodName = methodAnnot.getValue("value")) != null) {
                            name = redefinedMethodName.getString();
                        }
                        if (method.getResultType() != ValueType.VOID && !this.isSupportedType(method.getResultType())) {
                            this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method declaration", new Object[]{invoke.getMethod()});
                            continue;
                        }
                    }
                    for (ValueType arg : method.getParameterTypes()) {
                        if (this.isSupportedType(arg)) continue;
                        this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method or constructor declaration", new Object[]{invoke.getMethod()});
                    }
                    Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
                    InvokeInstruction newInvoke = new InvokeInstruction();
                    Object[] signature = new ValueType[method.parameterCount() + 3];
                    Arrays.fill(signature, ValueType.object((String)JSObject.class.getName()));
                    newInvoke.setMethod(new MethodReference(JS.class.getName(), isConstructor ? "instantiate" : "invoke", (ValueType[])signature));
                    newInvoke.setType(InvocationType.SPECIAL);
                    newInvoke.setReceiver(result);
                    newInvoke.getArguments().add(invoke.getInstance());
                    newInvoke.getArguments().add(this.addStringWrap(this.addString(name, invoke.getLocation()), invoke.getLocation()));
                    newInvoke.setLocation(invoke.getLocation());
                    for (int k = 0; k < invoke.getArguments().size(); ++k) {
                        Variable arg = this.wrapArgument(callLocation, (Variable)invoke.getArguments().get(k), method.parameterType(k));
                        newInvoke.getArguments().add(arg);
                    }
                    this.replacement.add((Instruction)newInvoke);
                    if (result != null) {
                        result = this.unwrap(callLocation, result, method.getResultType());
                        this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
                    }
                }
                block.getInstructions().set(j, this.replacement.get(0));
                block.getInstructions().addAll(j + 1, this.replacement.subList(1, this.replacement.size()));
                j += this.replacement.size() - 1;
            }
            ++i;
        }
        return;
    }

    public void processJSBody(ClassHolder cls, MethodHolder methodToProcess) {
        CallLocation location = new CallLocation(methodToProcess.getReference());
        boolean isStatic = methodToProcess.hasModifier(ElementModifier.STATIC);
        AnnotationHolder bodyAnnot = methodToProcess.getAnnotations().get(JSBody.class.getName());
        int jsParamCount = bodyAnnot.getValue("params").getList().size();
        if (methodToProcess.parameterCount() != jsParamCount) {
            this.diagnostics.error(location, "JSBody method {{m0}} declares " + methodToProcess.parameterCount() + " parameters, but annotation specifies " + jsParamCount, new Object[]{methodToProcess});
            return;
        }
        methodToProcess.getAnnotations().remove(JSBody.class.getName());
        methodToProcess.getModifiers().remove(ElementModifier.NATIVE);
        int paramCount = methodToProcess.parameterCount();
        if (!isStatic) {
            ++paramCount;
        }
        ValueType[] paramTypes = new ValueType[paramCount];
        int offset = 0;
        if (!isStatic) {
            ValueType paramType = ValueType.object((String)cls.getName());
            paramTypes[offset++] = paramType;
            if (!this.isSupportedType(paramType)) {
                this.diagnostics.error(location, "Non-static JSBody method {{m0}} is owned by non-JS class {{c1}}", new Object[]{methodToProcess.getReference(), cls.getName()});
            }
        }
        if (methodToProcess.getResultType() != ValueType.VOID && !this.isSupportedType(methodToProcess.getResultType())) {
            this.diagnostics.error(location, "JSBody method {{m0}} returns unsupported type {{t1}}", new Object[]{methodToProcess.getReference(), methodToProcess.getResultType()});
        }
        for (int i = 0; i < methodToProcess.parameterCount(); ++i) {
            paramTypes[offset++] = methodToProcess.parameterType(i);
        }
        ValueType[] proxyParamTypes = new ValueType[paramCount + 1];
        for (int i = 0; i < paramCount; ++i) {
            proxyParamTypes[i] = ValueType.parse(JSObject.class);
        }
        proxyParamTypes[paramCount] = methodToProcess.getResultType() == ValueType.VOID ? ValueType.VOID : ValueType.parse(JSObject.class);
        MethodHolder proxyMethod = new MethodHolder("$js_body$_" + this.methodIndexGenerator++, proxyParamTypes);
        proxyMethod.getModifiers().add(ElementModifier.NATIVE);
        proxyMethod.getModifiers().add(ElementModifier.STATIC);
        AnnotationHolder genBodyAnnot = new AnnotationHolder(JSBodyImpl.class.getName());
        genBodyAnnot.getValues().put("script", bodyAnnot.getValue("script"));
        genBodyAnnot.getValues().put("params", bodyAnnot.getValue("params"));
        genBodyAnnot.getValues().put("isStatic", new AnnotationValue(isStatic));
        AnnotationHolder generatorAnnot = new AnnotationHolder(GeneratedBy.class.getName());
        generatorAnnot.getValues().put("value", new AnnotationValue(ValueType.parse(JSBodyGenerator.class)));
        proxyMethod.getAnnotations().add(genBodyAnnot);
        proxyMethod.getAnnotations().add(generatorAnnot);
        cls.addMethod(proxyMethod);
        this.program = new Program();
        BasicBlock block = this.program.createBasicBlock();
        ArrayList<Variable> params = new ArrayList<Variable>();
        for (int i = 0; i < paramCount; ++i) {
            params.add(this.program.createVariable());
        }
        if (isStatic) {
            this.program.createVariable();
        }
        methodToProcess.setProgram(this.program);
        this.replacement.clear();
        InvokeInstruction invoke = new InvokeInstruction();
        invoke.setType(InvocationType.SPECIAL);
        invoke.setMethod(proxyMethod.getReference());
        for (int i = 0; i < paramCount; ++i) {
            Variable var = this.program.variableAt(isStatic ? i + 1 : i);
            invoke.getArguments().add(this.wrapArgument(location, var, paramTypes[i]));
        }
        block.getInstructions().addAll(this.replacement);
        block.getInstructions().add(invoke);
        ExitInstruction exit = new ExitInstruction();
        if (methodToProcess.getResultType() != ValueType.VOID) {
            this.replacement.clear();
            Variable result = this.program.createVariable();
            invoke.setReceiver(result);
            exit.setValueToReturn(this.unwrap(location, result, methodToProcess.getResultType()));
            block.getInstructions().addAll(this.replacement);
        }
        block.getInstructions().add(exit);
    }

    private void addPropertyGet(String propertyName, Variable instance, Variable receiver, InstructionLocation location) {
        Variable nameVar = this.addStringWrap(this.addString(propertyName, location), location);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "get", new Class[]{JSObject.class, JSObject.class, JSObject.class}));
        insn.setReceiver(receiver);
        insn.getArguments().add(instance);
        insn.getArguments().add(nameVar);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addPropertySet(String propertyName, Variable instance, Variable value, InstructionLocation location) {
        Variable nameVar = this.addStringWrap(this.addString(propertyName, location), location);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "set", new Class[]{JSObject.class, JSObject.class, JSObject.class, Void.TYPE}));
        insn.getArguments().add(instance);
        insn.getArguments().add(nameVar);
        insn.getArguments().add(value);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addIndexerGet(Variable array, Variable index, Variable receiver, InstructionLocation location) {
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "get", new Class[]{JSObject.class, JSObject.class, JSObject.class}));
        insn.setReceiver(receiver);
        insn.getArguments().add(array);
        insn.getArguments().add(index);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addIndexerSet(Variable array, Variable index, Variable value, InstructionLocation location) {
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "set", new Class[]{JSObject.class, JSObject.class, JSObject.class, Void.TYPE}));
        insn.getArguments().add(array);
        insn.getArguments().add(index);
        insn.getArguments().add(value);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void copyVar(Variable a, Variable b, InstructionLocation location) {
        AssignInstruction insn = new AssignInstruction();
        insn.setAssignee(a);
        insn.setReceiver(b);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private Variable addStringWrap(Variable var, InstructionLocation location) {
        return this.wrap(var, ValueType.object((String)"java.lang.String"), location);
    }

    private Variable addString(String str, InstructionLocation location) {
        Variable var = this.program.createVariable();
        StringConstantInstruction nameInsn = new StringConstantInstruction();
        nameInsn.setReceiver(var);
        nameInsn.setConstant(str);
        nameInsn.setLocation(location);
        this.replacement.add((Instruction)nameInsn);
        return var;
    }

    private Variable unwrap(CallLocation location, Variable var, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return this.unwrap(var, "unwrapBoolean", ValueType.parse(JSObject.class), (ValueType)ValueType.BOOLEAN, location.getSourceLocation());
                }
                case BYTE: {
                    return this.unwrap(var, "unwrapByte", ValueType.parse(JSObject.class), (ValueType)ValueType.BYTE, location.getSourceLocation());
                }
                case SHORT: {
                    return this.unwrap(var, "unwrapShort", ValueType.parse(JSObject.class), (ValueType)ValueType.SHORT, location.getSourceLocation());
                }
                case INTEGER: {
                    return this.unwrap(var, "unwrapInt", ValueType.parse(JSObject.class), (ValueType)ValueType.INTEGER, location.getSourceLocation());
                }
                case CHARACTER: {
                    return this.unwrap(var, "unwrapCharacter", ValueType.parse(JSObject.class), (ValueType)ValueType.CHARACTER, location.getSourceLocation());
                }
                case DOUBLE: {
                    return this.unwrap(var, "unwrapDouble", ValueType.parse(JSObject.class), (ValueType)ValueType.DOUBLE, location.getSourceLocation());
                }
                case FLOAT: {
                    return this.unwrap(var, "unwrapFloat", ValueType.parse(JSObject.class), (ValueType)ValueType.FLOAT, location.getSourceLocation());
                }
            }
        } else if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            if (className.equals(JSObject.class.getName())) {
                return var;
            }
            if (className.equals("java.lang.String")) {
                return this.unwrap(var, "unwrapString", ValueType.parse(JSObject.class), ValueType.parse(String.class), location.getSourceLocation());
            }
            if (this.isNative(className)) {
                Variable result = this.program.createVariable();
                CastInstruction castInsn = new CastInstruction();
                castInsn.setReceiver(result);
                castInsn.setValue(var);
                castInsn.setTargetType(type);
                castInsn.setLocation(location.getSourceLocation());
                this.replacement.add((Instruction)castInsn);
                return result;
            }
        } else if (type instanceof ValueType.Array) {
            return this.unwrapArray(location, var, (ValueType.Array)type);
        }
        this.diagnostics.error(location, "Unsupported type: {{t0}}", new Object[]{type});
        return var;
    }

    private Variable unwrapArray(CallLocation location, Variable var, ValueType.Array type) {
        ValueType.Array itemType = type;
        int degree = 0;
        while (itemType instanceof ValueType.Array) {
            ++degree;
            itemType = itemType.getItemType();
        }
        if (degree > 3) {
            this.diagnostics.error(location, "Unsupported type: {{t0}}", new Object[]{type});
            return var;
        }
        if (itemType instanceof ValueType.Object) {
            String className = ((ValueType.Object)itemType).getClassName();
            if (className.equals("java.lang.String")) {
                String methodName = "unwrapStringArray";
                if (degree > 1) {
                    methodName = methodName + degree;
                }
                ValueType argType = degree == 1 ? ValueType.parse(JSStringArray.class) : ValueType.parse(JSArray.class);
                return this.unwrap(var, methodName, argType, (ValueType)type, location.getSourceLocation());
            }
            if (this.isNative(className)) {
                return this.unwrapObjectArray(location, var, degree, (ValueType)itemType, (ValueType)type);
            }
        }
        this.diagnostics.error(location, "Unsupported type: {{t0}}", new Object[]{type});
        return var;
    }

    private Variable unwrap(Variable var, String methodName, ValueType argType, ValueType resultType, InstructionLocation location) {
        if (!argType.isObject(JSObject.class.getName())) {
            Variable castValue = this.program.createVariable();
            CastInstruction castInsn = new CastInstruction();
            castInsn.setValue(var);
            castInsn.setReceiver(castValue);
            castInsn.setLocation(location);
            castInsn.setTargetType(argType);
            this.replacement.add((Instruction)castInsn);
            var = castValue;
        }
        Variable result = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(new MethodReference(JS.class.getName(), methodName, new ValueType[]{argType, resultType}));
        insn.getArguments().add(var);
        insn.setReceiver(result);
        insn.setType(InvocationType.SPECIAL);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
        return result;
    }

    private Variable unwrapObjectArray(CallLocation location, Variable var, int degree, ValueType itemType, ValueType expectedType) {
        String methodName = "unwrapArray";
        if (degree > 1) {
            methodName = methodName + degree;
        }
        ValueType resultType = ValueType.parse(JSObject.class);
        for (int i = 0; i < degree; ++i) {
            resultType = ValueType.arrayOf((ValueType)resultType);
        }
        Variable classVar = this.program.createVariable();
        ClassConstantInstruction classInsn = new ClassConstantInstruction();
        classInsn.setConstant(itemType);
        classInsn.setReceiver(classVar);
        classInsn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)classInsn);
        Variable castValue = this.program.createVariable();
        CastInstruction castInsn = new CastInstruction();
        castInsn.setValue(var);
        castInsn.setReceiver(castValue);
        castInsn.setLocation(location.getSourceLocation());
        castInsn.setTargetType(ValueType.parse(JSArray.class));
        this.replacement.add((Instruction)castInsn);
        var = castValue;
        Variable result = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(new MethodReference(JS.class.getName(), methodName, new ValueType[]{ValueType.parse(Class.class), ValueType.parse(JSArray.class), resultType}));
        insn.getArguments().add(classVar);
        insn.getArguments().add(var);
        insn.setReceiver(result);
        insn.setType(InvocationType.SPECIAL);
        insn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)insn);
        var = result;
        Variable castResult = this.program.createVariable();
        castInsn = new CastInstruction();
        castInsn.setValue(var);
        castInsn.setReceiver(castResult);
        castInsn.setLocation(location.getSourceLocation());
        castInsn.setTargetType(expectedType);
        this.replacement.add((Instruction)castInsn);
        var = castResult;
        return var;
    }

    private Variable wrapArgument(CallLocation location, Variable var, ValueType type) {
        String className;
        ClassReader cls;
        if (type instanceof ValueType.Object && (cls = this.classSource.get(className = ((ValueType.Object)type).getClassName())).getAnnotations().get(JSFunctor.class.getName()) != null) {
            return this.wrapFunctor(location, var, cls);
        }
        return this.wrap(var, type, location.getSourceLocation());
    }

    private boolean isProperFunctor(ClassReader type) {
        return type.hasModifier(ElementModifier.INTERFACE) && type.getMethods().size() == 1;
    }

    private Variable wrapFunctor(CallLocation location, Variable var, ClassReader type) {
        if (!this.isProperFunctor(type)) {
            this.diagnostics.error(location, "Wrong functor: {{c0}}", new Object[]{type.getName()});
            return var;
        }
        String name = ((MethodReader)type.getMethods().iterator().next()).getName();
        Variable functor = this.program.createVariable();
        Variable nameVar = this.addStringWrap(this.addString(name, location.getSourceLocation()), location.getSourceLocation());
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "function", new Class[]{JSObject.class, JSObject.class, JSObject.class}));
        insn.setReceiver(functor);
        insn.getArguments().add(var);
        insn.getArguments().add(nameVar);
        insn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)insn);
        return functor;
    }

    private Variable wrap(Variable var, ValueType type, InstructionLocation location) {
        String className;
        if (type instanceof ValueType.Object && !(className = ((ValueType.Object)type).getClassName()).equals("java.lang.String")) {
            return var;
        }
        Variable result = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(new MethodReference(JS.class.getName(), "wrap", new ValueType[]{this.getWrappedType(type), this.getWrapperType(type)}));
        insn.getArguments().add(var);
        insn.setReceiver(result);
        insn.setType(InvocationType.SPECIAL);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
        return result;
    }

    private ValueType getWrappedType(ValueType type) {
        if (type instanceof ValueType.Array) {
            ValueType itemType = ((ValueType.Array)type).getItemType();
            return ValueType.arrayOf((ValueType)this.getWrappedType(itemType));
        }
        if (type instanceof ValueType.Object) {
            if (type.isObject("java.lang.String")) {
                return type;
            }
            return ValueType.parse(JSObject.class);
        }
        return type;
    }

    private ValueType getWrapperType(ValueType type) {
        if (type instanceof ValueType.Array) {
            ValueType itemType = ((ValueType.Array)type).getItemType();
            if (itemType instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)itemType).getKind()) {
                    case BOOLEAN: {
                        return ValueType.parse(JSBooleanArray.class);
                    }
                    case BYTE: 
                    case SHORT: 
                    case INTEGER: 
                    case CHARACTER: {
                        return ValueType.parse(JSIntArray.class);
                    }
                    case DOUBLE: 
                    case FLOAT: {
                        return ValueType.parse(JSDoubleArray.class);
                    }
                }
                return ValueType.parse(JSArray.class);
            }
            if (itemType.isObject("java.lang.String")) {
                return ValueType.parse(JSStringArray.class);
            }
            return ValueType.parse(JSArray.class);
        }
        return ValueType.parse(JSObject.class);
    }

    private MethodReader getMethod(MethodReference ref) {
        ClassReader cls = this.classSource.get(ref.getClassName());
        MethodReader method = cls.getMethod(ref.getDescriptor());
        if (method != null) {
            return method;
        }
        for (String iface : cls.getInterfaces()) {
            method = this.getMethod(new MethodReference(iface, ref.getDescriptor()));
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private boolean isProperGetter(MethodDescriptor desc) {
        if (desc.parameterCount() > 0 || !this.isSupportedType(desc.getResultType())) {
            return false;
        }
        if (desc.getResultType().equals((Object)ValueType.BOOLEAN) && this.isProperPrefix(desc.getName(), "is")) {
            return true;
        }
        return this.isProperPrefix(desc.getName(), "get");
    }

    private boolean isProperSetter(MethodDescriptor desc) {
        if (desc.parameterCount() != 1 || !this.isSupportedType(desc.parameterType(0)) || desc.getResultType() != ValueType.VOID) {
            return false;
        }
        return this.isProperPrefix(desc.getName(), "set");
    }

    private boolean isProperPrefix(String name, String prefix) {
        if (!name.startsWith(prefix) || name.length() == prefix.length()) {
            return false;
        }
        char c = name.charAt(prefix.length());
        return Character.isUpperCase(c);
    }

    private boolean isProperGetIndexer(MethodDescriptor desc) {
        return desc.parameterCount() == 1 && this.isSupportedType(desc.parameterType(0)) && this.isSupportedType(desc.getResultType());
    }

    private boolean isProperSetIndexer(MethodDescriptor desc) {
        return desc.parameterCount() == 2 && this.isSupportedType(desc.parameterType(0)) && this.isSupportedType(desc.parameterType(0)) && desc.getResultType() == ValueType.VOID;
    }

    private String cutPrefix(String name, int prefixLength) {
        if (name.length() == prefixLength + 1) {
            return name.substring(prefixLength).toLowerCase();
        }
        char c = name.charAt(prefixLength + 1);
        if (Character.isUpperCase(c)) {
            return name.substring(prefixLength);
        }
        return Character.toLowerCase(name.charAt(prefixLength)) + name.substring(prefixLength + 1);
    }

    private boolean isSupportedType(ValueType type) {
        if (type == ValueType.VOID) {
            return false;
        }
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case LONG: {
                    return false;
                }
            }
            return true;
        }
        if (type instanceof ValueType.Array) {
            return this.isSupportedType(((ValueType.Array)type).getItemType());
        }
        if (type instanceof ValueType.Object) {
            String typeName = ((ValueType.Object)type).getClassName();
            return typeName.equals("java.lang.String") || this.nativeRepos.isJavaScriptClass(typeName);
        }
        return false;
    }
}

