/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.plugin;

import java.io.IOException;
import java.util.List;
import org.teavm.codegen.SourceWriter;
import org.teavm.javascript.spi.Generator;
import org.teavm.javascript.spi.GeneratorContext;
import org.teavm.jso.plugin.JSBodyImpl;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

public class JSBodyGenerator
implements Generator {
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        int i;
        ClassReader cls = context.getClassSource().get(methodRef.getClassName());
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        AnnotationReader annot = method.getAnnotations().get(JSBodyImpl.class.getName());
        boolean isStatic = annot.getValue("isStatic").getBoolean();
        List paramNames = annot.getValue("params").getList();
        int bodyParamCount = isStatic ? method.parameterCount() : method.parameterCount() - 1;
        writer.append("if (!").appendMethodBody(methodRef).append(".$native)").ws().append('{').indent().newLine();
        writer.appendMethodBody(methodRef).append(".$native").ws().append('=').ws().append("function(");
        int count = method.parameterCount();
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                writer.append(',').ws();
            }
            writer.append('_').append(context.getParameterName(i + 1));
        }
        writer.append(')').ws().append('{').softNewLine().indent();
        writer.append("return (function(");
        for (i = 0; i < bodyParamCount; ++i) {
            if (i > 0) {
                writer.append(',').ws();
            }
            String name = ((AnnotationValue)paramNames.get(i)).getString();
            writer.append(name);
        }
        writer.append(')').ws().append('{').softNewLine().indent();
        writer.append(annot.getValue("script").getString()).softNewLine();
        writer.outdent().append("})");
        if (!isStatic) {
            writer.append(".call");
        }
        writer.append('(');
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                writer.append(',').ws();
            }
            writer.append('_').append(context.getParameterName(i + 1));
        }
        writer.append(");").softNewLine();
        writer.outdent().append("};").softNewLine();
        writer.appendMethodBody(methodRef).ws().append('=').ws().appendMethodBody(methodRef).append(".$native;").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return ").appendMethodBody(methodRef).append('(');
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                writer.append(',').ws();
            }
            writer.append(context.getParameterName(i + 1));
        }
        writer.append(");").softNewLine();
    }
}

