/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.io.IOException;
import org.teavm.backend.javascript.rendering.Precedence;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.InjectorContext;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.jso.impl.JSWrapper;
import org.teavm.model.MethodReference;

public class JSWrapperGenerator
implements Injector,
DependencyPlugin {
    private DependencyNode externalClassesNode;

    public void generate(InjectorContext context, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "directJavaToJs": 
            case "directJsToJava": 
            case "dependencyJavaToJs": 
            case "dependencyJsToJava": 
            case "wrapperToJs": 
            case "jsToWrapper": {
                context.writeExpr(context.getArgument(0), context.getPrecedence());
                break;
            }
            case "isJava": {
                if (context.getPrecedence().ordinal() >= Precedence.COMPARISON.ordinal()) {
                    context.getWriter().append("(");
                }
                context.writeExpr(context.getArgument(0));
                context.getWriter().append(" instanceof ").append("$rt_objcls").append("()");
                if (context.getPrecedence().ordinal() < Precedence.COMPARISON.ordinal()) break;
                context.getWriter().append(")");
                break;
            }
            case "isJSImplementation": {
                if (context.getPrecedence().ordinal() >= Precedence.EQUALITY.ordinal()) {
                    context.getWriter().append("(");
                }
                context.writeExpr(context.getArgument(0), Precedence.MEMBER_ACCESS);
                context.getWriter().append("[").appendFunction("$rt_jso_marker").append("]").ws().append("===").ws().append("true");
                if (context.getPrecedence().ordinal() < Precedence.EQUALITY.ordinal()) break;
                context.getWriter().append(")");
            }
        }
    }

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        switch (method.getMethod().getName()) {
            case "jsToWrapper": {
                method.getResult().propagate(agent.getType(JSWrapper.class.getName()));
                break;
            }
            case "dependencyJavaToJs": {
                method.getVariable(1).connect(this.getExternalClassesNode(agent));
                break;
            }
            case "dependencyJsToJava": {
                this.getExternalClassesNode(agent).connect(method.getResult());
            }
        }
    }

    private DependencyNode getExternalClassesNode(DependencyAgent agent) {
        if (this.externalClassesNode == null) {
            this.externalClassesNode = agent.createNode();
        }
        return this.externalClassesNode;
    }
}

