/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.teavm.backend.javascript.rendering.JSParser;
import org.teavm.cache.IncrementalDependencyRegistration;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.NoSideEffects;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSByRef;
import org.teavm.jso.JSFunctor;
import org.teavm.jso.JSIndexer;
import org.teavm.jso.JSMethod;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;
import org.teavm.jso.impl.DynamicGenerator;
import org.teavm.jso.impl.DynamicInjector;
import org.teavm.jso.impl.JSBodyAstEmitter;
import org.teavm.jso.impl.JSBodyBloatedEmitter;
import org.teavm.jso.impl.JSBodyInlineUtil;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSMethods;
import org.teavm.jso.impl.JSType;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.jso.impl.JSTypeInference;
import org.teavm.jso.impl.JSValueMarshaller;
import org.teavm.jso.impl.JSWrapper;
import org.teavm.jso.impl.JavaInvocationProcessor;
import org.teavm.jso.impl.JsBodyImportInfo;
import org.teavm.jso.impl.TeaVMErrorReporter;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.Instruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ProgramReader;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.util.InstructionVariableMapper;
import org.teavm.model.util.ModelUtils;
import org.teavm.model.util.ProgramUtils;
import org.teavm.rhino.javascript.CompilerEnvirons;
import org.teavm.rhino.javascript.ErrorReporter;
import org.teavm.rhino.javascript.ast.AstNode;
import org.teavm.rhino.javascript.ast.AstRoot;
import org.teavm.rhino.javascript.ast.FunctionNode;

class JSClassProcessor {
    private static final String NO_SIDE_EFFECTS = NoSideEffects.class.getName();
    private static final MethodReference WRAP = new MethodReference(JSWrapper.class, "wrap", new Class[]{Object.class, Object.class});
    private static final MethodReference MAYBE_WRAP = new MethodReference(JSWrapper.class, "maybeWrap", new Class[]{Object.class, Object.class});
    private static final MethodReference UNWRAP = new MethodReference(JSWrapper.class, "unwrap", new Class[]{Object.class, JSObject.class});
    private static final MethodReference MAYBE_UNWRAP = new MethodReference(JSWrapper.class, "maybeUnwrap", new Class[]{Object.class, JSObject.class});
    private static final MethodReference IS_JS = new MethodReference(JSWrapper.class, "isJs", new Class[]{Object.class, Boolean.TYPE});
    private final ClassReaderSource classSource;
    private final JSBodyRepository repository;
    private final JavaInvocationProcessor javaInvocationProcessor;
    private Program program;
    private JSTypeInference types;
    private final List<Instruction> replacement = new ArrayList<Instruction>();
    private final JSTypeHelper typeHelper;
    private final Diagnostics diagnostics;
    private final Map<MethodReference, MethodReader> overriddenMethodCache = new HashMap<MethodReference, MethodReader>();
    private JSValueMarshaller marshaller;
    private IncrementalDependencyRegistration incrementalCache;

    JSClassProcessor(ClassReaderSource classSource, JSTypeHelper typeHelper, JSBodyRepository repository, Diagnostics diagnostics, IncrementalDependencyRegistration incrementalCache) {
        this.classSource = classSource;
        this.typeHelper = typeHelper;
        this.repository = repository;
        this.diagnostics = diagnostics;
        this.incrementalCache = incrementalCache;
        this.javaInvocationProcessor = new JavaInvocationProcessor(typeHelper, repository, classSource, diagnostics);
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    MethodReference isFunctor(String className) {
        if (!this.typeHelper.isJavaScriptImplementation(className)) {
            return null;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return null;
        }
        HashMap<MethodDescriptor, MethodReference> methods = new HashMap<MethodDescriptor, MethodReference>();
        this.getFunctorMethods(className, methods);
        if (methods.size() == 1) {
            return (MethodReference)methods.values().iterator().next();
        }
        return null;
    }

    private void getFunctorMethods(String className, Map<MethodDescriptor, MethodReference> methods) {
        this.classSource.getAncestors(className).forEach(cls -> {
            MethodReference method;
            if (cls.getAnnotations().get(JSFunctor.class.getName()) != null && this.marshaller.isProperFunctor((ClassReader)cls) && !methods.containsKey((method = ((MethodReader)cls.getMethods().iterator().next()).getReference()).getDescriptor())) {
                methods.put(method.getDescriptor(), method);
            }
        });
    }

    void processClass(ClassHolder cls) {
        HashSet<MethodDescriptor> preservedMethods = new HashSet<MethodDescriptor>();
        for (String iface : cls.getInterfaces()) {
            if (!this.typeHelper.isJavaScriptClass(iface)) continue;
            this.addPreservedMethods(iface, preservedMethods);
        }
    }

    private void addPreservedMethods(String ifaceName, Set<MethodDescriptor> methods) {
        ClassReader iface = this.classSource.get(ifaceName);
        for (MethodReader method : iface.getMethods()) {
            methods.add(method.getDescriptor());
        }
        for (String superIfaceName : iface.getInterfaces()) {
            this.addPreservedMethods(superIfaceName, methods);
        }
    }

    void processMemberMethods(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            int i;
            if (method.hasModifier(ElementModifier.STATIC) || method.getProgram() == null || method.getProgram().basicBlockCount() <= 0) continue;
            ValueType[] staticSignature = JSClassProcessor.getStaticSignature(method.getReference());
            MethodHolder callerMethod = new MethodHolder(new MethodDescriptor(method.getName() + "$static", staticSignature));
            callerMethod.getModifiers().add(ElementModifier.STATIC);
            Program program = ProgramUtils.copy((ProgramReader)method.getProgram());
            program.createVariable();
            InstructionVariableMapper variableMapper = new InstructionVariableMapper(var -> program.variableAt(var.getIndex() + 1));
            for (i = program.variableCount() - 1; i > 0; --i) {
                program.variableAt(i).setDebugName(program.variableAt(i - 1).getDebugName());
                program.variableAt(i).setLabel(program.variableAt(i - 1).getLabel());
            }
            for (i = 0; i < program.basicBlockCount(); ++i) {
                BasicBlock block = program.basicBlockAt(i);
                variableMapper.apply(block);
            }
            callerMethod.setProgram(program);
            ModelUtils.copyAnnotations((AnnotationContainerReader)method.getAnnotations(), (AnnotationContainer)callerMethod.getAnnotations());
            cls.addMethod(callerMethod);
        }
    }

    private MethodReader getOverriddenMethod(MethodReader finalMethod) {
        MethodReference ref = finalMethod.getReference();
        if (!this.overriddenMethodCache.containsKey(ref)) {
            this.overriddenMethodCache.put(ref, this.findOverriddenMethod(finalMethod.getOwnerName(), finalMethod));
        }
        return this.overriddenMethodCache.get(ref);
    }

    private MethodReader findOverriddenMethod(String className, MethodReader finalMethod) {
        if (finalMethod.getName().equals("<init>")) {
            return null;
        }
        return this.classSource.getAncestors(className).skip(1L).map(cls -> cls.getMethod(finalMethod.getDescriptor())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static ValueType[] getStaticSignature(MethodReference method) {
        ValueType[] signature = method.getSignature();
        ValueType[] staticSignature = new ValueType[signature.length + 1];
        for (int i = 0; i < signature.length; ++i) {
            staticSignature[i + 1] = signature[i];
        }
        staticSignature[0] = ValueType.object((String)method.getClassName());
        return staticSignature;
    }

    private void setCurrentProgram(Program program) {
        this.program = program;
        this.marshaller = new JSValueMarshaller(this.diagnostics, this.typeHelper, this.classSource, program, this.replacement);
    }

    void processProgram(MethodHolder methodToProcess) {
        this.setCurrentProgram(methodToProcess.getProgram());
        this.types = new JSTypeInference(this.typeHelper, this.classSource, this.program, methodToProcess.getReference());
        this.types.ensure();
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            BasicBlock block = this.program.basicBlockAt(i);
            for (Instruction insn : block) {
                if (insn instanceof CastInstruction) {
                    this.replacement.clear();
                    CallLocation callLocation = new CallLocation(methodToProcess.getReference(), insn.getLocation());
                    if (!this.processCast((CastInstruction)insn, callLocation)) continue;
                    insn.insertNextAll(this.replacement);
                    insn.delete();
                    continue;
                }
                if (insn instanceof IsInstanceInstruction) {
                    this.processIsInstance((IsInstanceInstruction)insn);
                    continue;
                }
                if (insn instanceof InvokeInstruction) {
                    InvokeInstruction invoke = (InvokeInstruction)insn;
                    MethodReader method = this.getMethod(invoke.getMethod().getClassName(), invoke.getMethod().getDescriptor());
                    if (method == null) continue;
                    this.processInvokeArgs(invoke, method);
                    CallLocation callLocation = new CallLocation(methodToProcess.getReference(), insn.getLocation());
                    this.replacement.clear();
                    if (!this.processInvocation(method, callLocation, invoke, methodToProcess)) continue;
                    insn.insertNextAll(this.replacement);
                    insn.delete();
                    continue;
                }
                if (insn instanceof PutFieldInstruction) {
                    this.processPutField((PutFieldInstruction)insn);
                    continue;
                }
                if (insn instanceof GetElementInstruction) {
                    this.processGetFromArray((GetElementInstruction)insn);
                    continue;
                }
                if (insn instanceof PutElementInstruction) {
                    this.processPutIntoArray((PutElementInstruction)insn);
                    continue;
                }
                if (insn instanceof ConstructArrayInstruction) {
                    this.processConstructArray((ConstructArrayInstruction)insn);
                    continue;
                }
                if (insn instanceof ExitInstruction) {
                    ExitInstruction exit = (ExitInstruction)insn;
                    exit.setValueToReturn(this.wrapJsAsJava(insn, exit.getValueToReturn(), methodToProcess.getResultType()));
                    continue;
                }
                if (!(insn instanceof ClassConstantInstruction)) continue;
                this.processClassConstant((ClassConstantInstruction)insn);
            }
        }
    }

    private void processInvokeArgs(InvokeInstruction invoke, MethodReader methodToInvoke) {
        if (this.typeHelper.isJavaScriptClass(invoke.getMethod().getClassName()) || methodToInvoke.getAnnotations().get(JSBody.class.getName()) != null) {
            return;
        }
        Variable[] newArgs = null;
        for (int i = 0; i < invoke.getArguments().size(); ++i) {
            ValueType type = invoke.getMethod().parameterType(i);
            Variable arg = (Variable)invoke.getArguments().get(i);
            Variable newArg = this.wrapJsAsJava((Instruction)invoke, arg, type);
            if (newArg == arg) continue;
            if (newArgs == null) {
                newArgs = invoke.getArguments().toArray(new Variable[0]);
            }
            newArgs[i] = newArg;
        }
        if (newArgs != null) {
            invoke.setArguments(newArgs);
        }
        if (invoke.getInstance() != null) {
            invoke.setInstance(this.wrapJsAsJava((Instruction)invoke, invoke.getInstance(), (ValueType)ValueType.object((String)invoke.getMethod().getClassName())));
        }
    }

    private void processPutField(PutFieldInstruction putField) {
        putField.setValue(this.wrapJsAsJava((Instruction)putField, putField.getValue(), putField.getFieldType()));
    }

    private void processGetFromArray(GetElementInstruction insn) {
        if (insn.getType() != ArrayElementType.OBJECT) {
            return;
        }
        JSType type = (JSType)this.types.typeOf(insn.getReceiver());
        if (type == JSType.JS || type == JSType.MIXED) {
            InvokeInstruction unwrap = new InvokeInstruction();
            unwrap.setType(InvocationType.SPECIAL);
            unwrap.setMethod(type == JSType.MIXED ? MAYBE_UNWRAP : UNWRAP);
            unwrap.setArguments(new Variable[]{this.program.createVariable()});
            unwrap.setReceiver(insn.getReceiver());
            unwrap.setLocation(insn.getLocation());
            insn.setReceiver((Variable)unwrap.getArguments().get(0));
            insn.insertNext((Instruction)unwrap);
        }
    }

    private void processPutIntoArray(PutElementInstruction insn) {
        if (insn.getType() != ArrayElementType.OBJECT) {
            return;
        }
        JSType type = (JSType)this.types.typeOf(insn.getValue());
        if (type == JSType.JS || type == JSType.MIXED) {
            InvokeInstruction wrap = new InvokeInstruction();
            wrap.setType(InvocationType.SPECIAL);
            wrap.setMethod(type == JSType.MIXED ? MAYBE_WRAP : WRAP);
            wrap.setArguments(new Variable[]{insn.getValue()});
            wrap.setReceiver(this.program.createVariable());
            wrap.setLocation(insn.getLocation());
            insn.setValue(wrap.getReceiver());
            insn.insertPrevious((Instruction)wrap);
        }
    }

    private void processConstructArray(ConstructArrayInstruction insn) {
        insn.setItemType(this.processType(insn.getItemType()));
    }

    private void processClassConstant(ClassConstantInstruction insn) {
        insn.setConstant(this.processType(insn.getConstant()));
    }

    private ValueType processType(ValueType type) {
        return JSClassProcessor.processType(this.typeHelper, type);
    }

    static ValueType processType(JSTypeHelper typeHelper, ValueType type) {
        ValueType originalType = type;
        int degree = 0;
        while (type instanceof ValueType.Array) {
            ++degree;
            type = ((ValueType.Array)type).getItemType();
        }
        if (!(type instanceof ValueType.Object)) {
            return originalType;
        }
        String className = ((ValueType.Object)type).getClassName();
        if (!typeHelper.isJavaScriptClass(className)) {
            return originalType;
        }
        type = ValueType.object((String)JSWrapper.class.getName());
        while (degree-- > 0) {
            type = ValueType.arrayOf((ValueType)type);
        }
        return type;
    }

    private boolean processCast(CastInstruction cast, CallLocation location) {
        if (!(cast.getTargetType() instanceof ValueType.Object)) {
            cast.setTargetType(this.processType(cast.getTargetType()));
            return false;
        }
        String targetClassName = ((ValueType.Object)cast.getTargetType()).getClassName();
        if (!this.typeHelper.isJavaScriptClass(targetClassName)) {
            return false;
        }
        cast.setValue(this.unwrapJavaToJs((Instruction)cast, cast.getValue()));
        ClassReader targetClass = this.classSource.get(targetClassName);
        if (targetClass.getAnnotations().get(JSFunctor.class.getName()) == null) {
            AssignInstruction assign = new AssignInstruction();
            assign.setLocation(location.getSourceLocation());
            assign.setAssignee(cast.getValue());
            assign.setReceiver(cast.getReceiver());
            this.replacement.add((Instruction)assign);
            return true;
        }
        Variable result = this.marshaller.unwrapFunctor(location, cast.getValue(), targetClass);
        AssignInstruction assign = new AssignInstruction();
        assign.setLocation(location.getSourceLocation());
        assign.setAssignee(result);
        assign.setReceiver(cast.getReceiver());
        this.replacement.add((Instruction)assign);
        return true;
    }

    private void processIsInstance(IsInstanceInstruction isInstance) {
        if (!(isInstance.getType() instanceof ValueType.Object)) {
            isInstance.setType(this.processType(isInstance.getType()));
            return;
        }
        String targetClassName = ((ValueType.Object)isInstance.getType()).getClassName();
        if (!this.typeHelper.isJavaScriptClass(targetClassName)) {
            return;
        }
        JSType type = (JSType)this.types.typeOf(isInstance.getValue());
        if (type == JSType.JS) {
            IntegerConstantInstruction replacement = new IntegerConstantInstruction();
            replacement.setConstant(1);
            replacement.setReceiver(isInstance.getReceiver());
            replacement.setLocation(isInstance.getLocation());
            isInstance.replace((Instruction)replacement);
            return;
        }
        InvokeInstruction replacement = new InvokeInstruction();
        replacement.setType(InvocationType.SPECIAL);
        replacement.setMethod(IS_JS);
        replacement.setArguments(new Variable[]{isInstance.getValue()});
        replacement.setReceiver(isInstance.getReceiver());
        replacement.setLocation(isInstance.getLocation());
        isInstance.replace((Instruction)replacement);
    }

    private Variable wrapJsAsJava(Instruction instruction, Variable var, ValueType type) {
        if (!(type instanceof ValueType.Object)) {
            return var;
        }
        String cls = ((ValueType.Object)type).getClassName();
        if (this.typeHelper.isJavaScriptClass(cls)) {
            return var;
        }
        JSType varType = (JSType)this.types.typeOf(var);
        if (varType != JSType.JS && varType != JSType.MIXED) {
            return var;
        }
        InvokeInstruction wrap = new InvokeInstruction();
        wrap.setType(InvocationType.SPECIAL);
        wrap.setMethod(varType == JSType.JS ? WRAP : MAYBE_WRAP);
        wrap.setArguments(new Variable[]{var});
        wrap.setReceiver(this.program.createVariable());
        wrap.setLocation(instruction.getLocation());
        instruction.insertPrevious((Instruction)wrap);
        return wrap.getReceiver();
    }

    private Variable unwrapJavaToJs(Instruction instruction, Variable var) {
        JSType varType = (JSType)this.types.typeOf(var);
        if (varType != JSType.JAVA && varType != JSType.MIXED) {
            return var;
        }
        InvokeInstruction unwrap = new InvokeInstruction();
        unwrap.setType(InvocationType.SPECIAL);
        unwrap.setMethod(varType == JSType.JAVA ? UNWRAP : MAYBE_UNWRAP);
        unwrap.setArguments(new Variable[]{var});
        unwrap.setReceiver(this.program.createVariable());
        unwrap.setLocation(instruction.getLocation());
        instruction.insertPrevious((Instruction)unwrap);
        return unwrap.getReceiver();
    }

    private boolean processInvocation(MethodReader method, CallLocation callLocation, InvokeInstruction invoke, MethodHolder methodToProcess) {
        if (method.getAnnotations().get(JSBody.class.getName()) != null) {
            return this.processJSBodyInvocation(method, callLocation, invoke, methodToProcess);
        }
        if (!this.typeHelper.isJavaScriptClass(invoke.getMethod().getClassName())) {
            return false;
        }
        if (method.hasModifier(ElementModifier.STATIC)) {
            return false;
        }
        if (method.getProgram() != null && method.getProgram().basicBlockCount() > 0) {
            MethodReader overridden = this.getOverriddenMethod(method);
            if (overridden != null) {
                this.diagnostics.error(callLocation, "JS final method {{m0}} overrides {{m1}}. Overriding final method of overlay types is prohibited.", new Object[]{method.getReference(), overridden.getReference()});
            }
            if (method.getProgram() != null && method.getProgram().basicBlockCount() > 0) {
                invoke.setMethod(new MethodReference(method.getOwnerName(), method.getName() + "$static", JSClassProcessor.getStaticSignature(method.getReference())));
                Variable[] newArguments = new Variable[invoke.getArguments().size() + 1];
                newArguments[0] = invoke.getInstance();
                for (int i = 0; i < invoke.getArguments().size(); ++i) {
                    newArguments[i + 1] = (Variable)invoke.getArguments().get(i);
                }
                invoke.setArguments(newArguments);
                invoke.setInstance(null);
            }
            invoke.setType(InvocationType.SPECIAL);
            return false;
        }
        if (method.getAnnotations().get(JSProperty.class.getName()) != null) {
            return this.processProperty(method, callLocation, invoke);
        }
        if (method.getAnnotations().get(JSIndexer.class.getName()) != null) {
            return this.processIndexer(method, callLocation, invoke);
        }
        return this.processMethod(method, callLocation, invoke);
    }

    private boolean processJSBodyInvocation(MethodReader method, CallLocation callLocation, InvokeInstruction invoke, MethodHolder methodToProcess) {
        boolean returnByRef;
        boolean[] byRefParams = new boolean[method.parameterCount()];
        this.validateSignature(method, callLocation, byRefParams);
        if (invoke.getInstance() != null && !this.typeHelper.isSupportedType((ValueType)ValueType.object((String)method.getOwnerName()))) {
            this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method declaration. It is non-static and declared on a non-overlay class {{c1}}", new Object[]{invoke.getMethod(), method.getOwnerName()});
        }
        boolean bl = returnByRef = method.getAnnotations().get(JSByRef.class.getName()) != null;
        if (returnByRef && !this.typeHelper.isSupportedByRefType(method.getResultType())) {
            this.diagnostics.error(callLocation, "Method {{m0}} is marked with @JSByRef, but does not return valid array type", new Object[]{method.getReference()});
            return false;
        }
        this.requireJSBody(this.diagnostics, method);
        MethodReference delegate = this.repository.methodMap.get(method.getReference());
        if (delegate == null) {
            return false;
        }
        Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
        InvokeInstruction newInvoke = new InvokeInstruction();
        newInvoke.setMethod(delegate);
        newInvoke.setType(InvocationType.SPECIAL);
        newInvoke.setReceiver(result);
        newInvoke.setLocation(invoke.getLocation());
        ArrayList<Variable> newArgs = new ArrayList<Variable>();
        if (invoke.getInstance() != null) {
            Variable arg = invoke.getInstance();
            arg = this.marshaller.wrapArgument(callLocation, arg, (ValueType)ValueType.object((String)method.getOwnerName()), (JSType)this.types.typeOf(arg), false);
            newArgs.add(arg);
        }
        for (int i = 0; i < invoke.getArguments().size(); ++i) {
            Variable arg = (Variable)invoke.getArguments().get(i);
            arg = this.marshaller.wrapArgument(callLocation, (Variable)invoke.getArguments().get(i), method.parameterType(i), (JSType)this.types.typeOf(arg), byRefParams[i]);
            newArgs.add(arg);
        }
        newInvoke.setArguments(newArgs.toArray(new Variable[0]));
        this.replacement.add((Instruction)newInvoke);
        if (result != null) {
            result = this.marshaller.unwrapReturnValue(callLocation, result, method.getResultType(), returnByRef, this.canBeOnlyJava(invoke.getReceiver()));
            this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
        }
        this.incrementalCache.addDependencies(methodToProcess.getReference(), new String[]{method.getOwnerName()});
        return true;
    }

    private boolean processProperty(MethodReader method, CallLocation callLocation, InvokeInstruction invoke) {
        boolean pure;
        boolean bl = pure = method.getAnnotations().get(NO_SIDE_EFFECTS) != null;
        if (this.isProperGetter(method)) {
            String propertyName = this.extractSuggestedPropertyName(method);
            if (propertyName == null) {
                propertyName = method.getName().charAt(0) == 'i' ? JSClassProcessor.cutPrefix(method.getName(), 2) : JSClassProcessor.cutPrefix(method.getName(), 3);
            }
            Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
            this.addPropertyGet(propertyName, invoke.getInstance(), result, invoke.getLocation(), pure);
            if (result != null) {
                result = this.marshaller.unwrapReturnValue(callLocation, result, method.getResultType(), false, this.canBeOnlyJava(invoke.getReceiver()));
                this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
            }
            return true;
        }
        if (this.isProperSetter(method)) {
            String propertyName = this.extractSuggestedPropertyName(method);
            if (propertyName == null) {
                propertyName = JSClassProcessor.cutPrefix(method.getName(), 3);
            }
            Variable value = (Variable)invoke.getArguments().get(0);
            value = this.marshaller.wrapArgument(callLocation, value, method.parameterType(0), (JSType)this.types.typeOf(value), false);
            this.addPropertySet(propertyName, invoke.getInstance(), value, invoke.getLocation(), pure);
            return true;
        }
        this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript property declaration", new Object[]{invoke.getMethod()});
        return false;
    }

    private String extractSuggestedPropertyName(MethodReader method) {
        AnnotationReader annot = method.getAnnotations().get(JSProperty.class.getName());
        AnnotationValue value = annot.getValue("value");
        return value != null ? value.getString() : null;
    }

    private boolean processIndexer(MethodReader method, CallLocation callLocation, InvokeInstruction invoke) {
        if (this.isProperGetIndexer(method.getDescriptor())) {
            Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
            Variable index = (Variable)invoke.getArguments().get(0);
            this.addIndexerGet(invoke.getInstance(), this.marshaller.wrapArgument(callLocation, index, method.parameterType(0), (JSType)this.types.typeOf(index), false), result, invoke.getLocation());
            if (result != null) {
                result = this.marshaller.unwrapReturnValue(callLocation, result, method.getResultType(), false, this.canBeOnlyJava(invoke.getReceiver()));
                this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
            }
            return true;
        }
        if (this.isProperSetIndexer(method.getDescriptor())) {
            Variable index = (Variable)invoke.getArguments().get(0);
            index = this.marshaller.wrapArgument(callLocation, index, method.parameterType(0), (JSType)this.types.typeOf(index), false);
            Variable value = (Variable)invoke.getArguments().get(1);
            value = this.marshaller.wrapArgument(callLocation, value, method.parameterType(1), (JSType)this.types.typeOf(value), false);
            this.addIndexerSet(invoke.getInstance(), index, value, invoke.getLocation());
            return true;
        }
        this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript indexer declaration", new Object[]{invoke.getMethod()});
        return false;
    }

    private boolean validateSignature(MethodReader method, CallLocation callLocation, boolean[] byRefParams) {
        if (method.getResultType() != ValueType.VOID && !this.typeHelper.isSupportedType(method.getResultType())) {
            this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method declaration, since it returns wrong type", new Object[]{method.getReference()});
            return false;
        }
        ValueType[] parameterTypes = method.getParameterTypes();
        AnnotationContainerReader[] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ValueType paramType = parameterTypes[i];
            if (!this.typeHelper.isSupportedType(paramType)) {
                this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method declaration: its " + (i + 1) + "th parameter has wrong type", new Object[]{method.getReference()});
                return false;
            }
            if (parameterAnnotations[i].get(JSByRef.class.getName()) == null) continue;
            if (!this.typeHelper.isSupportedByRefType(paramType)) {
                this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method declaration: its " + (i + 1) + "th parameter is declared as JSByRef, which has incompatible type", new Object[]{method.getReference()});
                return false;
            }
            byRefParams[i] = true;
        }
        return true;
    }

    private boolean canBeOnlyJava(Variable variable) {
        JSType type = (JSType)this.types.typeOf(variable);
        return type != JSType.JS && type != JSType.MIXED;
    }

    private boolean processMethod(MethodReader method, CallLocation callLocation, InvokeInstruction invoke) {
        boolean[] byRefParams;
        AnnotationValue redefinedMethodName;
        String name = method.getName();
        AnnotationReader methodAnnot = method.getAnnotations().get(JSMethod.class.getName());
        if (methodAnnot != null && (redefinedMethodName = methodAnnot.getValue("value")) != null) {
            name = redefinedMethodName.getString();
        }
        if (!this.validateSignature(method, callLocation, byRefParams = new boolean[method.parameterCount() + 1])) {
            return false;
        }
        Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
        InvokeInstruction newInvoke = new InvokeInstruction();
        newInvoke.setMethod(JSMethods.invoke(method.parameterCount()));
        newInvoke.setType(InvocationType.SPECIAL);
        newInvoke.setReceiver(result);
        ArrayList<Variable> newArguments = new ArrayList<Variable>();
        newArguments.add(invoke.getInstance());
        newArguments.add(this.marshaller.addStringWrap(this.marshaller.addString(name, invoke.getLocation()), invoke.getLocation()));
        newInvoke.setLocation(invoke.getLocation());
        for (int i = 0; i < invoke.getArguments().size(); ++i) {
            Variable arg = (Variable)invoke.getArguments().get(i);
            arg = this.marshaller.wrapArgument(callLocation, arg, method.parameterType(i), (JSType)this.types.typeOf(arg), byRefParams[i]);
            newArguments.add(arg);
        }
        newInvoke.setArguments(newArguments.toArray(new Variable[0]));
        this.replacement.add((Instruction)newInvoke);
        if (result != null) {
            result = this.marshaller.unwrapReturnValue(callLocation, result, method.getResultType(), false, this.canBeOnlyJava(invoke.getReceiver()));
            this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
        }
        return true;
    }

    private void requireJSBody(Diagnostics diagnostics, MethodReader methodToProcess) {
        if (!this.repository.processedMethods.add(methodToProcess.getReference())) {
            return;
        }
        this.processJSBody(diagnostics, methodToProcess);
    }

    private void processJSBody(Diagnostics diagnostics, MethodReader methodToProcess) {
        JsBodyImportInfo[] imports;
        AstRoot rootNode;
        ValueType.Object paramType;
        int jsParamCount;
        CallLocation location = new CallLocation(methodToProcess.getReference());
        boolean isStatic = methodToProcess.hasModifier(ElementModifier.STATIC);
        AnnotationReader bodyAnnot = methodToProcess.getAnnotations().get(JSBody.class.getName());
        AnnotationValue paramsValue = bodyAnnot.getValue("params");
        int n = jsParamCount = paramsValue != null ? paramsValue.getList().size() : 0;
        if (methodToProcess.parameterCount() != jsParamCount) {
            diagnostics.error(location, "JSBody method {{m0}} declares " + methodToProcess.parameterCount() + " parameters, but annotation specifies " + jsParamCount, new Object[]{methodToProcess.getReference()});
            return;
        }
        int paramCount = methodToProcess.parameterCount();
        if (!isStatic) {
            ++paramCount;
        }
        if (!isStatic && !this.typeHelper.isSupportedType((ValueType)(paramType = ValueType.object((String)methodToProcess.getOwnerName())))) {
            diagnostics.error(location, "Non-static JSBody method {{m0}} is owned by non-JS class {{c1}}", new Object[]{methodToProcess.getReference(), methodToProcess.getOwnerName()});
        }
        if (methodToProcess.getResultType() != ValueType.VOID && !this.typeHelper.isSupportedType(methodToProcess.getResultType())) {
            diagnostics.error(location, "JSBody method {{m0}} returns unsupported type {{t1}}", new Object[]{methodToProcess.getReference(), methodToProcess.getResultType()});
        }
        ValueType[] proxyParamTypes = new ValueType[paramCount + 1];
        for (int i = 0; i < paramCount; ++i) {
            proxyParamTypes[i] = ValueType.parse(JSObject.class);
        }
        proxyParamTypes[paramCount] = methodToProcess.getResultType() == ValueType.VOID ? ValueType.VOID : ValueType.parse(JSObject.class);
        ClassReader ownerClass = this.classSource.get(methodToProcess.getOwnerName());
        int methodIndex = this.indexOfMethod(ownerClass, methodToProcess);
        MethodReference proxyMethod = new MethodReference(methodToProcess.getOwnerName(), methodToProcess.getName() + "$js_body$_" + methodIndex, proxyParamTypes);
        String script = bodyAnnot.getValue("script").getString();
        String[] parameterNames = paramsValue != null ? (String[])paramsValue.getList().stream().map(AnnotationValue::getString).toArray(String[]::new) : new String[]{};
        TeaVMErrorReporter errorReporter = new TeaVMErrorReporter(diagnostics, new CallLocation(methodToProcess.getReference()));
        CompilerEnvirons env = new CompilerEnvirons();
        env.setRecoverFromErrors(true);
        env.setLanguageVersion(180);
        env.setIdeMode(true);
        JSParser parser = new JSParser(env, (ErrorReporter)errorReporter);
        try {
            rootNode = (AstRoot)parser.parseAsObject((Reader)new StringReader("function(){" + script + "}"), null, 0);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error occurred", e);
        }
        AstNode body = ((FunctionNode)rootNode.getFirstChild()).getBody();
        AnnotationValue importsValue = bodyAnnot.getValue("imports");
        if (importsValue != null) {
            List importsList = importsValue.getList();
            imports = new JsBodyImportInfo[importsList.size()];
            for (int i = 0; i < importsList.size(); ++i) {
                AnnotationReader importAnnot = ((AnnotationValue)importsList.get(0)).getAnnotation();
                imports[i] = new JsBodyImportInfo(importAnnot.getValue("alias").getString(), importAnnot.getValue("fromModule").getString());
            }
        } else {
            imports = new JsBodyImportInfo[]{};
        }
        this.repository.methodMap.put(methodToProcess.getReference(), proxyMethod);
        if (errorReporter.hasErrors()) {
            this.repository.emitters.put(proxyMethod, new JSBodyBloatedEmitter(isStatic, proxyMethod, script, parameterNames, imports));
        } else {
            AstNode expr = JSBodyInlineUtil.isSuitableForInlining(methodToProcess.getReference(), parameterNames, body);
            if (expr != null) {
                this.repository.inlineMethods.add(methodToProcess.getReference());
            } else {
                expr = body;
            }
            this.javaInvocationProcessor.process(location, expr);
            JSBodyAstEmitter emitter = new JSBodyAstEmitter(isStatic, expr, (AstNode)rootNode, parameterNames, imports);
            this.repository.emitters.put(proxyMethod, emitter);
        }
        if (imports.length > 0) {
            this.repository.imports.put(proxyMethod, imports);
        }
    }

    private int indexOfMethod(ClassReader cls, MethodReader method) {
        int index = 0;
        for (MethodReader m : cls.getMethods()) {
            if (m.getDescriptor().equals((Object)method.getDescriptor())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    void createJSMethods(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            boolean inline;
            MethodReference methodRef = method.getReference();
            if (method.getAnnotations().get(JSBody.class.getName()) == null) continue;
            this.requireJSBody(this.diagnostics, (MethodReader)method);
            if (!this.repository.methodMap.containsKey(method.getReference())) continue;
            MethodReference proxyRef = this.repository.methodMap.get(methodRef);
            MethodHolder proxyMethod = new MethodHolder(proxyRef.getDescriptor());
            proxyMethod.getModifiers().add(ElementModifier.NATIVE);
            proxyMethod.getModifiers().add(ElementModifier.STATIC);
            if (method.getAnnotations().get(NoSideEffects.class.getName()) != null) {
                proxyMethod.getAnnotations().add(new AnnotationHolder(NoSideEffects.class.getName()));
            }
            AnnotationHolder generatorAnnot = new AnnotationHolder((inline = this.repository.inlineMethods.contains(methodRef)) ? DynamicInjector.class.getName() : DynamicGenerator.class.getName());
            proxyMethod.getAnnotations().add(generatorAnnot);
            cls.addMethod(proxyMethod);
            Set<MethodReference> callbacks = this.repository.callbackMethods.get(proxyRef);
            if (callbacks == null) continue;
            for (MethodReference callback : callbacks) {
                this.generateCallbackCaller(cls, callback);
            }
        }
    }

    private void generateCallbackCaller(ClassHolder cls, MethodReference callback) {
        MethodReference calleeRef = this.repository.callbackCallees.get(callback);
        MethodReader callee = this.classSource.resolve(calleeRef);
        MethodHolder callerMethod = new MethodHolder(callback.getDescriptor());
        callerMethod.getModifiers().add(ElementModifier.STATIC);
        CallLocation location = new CallLocation(callback);
        this.setCurrentProgram(new Program());
        for (int i = 0; i <= callback.parameterCount(); ++i) {
            this.program.createVariable();
        }
        BasicBlock block = this.program.createBasicBlock();
        int paramIndex = 1;
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(calleeRef);
        this.replacement.clear();
        if (!callee.hasModifier(ElementModifier.STATIC)) {
            insn.setInstance(this.marshaller.unwrapReturnValue(location, this.program.variableAt(paramIndex++), (ValueType)ValueType.object((String)calleeRef.getClassName()), false, true));
        }
        Variable[] args = new Variable[callee.parameterCount()];
        for (int i = 0; i < callee.parameterCount(); ++i) {
            args[i] = this.marshaller.unwrapReturnValue(location, this.program.variableAt(paramIndex++), callee.parameterType(i), false, true);
        }
        insn.setArguments(args);
        if (callee.getResultType() != ValueType.VOID) {
            insn.setReceiver(this.program.createVariable());
        }
        block.addAll(this.replacement);
        block.add((Instruction)insn);
        ExitInstruction exit = new ExitInstruction();
        if (insn.getReceiver() != null) {
            this.replacement.clear();
            exit.setValueToReturn(this.marshaller.wrap(insn.getReceiver(), callee.getResultType(), JSType.MIXED, null, false));
            block.addAll(this.replacement);
        }
        block.add((Instruction)exit);
        callerMethod.setProgram(this.program);
        cls.addMethod(callerMethod);
        this.processProgram(callerMethod);
    }

    private void addPropertyGet(String propertyName, Variable instance, Variable receiver, TextLocation location, boolean pure) {
        Variable nameVar = this.marshaller.addStringWrap(this.marshaller.addString(propertyName, location), location);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(pure ? JSMethods.GET_PURE : JSMethods.GET);
        insn.setReceiver(receiver);
        insn.setArguments(new Variable[]{instance, nameVar});
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addPropertySet(String propertyName, Variable instance, Variable value, TextLocation location, boolean pure) {
        Variable nameVar = this.marshaller.addStringWrap(this.marshaller.addString(propertyName, location), location);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(pure ? JSMethods.SET_PURE : JSMethods.SET);
        insn.setArguments(new Variable[]{instance, nameVar, value});
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addIndexerGet(Variable array, Variable index, Variable receiver, TextLocation location) {
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(JSMethods.GET);
        insn.setReceiver(receiver);
        insn.setArguments(new Variable[]{array, index});
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addIndexerSet(Variable array, Variable index, Variable value, TextLocation location) {
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(JSMethods.SET);
        insn.setArguments(new Variable[]{array, index, value});
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void copyVar(Variable a, Variable b, TextLocation location) {
        AssignInstruction insn = new AssignInstruction();
        insn.setAssignee(a);
        insn.setReceiver(b);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private MethodReader getMethod(String className, MethodDescriptor descriptor) {
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return null;
        }
        MethodReader method = cls.getMethod(descriptor);
        if (method != null) {
            return method;
        }
        if (cls.getParent() != null && !cls.getParent().equals("java.lang.Object") && (method = this.getMethod(cls.getParent(), descriptor)) != null) {
            return method;
        }
        for (String iface : cls.getInterfaces()) {
            method = this.getMethod(iface, descriptor);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private boolean isProperGetter(MethodReader method) {
        if (method.parameterCount() > 0 || !this.typeHelper.isSupportedType(method.getResultType())) {
            return false;
        }
        if (this.extractSuggestedPropertyName(method) != null) {
            return true;
        }
        if (method.getResultType().equals(ValueType.BOOLEAN) && this.isProperPrefix(method.getName(), "is")) {
            return true;
        }
        return this.isProperPrefix(method.getName(), "get");
    }

    private boolean isProperSetter(MethodReader method) {
        if (method.parameterCount() != 1 || !this.typeHelper.isSupportedType(method.parameterType(0)) || method.getResultType() != ValueType.VOID) {
            return false;
        }
        return this.extractSuggestedPropertyName(method) != null || this.isProperPrefix(method.getName(), "set");
    }

    private boolean isProperPrefix(String name, String prefix) {
        if (!name.startsWith(prefix) || name.length() == prefix.length()) {
            return false;
        }
        char c = name.charAt(prefix.length());
        return Character.isUpperCase(c) || !Character.isAlphabetic(c) && Character.isJavaIdentifierStart(c);
    }

    private boolean isProperGetIndexer(MethodDescriptor desc) {
        return desc.parameterCount() == 1 && this.typeHelper.isSupportedType(desc.parameterType(0)) && this.typeHelper.isSupportedType(desc.getResultType());
    }

    private boolean isProperSetIndexer(MethodDescriptor desc) {
        return desc.parameterCount() == 2 && this.typeHelper.isSupportedType(desc.parameterType(0)) && this.typeHelper.isSupportedType(desc.parameterType(1)) && desc.getResultType() == ValueType.VOID;
    }

    private static String cutPrefix(String name, int prefixLength) {
        if (name.length() == prefixLength + 1) {
            return name.substring(prefixLength).toLowerCase();
        }
        char c = name.charAt(prefixLength + 1);
        if (Character.isUpperCase(c)) {
            return name.substring(prefixLength);
        }
        return Character.toLowerCase(name.charAt(prefixLength)) + name.substring(prefixLength + 1);
    }
}

