/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.interop.NoSideEffects;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSObject;
import org.teavm.jso.core.JSBoolean;
import org.teavm.jso.core.JSFinalizationRegistry;
import org.teavm.jso.core.JSMap;
import org.teavm.jso.core.JSNumber;
import org.teavm.jso.core.JSObjects;
import org.teavm.jso.core.JSString;
import org.teavm.jso.core.JSWeakMap;
import org.teavm.jso.core.JSWeakRef;

public final class JSWrapper {
    private static final JSWeakMap<JSObject, JSNumber> hashCodes = JSWeakMap.create();
    private static final JSWeakMap<JSObject, JSWeakRef<JSObject>> wrappers = JSWeakRef.isSupported() ? JSWeakMap.create() : null;
    private static final JSMap<JSString, JSWeakRef<JSObject>> stringWrappers = JSWeakRef.isSupported() ? JSMap.create() : null;
    private static final JSMap<JSNumber, JSWeakRef<JSObject>> numberWrappers = JSWeakRef.isSupported() ? JSMap.create() : null;
    private static final JSFinalizationRegistry stringFinalizationRegistry = stringWrappers != null ? JSFinalizationRegistry.create(token -> stringWrappers.delete((JSObject)((JSString)token))) : null;
    private static final JSFinalizationRegistry numberFinalizationRegistry = numberWrappers != null ? JSFinalizationRegistry.create(token -> numberWrappers.delete((JSObject)((JSNumber)token))) : null;
    private static int hashCodeGen;
    public final JSObject js;

    private JSWrapper(JSObject js) {
        this.js = js;
    }

    public static Object wrap(Object o) {
        if (o == null) {
            return null;
        }
        JSObject js = JSWrapper.directJavaToJs(o);
        if (wrappers != null) {
            String type = JSObjects.typeOf((Object)js);
            if (type.equals("object") || type.equals("function")) {
                JSObject existing;
                JSWeakRef<JSObject> existingRef = JSWrapper.get(wrappers, js);
                JSObject jSObject = existing = !JSObjects.isUndefined(existingRef) ? JSWrapper.deref(existingRef) : JSObjects.undefined();
                if (JSObjects.isUndefined((Object)existing)) {
                    JSWrapper wrapper = new JSWrapper(js);
                    JSWrapper.set(wrappers, js, JSWrapper.createWeakRef(JSWrapper.wrapperToJs(wrapper)));
                    return wrapper;
                }
                return JSWrapper.jsToWrapper(existing);
            }
            if (type.equals("string")) {
                JSObject existing;
                JSString jsString = (JSString)js;
                JSWeakRef<JSObject> existingRef = JSWrapper.get(stringWrappers, (JSObject)jsString);
                JSObject jSObject = existing = !JSObjects.isUndefined(existingRef) ? JSWrapper.deref(existingRef) : JSObjects.undefined();
                if (JSObjects.isUndefined((Object)existing)) {
                    JSWrapper wrapper = new JSWrapper(js);
                    JSObject wrapperAsJs = JSWrapper.wrapperToJs(wrapper);
                    JSWrapper.set(stringWrappers, (JSObject)jsString, JSWrapper.createWeakRef(wrapperAsJs));
                    JSWrapper.register(stringFinalizationRegistry, wrapperAsJs, (JSObject)jsString);
                    return wrapper;
                }
                return JSWrapper.jsToWrapper(existing);
            }
            if (type.equals("number")) {
                JSObject existing;
                JSNumber jsNumber = (JSNumber)js;
                JSWeakRef<JSObject> existingRef = JSWrapper.get(numberWrappers, (JSObject)jsNumber);
                JSObject jSObject = existing = !JSObjects.isUndefined(existingRef) ? JSWrapper.deref(existingRef) : JSObjects.undefined();
                if (JSObjects.isUndefined((Object)existing)) {
                    JSWrapper wrapper = new JSWrapper(js);
                    JSObject wrapperAsJs = JSWrapper.wrapperToJs(wrapper);
                    JSWrapper.set(numberWrappers, (JSObject)jsNumber, JSWrapper.createWeakRef(wrapperAsJs));
                    JSWrapper.register(numberFinalizationRegistry, wrapperAsJs, (JSObject)jsNumber);
                    return wrapper;
                }
                return JSWrapper.jsToWrapper(existing);
            }
        }
        return new JSWrapper(js);
    }

    @JSBody(params={"target"}, script="return new WeakRef(target);")
    @NoSideEffects
    private static native JSWeakRef<JSObject> createWeakRef(JSObject var0);

    @JSBody(params={"target"}, script="return target.deref();")
    @NoSideEffects
    private static native JSObject deref(JSWeakRef<JSObject> var0);

    @JSBody(params={"registry", "target", "token"}, script="return registry.register(target, token);")
    @NoSideEffects
    private static native void register(JSFinalizationRegistry var0, JSObject var1, JSObject var2);

    @JSBody(params={"map", "key"}, script="return map.get(key);")
    @NoSideEffects
    private static native JSWeakRef<JSObject> get(JSMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1);

    @JSBody(params={"map", "key", "value"}, script="map.set(key, value);")
    @NoSideEffects
    private static native void set(JSMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1, JSObject var2);

    @JSBody(params={"map", "key"}, script="return map.get(key);")
    @NoSideEffects
    private static native JSWeakRef<JSObject> get(JSWeakMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1);

    @JSBody(params={"map", "key", "value"}, script="map.set(key, value);")
    @NoSideEffects
    private static native void set(JSWeakMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1, JSObject var2);

    @NoSideEffects
    public static Object maybeWrap(Object o) {
        return o == null || JSWrapper.isJava(o) ? o : JSWrapper.wrap(o);
    }

    @NoSideEffects
    public static native JSObject directJavaToJs(Object var0);

    @NoSideEffects
    public static native Object directJsToJava(JSObject var0);

    @NoSideEffects
    public static native JSObject dependencyJavaToJs(Object var0);

    @NoSideEffects
    public static native Object dependencyJsToJava(JSObject var0);

    @NoSideEffects
    private static native JSObject wrapperToJs(JSWrapper var0);

    @NoSideEffects
    private static native JSWrapper jsToWrapper(JSObject var0);

    @NoSideEffects
    public static native boolean isJava(Object var0);

    @NoSideEffects
    public static native boolean isJava(JSObject var0);

    public static JSObject unwrap(Object o) {
        if (o == null) {
            return null;
        }
        return ((JSWrapper)o).js;
    }

    public static JSObject maybeUnwrap(Object o) {
        if (o == null) {
            return null;
        }
        return JSWrapper.isJava(o) ? JSWrapper.unwrap(o) : JSWrapper.directJavaToJs(o);
    }

    public static JSObject javaToJs(Object o) {
        if (o == null) {
            return null;
        }
        return JSWrapper.isJava(o) && o instanceof JSWrapper ? JSWrapper.unwrap(o) : JSWrapper.dependencyJavaToJs(o);
    }

    public static Object jsToJava(JSObject o) {
        if (o == null) {
            return null;
        }
        return !JSWrapper.isJava(o) ? JSWrapper.wrap(JSWrapper.directJsToJava(o)) : JSWrapper.dependencyJsToJava(o);
    }

    public static boolean isJs(Object o) {
        if (o == null) {
            return false;
        }
        return !JSWrapper.isJava(o) || o instanceof JSWrapper;
    }

    public int hashCode() {
        String type = JSObjects.typeOf((Object)this.js);
        if (type.equals("object") || type.equals("symbol") || type.equals("function")) {
            JSNumber code = (JSNumber)hashCodes.get((Object)this.js);
            if (JSObjects.isUndefined((Object)code)) {
                code = JSNumber.valueOf((int)(++hashCodeGen));
                hashCodes.set((Object)this.js, (Object)code);
            }
            return code.intValue();
        }
        if (type.equals("number")) {
            return ((JSNumber)this.js).intValue();
        }
        if (type.equals("bigint")) {
            return JSWrapper.bigintTruncate(this.js);
        }
        if (type.equals("string")) {
            JSString s = (JSString)this.js;
            int hashCode = 0;
            for (int i = 0; i < s.getLength(); ++i) {
                hashCode = 31 * hashCode + s.charCodeAt(i);
            }
            return hashCode;
        }
        if (type.equals("boolean")) {
            return this.js == JSBoolean.valueOf((boolean)true) ? 1 : 0;
        }
        return 0;
    }

    @JSBody(params={"bigint"}, script="return BigInt.asIntN(bigint, 32);")
    @NoSideEffects
    private static native int bigintTruncate(JSObject var0);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSWrapper)) {
            return false;
        }
        return this.js == ((JSWrapper)obj).js;
    }

    public String toString() {
        return JSObjects.isUndefined((Object)this.js) ? "undefined" : JSObjects.toString((Object)this.js);
    }
}

