/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.HashMap;
import java.util.Map;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.rhino.javascript.ast.AstNode;
import org.teavm.rhino.javascript.ast.ExpressionStatement;
import org.teavm.rhino.javascript.ast.Name;
import org.teavm.rhino.javascript.ast.NodeVisitor;
import org.teavm.rhino.javascript.ast.ReturnStatement;

final class JSBodyInlineUtil {
    private static final int COMPLEXITY_THRESHOLD = 20;

    private JSBodyInlineUtil() {
    }

    public static AstNode isSuitableForInlining(MethodReference method, String[] parameters, AstNode ast) {
        AstNode statement = JSBodyInlineUtil.isSingleStatement(ast);
        if (statement == null) {
            return null;
        }
        AstNode expression = JSBodyInlineUtil.getExpression(method, statement);
        if (expression == null) {
            return null;
        }
        ComplexityCounter complexityCounter = new ComplexityCounter();
        expression.visit((NodeVisitor)complexityCounter);
        if (complexityCounter.hasUnsupportedConstructs || complexityCounter.getComplexity() > 20) {
            return null;
        }
        VariableUsageCounter usageCounter = new VariableUsageCounter();
        expression.visit((NodeVisitor)usageCounter);
        for (String param : parameters) {
            if (usageCounter.getUsage(param) <= 1) continue;
            return null;
        }
        return expression;
    }

    private static AstNode getExpression(MethodReference method, AstNode statement) {
        if (method.getReturnType() == ValueType.VOID) {
            if (statement instanceof ExpressionStatement) {
                return ((ExpressionStatement)statement).getExpression();
            }
        } else if (statement instanceof ReturnStatement) {
            return ((ReturnStatement)statement).getReturnValue();
        }
        return null;
    }

    private static AstNode isSingleStatement(AstNode ast) {
        if (ast.getFirstChild() == null || ast.getFirstChild().getNext() != null) {
            return null;
        }
        if (ast.getFirstChild().getType() == 133) {
            return JSBodyInlineUtil.isSingleStatement((AstNode)ast.getFirstChild());
        }
        return (AstNode)ast.getFirstChild();
    }

    static class ComplexityCounter
    implements NodeVisitor {
        private int complexity;
        boolean hasUnsupportedConstructs;

        ComplexityCounter() {
        }

        public int getComplexity() {
            return this.complexity;
        }

        public boolean visit(AstNode node) {
            ++this.complexity;
            switch (node.getType()) {
                case 66: 
                case 67: 
                case 113: {
                    this.hasUnsupportedConstructs = true;
                }
            }
            return true;
        }
    }

    static class VariableUsageCounter
    implements NodeVisitor {
        private Map<String, Integer> usages = new HashMap<String, Integer>();

        VariableUsageCounter() {
        }

        public int getUsage(String varName) {
            return this.usages.computeIfAbsent(varName, i -> 0);
        }

        public boolean visit(AstNode node) {
            Name name;
            if (node instanceof Name && !(name = (Name)node).isLocalName()) {
                String id = name.getIdentifier();
                this.usages.put(id, this.getUsage(id) + 1);
            }
            return true;
        }
    }
}

