/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.HashMap;
import java.util.Map;
import org.teavm.jso.JSObject;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.ValueType;

class JSTypeHelper {
    private ClassReaderSource classSource;
    private Map<String, Boolean> knownJavaScriptClasses = new HashMap<String, Boolean>();
    private Map<String, Boolean> knownJavaScriptImplementations = new HashMap<String, Boolean>();

    public JSTypeHelper(ClassReaderSource classSource) {
        this.classSource = classSource;
        this.knownJavaScriptClasses.put(JSObject.class.getName(), true);
    }

    public boolean isJavaScriptClass(String className) {
        return this.knownJavaScriptClasses.computeIfAbsent(className, k -> this.examineIfJavaScriptClass(className));
    }

    public boolean isJavaScriptImplementation(String className) {
        return this.knownJavaScriptImplementations.computeIfAbsent(className, k -> this.examineIfJavaScriptImplementation(className));
    }

    private boolean examineIfJavaScriptClass(String className) {
        ClassReader cls = this.classSource.get(className);
        if (cls == null || !cls.hasModifier(ElementModifier.INTERFACE) && !cls.hasModifier(ElementModifier.ABSTRACT)) {
            return false;
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && this.isJavaScriptClass(cls.getParent())) {
            return true;
        }
        return cls.getInterfaces().stream().anyMatch(this::isJavaScriptClass);
    }

    private boolean examineIfJavaScriptImplementation(String className) {
        if (this.isJavaScriptClass(className)) {
            return false;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return false;
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && this.isJavaScriptClass(cls.getParent())) {
            return true;
        }
        return cls.getInterfaces().stream().anyMatch(this::isJavaScriptClass);
    }

    public boolean isSupportedType(ValueType type) {
        if (type == ValueType.VOID) {
            return false;
        }
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case LONG: {
                    return false;
                }
            }
            return true;
        }
        if (type instanceof ValueType.Array) {
            return this.isSupportedType(((ValueType.Array)type).getItemType());
        }
        if (type instanceof ValueType.Object) {
            String typeName = ((ValueType.Object)type).getClassName();
            return typeName.equals("java.lang.String") || this.isJavaScriptClass(typeName);
        }
        return false;
    }

    public boolean isSupportedByRefType(ValueType type) {
        if (!(type instanceof ValueType.Array)) {
            return false;
        }
        ValueType itemType = ((ValueType.Array)type).getItemType();
        if (itemType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)itemType).getKind()) {
                case BYTE: 
                case SHORT: 
                case CHARACTER: 
                case INTEGER: 
                case FLOAT: 
                case DOUBLE: {
                    return true;
                }
            }
            return false;
        }
        if (itemType instanceof ValueType.Object) {
            return this.isJavaScriptClass(((ValueType.Object)itemType).getClassName());
        }
        return false;
    }
}

