/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.diagnostics.Diagnostics;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSClassProcessor;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;

public class JSObjectClassTransformer
implements ClassHolderTransformer {
    private JSClassProcessor processor;
    private JSBodyRepository repository;

    public JSObjectClassTransformer(JSBodyRepository repository) {
        this.repository = repository;
    }

    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        MethodReference functorMethod;
        if (this.processor == null || this.processor.getClassSource() != innerSource) {
            this.processor = new JSClassProcessor(innerSource, this.repository, diagnostics);
        }
        this.processor.processClass(cls);
        if (this.processor.isNative(cls.getName())) {
            this.processor.processMemberMethods(cls);
        }
        if (this.processor.isNativeImplementation(cls.getName())) {
            this.processor.makeSync(cls);
        }
        if ((functorMethod = this.processor.isFunctor(cls.getName())) != null && this.processor.isFunctor(cls.getParent()) == null) {
            this.processor.addFunctorField(cls, functorMethod);
        }
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            if (method.getProgram() == null) continue;
            this.processor.processProgram(method);
        }
        this.processor.createJSMethods(cls);
    }
}

