/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.io.IOException;
import org.mozilla.javascript.ast.AstNode;
import org.teavm.codegen.SourceWriter;
import org.teavm.javascript.Precedence;
import org.teavm.javascript.spi.GeneratorContext;
import org.teavm.javascript.spi.InjectorContext;
import org.teavm.jso.impl.AstWriter;
import org.teavm.jso.impl.JSBodyEmitter;
import org.teavm.model.MethodReference;

class JSBodyAstEmitter
implements JSBodyEmitter {
    private boolean isStatic;
    private AstNode ast;
    private String[] parameterNames;

    public JSBodyAstEmitter(boolean isStatic, AstNode ast, String[] parameterNames) {
        this.isStatic = isStatic;
        this.ast = ast;
        this.parameterNames = parameterNames;
    }

    @Override
    public void emit(InjectorContext context) throws IOException {
        AstWriter astWriter = new AstWriter(context.getWriter());
        int paramIndex = 0;
        if (!this.isStatic) {
            int index = paramIndex++;
            astWriter.declareNameEmitter("this", prec -> context.writeExpr(context.getArgument(index), JSBodyAstEmitter.convert(prec)));
        }
        for (int i = 0; i < this.parameterNames.length; ++i) {
            int index = paramIndex++;
            astWriter.declareNameEmitter(this.parameterNames[i], prec -> context.writeExpr(context.getArgument(index), JSBodyAstEmitter.convert(prec)));
        }
        astWriter.hoist(this.ast);
        astWriter.print(this.ast, JSBodyAstEmitter.convert(context.getPrecedence()));
    }

    private static int convert(Precedence precedence) {
        switch (precedence) {
            case ADDITION: {
                return 7;
            }
            case ASSIGNMENT: {
                return 17;
            }
            case BITWISE_AND: {
                return 11;
            }
            case BITWISE_OR: {
                return 13;
            }
            case BITWISE_XOR: {
                return 12;
            }
            case BITWISE_SHIFT: {
                return 8;
            }
            case COMMA: {
                return 18;
            }
            case COMPARISON: {
                return 9;
            }
            case CONDITIONAL: {
                return 16;
            }
            case EQUALITY: {
                return 10;
            }
            case FUNCTION_CALL: {
                return 3;
            }
            case GROUPING: {
                return 1;
            }
            case LOGICAL_AND: {
                return 14;
            }
            case LOGICAL_OR: {
                return 15;
            }
            case MEMBER_ACCESS: {
                return 2;
            }
            case MULTIPLICATION: {
                return 6;
            }
            case UNARY: {
                return 5;
            }
        }
        return 18;
    }

    private static Precedence convert(int precedence) {
        switch (precedence) {
            case 7: {
                return Precedence.ADDITION;
            }
            case 17: {
                return Precedence.ASSIGNMENT;
            }
            case 11: {
                return Precedence.BITWISE_AND;
            }
            case 13: {
                return Precedence.BITWISE_OR;
            }
            case 12: {
                return Precedence.BITWISE_XOR;
            }
            case 8: {
                return Precedence.BITWISE_SHIFT;
            }
            case 18: {
                return Precedence.COMMA;
            }
            case 9: {
                return Precedence.COMPARISON;
            }
            case 16: {
                return Precedence.CONDITIONAL;
            }
            case 10: {
                return Precedence.EQUALITY;
            }
            case 3: {
                return Precedence.FUNCTION_CALL;
            }
            case 1: {
                return Precedence.GROUPING;
            }
            case 14: {
                return Precedence.LOGICAL_AND;
            }
            case 15: {
                return Precedence.LOGICAL_OR;
            }
            case 2: {
                return Precedence.MEMBER_ACCESS;
            }
            case 6: {
                return Precedence.MULTIPLICATION;
            }
            case 5: {
                return Precedence.UNARY;
            }
        }
        return Precedence.min();
    }

    @Override
    public void emit(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        AstWriter astWriter = new AstWriter(writer);
        int paramIndex = 1;
        if (!this.isStatic) {
            int index = paramIndex++;
            astWriter.declareNameEmitter("this", prec -> writer.append(context.getParameterName(index)));
        }
        for (int i = 0; i < this.parameterNames.length; ++i) {
            int index = paramIndex++;
            astWriter.declareNameEmitter(this.parameterNames[i], prec -> writer.append(context.getParameterName(index)));
        }
        astWriter.hoist(this.ast);
        astWriter.print(this.ast);
        writer.softNewLine();
    }
}

