/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.io.IOException;
import org.teavm.codegen.SourceWriter;
import org.teavm.javascript.spi.GeneratorContext;
import org.teavm.javascript.spi.InjectorContext;
import org.teavm.jso.impl.JSBodyEmitter;
import org.teavm.model.MethodReference;

class JSBodyBloatedEmitter
implements JSBodyEmitter {
    private boolean isStatic;
    private MethodReference method;
    private String script;
    private String[] parameterNames;

    public JSBodyBloatedEmitter(boolean isStatic, MethodReference method, String script, String[] parameterNames) {
        this.isStatic = isStatic;
        this.method = method;
        this.script = script;
        this.parameterNames = parameterNames;
    }

    @Override
    public void emit(InjectorContext context) throws IOException {
        this.emit(context.getWriter(), index -> context.writeExpr(context.getArgument(index)));
    }

    @Override
    public void emit(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        this.emit(writer, index -> writer.append(context.getParameterName(index + 1)));
    }

    private void emit(SourceWriter writer, EmissionStrategy strategy) throws IOException {
        int i;
        int bodyParamCount = this.isStatic ? this.method.parameterCount() : this.method.parameterCount() - 1;
        writer.append("if (!").appendMethodBody(this.method).append(".$native)").ws().append('{').indent().newLine();
        writer.appendMethodBody(this.method).append(".$native").ws().append('=').ws().append("function(");
        int count = this.method.parameterCount();
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                writer.append(',').ws();
            }
            writer.append('_').append(i);
        }
        writer.append(')').ws().append('{').softNewLine().indent();
        writer.append("return (function(");
        for (i = 0; i < bodyParamCount; ++i) {
            if (i > 0) {
                writer.append(',').ws();
            }
            String name = this.parameterNames[i];
            writer.append(name);
        }
        writer.append(')').ws().append('{').softNewLine().indent();
        writer.append(this.script).softNewLine();
        writer.outdent().append("})");
        if (!this.isStatic) {
            writer.append(".call");
        }
        writer.append('(');
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                writer.append(',').ws();
            }
            writer.append('_').append(i);
        }
        writer.append(");").softNewLine();
        writer.outdent().append("};").softNewLine();
        writer.appendMethodBody(this.method).ws().append('=').ws().appendMethodBody(this.method).append(".$native;").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return ").appendMethodBody(this.method).append('(');
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                writer.append(',').ws();
            }
            strategy.emitArgument(i);
        }
        writer.append(");").softNewLine();
    }

    static interface EmissionStrategy {
        public void emitArgument(int var1) throws IOException;
    }
}

