/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.ast.Expr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmEntity;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExternConversion;
import org.teavm.backend.wasm.model.expression.WasmExternConversionType;
import org.teavm.backend.wasm.model.expression.WasmTest;
import org.teavm.jso.impl.JSMethods;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

class WasmGCJSWrapperIntrinsic
implements WasmGCIntrinsic {
    private WasmFunction wrapFunction;

    WasmGCJSWrapperIntrinsic() {
    }

    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "wrap": {
                WasmFunction function = this.getWrapFunction(context);
                return new WasmCall(function, new WasmExpression[]{context.generate((Expr)invocation.getArguments().get(0))});
            }
            case "isJava": {
                WasmExternConversion convert = new WasmExternConversion(WasmExternConversionType.EXTERN_TO_ANY, context.generate((Expr)invocation.getArguments().get(0)));
                WasmType objectType = context.typeMapper().mapType(ValueType.parse(Object.class));
                return new WasmTest((WasmExpression)convert, (WasmType.Reference)objectType);
            }
        }
        throw new IllegalArgumentException();
    }

    private WasmFunction getWrapFunction(WasmGCIntrinsicContext context) {
        if (this.wrapFunction == null) {
            WasmType objectType = context.typeMapper().mapType(ValueType.parse(Object.class));
            this.wrapFunction = new WasmFunction(context.functionTypes().of(objectType, new WasmType[]{WasmType.Reference.EXTERN}));
            this.wrapFunction.setImportName("wrapObject");
            this.wrapFunction.setImportModule("teavmJso");
            context.module().functions.add((WasmEntity)this.wrapFunction);
            WasmFunction createWrapperFunction = context.functions().forStaticMethod(new MethodReference("org.teavm.jso.impl.JSWrapper", "createWrapper", new ValueType[]{JSMethods.JS_OBJECT, JSMethods.OBJECT}));
            createWrapperFunction.setExportName("teavm.jso.createWrapper");
        }
        return this.wrapFunction;
    }
}

