/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import java.util.Arrays;
import org.teavm.backend.wasm.model.WasmEntity;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.jso.impl.wasmgc.WasmGCJsoContext;

class WasmGCJSFunctions {
    private WasmFunction[] constructors = new WasmFunction[32];
    private WasmFunction[] binds = new WasmFunction[32];
    private WasmFunction[] callers = new WasmFunction[32];
    private WasmFunction getFunction;

    WasmGCJSFunctions() {
    }

    WasmFunction getFunctionConstructor(WasmGCJsoContext context, int index) {
        WasmFunction function = this.constructors[index];
        if (function == null) {
            WasmType.SpecialReference extern = WasmType.SpecialReferenceKind.EXTERN.asNonNullType();
            Object[] constructorParamTypes = new WasmType[index + 1];
            Arrays.fill(constructorParamTypes, WasmType.Reference.EXTERN);
            WasmFunctionType functionType = context.functionTypes().of((WasmType)extern, (WasmType[])constructorParamTypes);
            function = new WasmFunction(functionType);
            function.setName(context.names().topLevel("teavm.js:createFunction" + index));
            function.setImportModule("teavmJso");
            function.setImportName("createFunction" + index);
            context.module().functions.add((WasmEntity)function);
            this.constructors[index] = function;
        }
        return function;
    }

    WasmFunction getBind(WasmGCJsoContext context, int index) {
        WasmFunction function = this.binds[index];
        if (function == null) {
            WasmType.SpecialReference extern = WasmType.SpecialReferenceKind.EXTERN.asNonNullType();
            Object[] constructorParamTypes = new WasmType[index + 1];
            Arrays.fill(constructorParamTypes, WasmType.Reference.EXTERN);
            WasmFunctionType functionType = context.functionTypes().of((WasmType)extern, (WasmType[])constructorParamTypes);
            function = new WasmFunction(functionType);
            function.setName(context.names().topLevel("teavm.js:bindFunction" + index));
            function.setImportModule("teavmJso");
            function.setImportName("bindFunction" + index);
            context.module().functions.add((WasmEntity)function);
            this.binds[index] = function;
        }
        return function;
    }

    WasmFunction getGet(WasmGCJsoContext context) {
        WasmFunction function = this.getFunction;
        if (function == null) {
            WasmFunctionType functionType = context.functionTypes().of((WasmType)WasmType.Reference.EXTERN, new WasmType[]{WasmType.Reference.EXTERN, WasmType.Reference.EXTERN});
            function = new WasmFunction(functionType);
            function.setName(context.names().topLevel("teavm.js:getProperty"));
            function.setImportModule("teavmJso");
            function.setImportName("getProperty");
            context.module().functions.add((WasmEntity)function);
            this.getFunction = function;
        }
        return function;
    }

    WasmFunction getFunctionCaller(WasmGCJsoContext context, int index) {
        WasmFunction function = this.callers[index];
        if (function == null) {
            Object[] paramTypes = new WasmType[index + 1];
            Arrays.fill(paramTypes, WasmType.Reference.EXTERN);
            WasmFunctionType functionType = context.functionTypes().of((WasmType)WasmType.Reference.EXTERN, (WasmType[])paramTypes);
            function = new WasmFunction(functionType);
            function.setName(context.names().topLevel("teavm.js:callFunction" + index));
            function.setImportModule("teavmJso");
            function.setImportName("callFunction" + index);
            context.module().functions.add((WasmEntity)function);
            this.callers[index] = function;
        }
        return function;
    }
}

