/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.jso.impl.JSClassToExpose;
import org.teavm.model.ClassReader;
import org.teavm.model.ValueType;

public class JSWrapperDependency
extends AbstractDependencyListener {
    private DependencyNode externalClassesNode;

    public void started(DependencyAgent agent) {
        this.externalClassesNode = agent.createNode();
    }

    public void classReached(DependencyAgent agent, String className) {
        ClassReader cls = agent.getClassSource().get(className);
        if (cls.getAnnotations().get(JSClassToExpose.class.getName()) != null) {
            this.externalClassesNode.propagate(agent.getType((ValueType)ValueType.object((String)className)));
        }
    }

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        if (method.getMethod().getOwnerName().equals("org.teavm.jso.impl.JSWrapper")) {
            switch (method.getMethod().getName()) {
                case "jsToWrapper": {
                    method.getResult().propagate(agent.getType((ValueType)ValueType.object((String)"org.teavm.jso.impl.JSWrapper")));
                    break;
                }
                case "dependencyJavaToJs": 
                case "marshallJavaToJs": {
                    method.getVariable(1).connect(this.externalClassesNode);
                    break;
                }
                case "dependencyJsToJava": 
                case "unmarshallJavaFromJs": {
                    this.externalClassesNode.connect(method.getResult());
                    break;
                }
                case "wrap": {
                    method.getResult().propagate(agent.getType((ValueType)ValueType.object((String)"org.teavm.jso.impl.JSWrapper")));
                    this.externalClassesNode.connect(method.getResult());
                }
            }
        }
    }
}

