/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.backend.javascript.TeaVMJavaScriptHost;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.MethodContributor;
import org.teavm.backend.wasm.gc.TeaVMWasmGCHost;
import org.teavm.dependency.DependencyListener;
import org.teavm.interop.PlatformMarker;
import org.teavm.jso.impl.DynamicGenerator;
import org.teavm.jso.impl.DynamicInjector;
import org.teavm.jso.impl.GeneratorAnnotationInstaller;
import org.teavm.jso.impl.JS;
import org.teavm.jso.impl.JSAliasRenderer;
import org.teavm.jso.impl.JSBodyGenerator;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSDependencyListener;
import org.teavm.jso.impl.JSExceptionsDependencyListener;
import org.teavm.jso.impl.JSExceptionsGenerator;
import org.teavm.jso.impl.JSExportedMethodAsFunction;
import org.teavm.jso.impl.JSMethods;
import org.teavm.jso.impl.JSObjectClassTransformer;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.jso.impl.JSWrapperDependency;
import org.teavm.jso.impl.JSWrapperGenerator;
import org.teavm.jso.impl.wasmgc.WasmGCJso;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.plugin.PlatformPlugin;
import org.teavm.vm.TeaVMPluginUtil;
import org.teavm.vm.spi.After;
import org.teavm.vm.spi.ClassFilter;
import org.teavm.vm.spi.ClassFilterContext;
import org.teavm.vm.spi.RendererListener;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

@After(value={PlatformPlugin.class})
public class JSOPlugin
implements TeaVMPlugin {
    public void install(TeaVMHost host) {
        TeaVMJavaScriptHost jsHost = (TeaVMJavaScriptHost)host.getExtension(TeaVMJavaScriptHost.class);
        TeaVMWasmGCHost wasmGCHost = (TeaVMWasmGCHost)host.getExtension(TeaVMWasmGCHost.class);
        if (jsHost == null && wasmGCHost == null) {
            return;
        }
        JSBodyRepository repository = new JSBodyRepository();
        host.registerService(JSBodyRepository.class, (Object)repository);
        JSObjectClassTransformer classTransformer = new JSObjectClassTransformer(repository);
        host.add((ClassHolderTransformer)classTransformer);
        JSDependencyListener dependencyListener = new JSDependencyListener(repository);
        host.add((DependencyListener)dependencyListener);
        host.add((DependencyListener)new JSExceptionsDependencyListener());
        host.addClassFilter(new ClassFilter(){
            JSTypeHelper helper;

            public boolean accept(ClassFilterContext context, ValueType type) {
                if (!(type instanceof ValueType.Object)) {
                    return true;
                }
                String className = ((ValueType.Object)type).getClassName();
                if (this.helper == null) {
                    this.helper = new JSTypeHelper(context.classes());
                }
                return !this.helper.isJavaScriptClass(className) || this.helper.isJavaScriptImplementation(className);
            }
        });
        JSWrapperDependency wrapperDependency = new JSWrapperDependency();
        host.add((DependencyListener)wrapperDependency);
        if (!JSOPlugin.isBootstrap()) {
            TeaVMPluginUtil.handleNatives((TeaVMHost)host, JS.class);
        }
        if (jsHost != null) {
            this.installForJS(jsHost);
        }
        if (wasmGCHost != null) {
            classTransformer.setClassFilter(n -> !n.startsWith("java."));
            classTransformer.forWasmGC();
            WasmGCJso.install(host, wasmGCHost, repository);
        }
    }

    private void installForJS(TeaVMJavaScriptHost jsHost) {
        JSAliasRenderer aliasRenderer = new JSAliasRenderer();
        jsHost.add((RendererListener)aliasRenderer);
        jsHost.addGeneratorProvider(new GeneratorAnnotationInstaller<JSBodyGenerator>(new JSBodyGenerator(), DynamicGenerator.class.getName()));
        jsHost.addInjectorProvider(new GeneratorAnnotationInstaller<JSBodyGenerator>(new JSBodyGenerator(), DynamicInjector.class.getName()));
        jsHost.addVirtualMethods((MethodContributor)aliasRenderer);
        jsHost.addForcedFunctionMethods((MethodContributor)new JSExportedMethodAsFunction());
        JSExceptionsGenerator exceptionsGenerator = new JSExceptionsGenerator();
        jsHost.add(new MethodReference("org.teavm.jso.JSExceptions", "getJavaException", new ValueType[]{JSMethods.JS_OBJECT, ValueType.object((String)"java.lang.Throwable")}), (Injector)exceptionsGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.JSExceptions", "getJSException", new ValueType[]{ValueType.object((String)"java.lang.Throwable"), JSMethods.JS_OBJECT}), (Injector)exceptionsGenerator);
        JSWrapperGenerator wrapperGenerator = new JSWrapperGenerator();
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "directJavaToJs", new ValueType[]{JSMethods.OBJECT, JSMethods.JS_OBJECT}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "directJsToJava", new ValueType[]{JSMethods.JS_OBJECT, JSMethods.OBJECT}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "dependencyJavaToJs", new ValueType[]{JSMethods.OBJECT, JSMethods.JS_OBJECT}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "dependencyJsToJava", new ValueType[]{JSMethods.JS_OBJECT, JSMethods.OBJECT}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "marshallJavaToJs", new ValueType[]{JSMethods.OBJECT, JSMethods.JS_OBJECT}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "unmarshallJavaFromJs", new ValueType[]{JSMethods.JS_OBJECT, JSMethods.OBJECT}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "isJava", new ValueType[]{JSMethods.OBJECT, ValueType.BOOLEAN}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "isJava", new ValueType[]{JSMethods.JS_OBJECT, ValueType.BOOLEAN}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "wrapperToJs", new ValueType[]{JSMethods.JS_WRAPPER, JSMethods.JS_OBJECT}), (Injector)wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "jsToWrapper", new ValueType[]{JSMethods.JS_OBJECT, JSMethods.JS_WRAPPER}), (Injector)wrapperGenerator);
    }

    @PlatformMarker
    private static boolean isBootstrap() {
        return false;
    }
}

