/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.Set;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.jso.JSExportClasses;
import org.teavm.jso.impl.JS;
import org.teavm.jso.impl.JSBodyDelegate;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSConstructorToExpose;
import org.teavm.jso.impl.JSGetterToExpose;
import org.teavm.jso.impl.JSMethodToExpose;
import org.teavm.jso.impl.JSSetterToExpose;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

class JSDependencyListener
extends AbstractDependencyListener {
    private JSBodyRepository repository;
    private DependencyNode exceptions;

    JSDependencyListener(JSBodyRepository repository) {
        this.repository = repository;
    }

    public void started(DependencyAgent agent) {
        this.exceptions = agent.createNode();
    }

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        MethodReference ref = method.getReference();
        Set<MethodReference> callbackMethods = this.repository.callbackMethods.get(ref);
        if (callbackMethods != null) {
            for (MethodReference callbackMethod : callbackMethods) {
                agent.linkMethod(callbackMethod).addLocation(new CallLocation(ref)).use();
            }
        }
        if (method.getMethod().getAnnotations().get(JSBodyDelegate.class.getName()) != null) {
            this.exceptions.connect(method.getThrown());
        }
        if (method.getMethod().getOwnerName().equals(JS.class.getName())) {
            switch (method.getMethod().getName()) {
                case "invoke": 
                case "construct": 
                case "apply": 
                case "get": 
                case "getPure": 
                case "set": 
                case "setPure": {
                    this.exceptions.connect(method.getThrown());
                }
            }
        }
    }

    public void classReached(DependencyAgent agent, String className) {
        ClassReader cls = agent.getClassSource().get(className);
        for (MethodReader method : cls.getMethods()) {
            MethodDependency methodDep;
            AnnotationReader exposeAnnot = method.getAnnotations().get(JSMethodToExpose.class.getName());
            if (exposeAnnot == null) {
                exposeAnnot = method.getAnnotations().get(JSGetterToExpose.class.getName());
            }
            if (exposeAnnot == null) {
                exposeAnnot = method.getAnnotations().get(JSSetterToExpose.class.getName());
            }
            if (exposeAnnot == null) {
                exposeAnnot = method.getAnnotations().get(JSConstructorToExpose.class.getName());
            }
            if (exposeAnnot == null || (methodDep = agent.linkMethod(method.getReference())).getMethod() == null) continue;
            methodDep.use();
            methodDep.getThrown().connect(this.exceptions);
        }
        AnnotationReader exportClassesAnnot = cls.getAnnotations().get(JSExportClasses.class.getName());
        if (exportClassesAnnot != null) {
            for (AnnotationValue classRef : exportClassesAnnot.getValue("value").getList()) {
                if (!(classRef.getJavaClass() instanceof ValueType.Object)) continue;
                String classRefName = ((ValueType.Object)classRef.getJavaClass()).getClassName();
                agent.linkClass(classRefName);
            }
        }
    }
}

