/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.ast.ConstantExpr;
import org.teavm.ast.Expr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmBlockType;
import org.teavm.backend.wasm.model.WasmEntity;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmIsNull;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.runtime.gc.WasmGCSupport;
import org.teavm.jso.impl.JSMethods;
import org.teavm.jso.impl.wasmgc.WasmGCJSConstants;
import org.teavm.jso.impl.wasmgc.WasmGCJSFunctions;
import org.teavm.jso.impl.wasmgc.WasmGCJsoCommonGenerator;
import org.teavm.jso.impl.wasmgc.WasmGCJsoContext;
import org.teavm.model.CallLocation;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

class WasmGCJSIntrinsic
implements WasmGCIntrinsic {
    private WasmFunction globalFunction;
    private WasmGCJsoCommonGenerator commonGen;
    private WasmGCJSFunctions functions;

    WasmGCJSIntrinsic(WasmGCJsoCommonGenerator commonGen, WasmGCJSFunctions functions) {
        this.commonGen = commonGen;
        this.functions = functions;
    }

    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "wrap": {
                return this.wrapString((Expr)invocation.getArguments().get(0), context);
            }
            case "unwrapString": {
                WasmFunction function = context.functions().forStaticMethod(WasmGCJSConstants.JS_TO_STRING);
                return new WasmCall(function, new WasmExpression[]{context.generate((Expr)invocation.getArguments().get(0))});
            }
            case "global": {
                WasmExpression name = this.wrapString((Expr)invocation.getArguments().get(0), context);
                return new WasmCall(this.getGlobalFunction(context), new WasmExpression[]{name});
            }
            case "throwCCEIfFalse": {
                return this.throwCCEIfFalse(invocation, context);
            }
            case "isNull": {
                return new WasmIsNull(context.generate((Expr)invocation.getArguments().get(0)));
            }
            case "jsArrayItem": {
                return this.arrayItem(invocation, context);
            }
            case "get": 
            case "getPure": {
                return this.getProperty(invocation, context);
            }
            case "importModule": {
                return this.importModule(invocation, context);
            }
        }
        throw new IllegalArgumentException();
    }

    private WasmExpression getProperty(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmExpression result = this.tryGetFromModule(invocation, context);
        if (result != null) {
            return result;
        }
        WasmGCJsoContext jsoContext = WasmGCJsoContext.wrap(context);
        return new WasmCall(this.functions.getGet(jsoContext), new WasmExpression[]{context.generate((Expr)invocation.getArguments().get(0)), context.generate((Expr)invocation.getArguments().get(1))});
    }

    private WasmExpression tryGetFromModule(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        Expr target = (Expr)invocation.getArguments().get(0);
        if (!(target instanceof InvocationExpr)) {
            return null;
        }
        InvocationExpr targetCall = (InvocationExpr)target;
        if (!targetCall.getMethod().equals((Object)JSMethods.IMPORT_MODULE)) {
            return null;
        }
        String moduleName = this.extractString((Expr)targetCall.getArguments().get(0));
        if (moduleName == null) {
            return null;
        }
        Expr property = (Expr)invocation.getArguments().get(1);
        if (!(property instanceof InvocationExpr)) {
            return null;
        }
        InvocationExpr propertyCall = (InvocationExpr)property;
        if (!propertyCall.getMethod().equals((Object)JSMethods.WRAP_STRING)) {
            return null;
        }
        String name = this.extractString((Expr)propertyCall.getArguments().get(0));
        if (name == null) {
            return null;
        }
        WasmGCJsoContext jsoContext = WasmGCJsoContext.wrap(context);
        WasmGlobal global = this.commonGen.getImportGlobal(jsoContext, moduleName, name);
        return new WasmGetGlobal(global);
    }

    private WasmExpression importModule(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCJsoContext jsoContext = WasmGCJsoContext.wrap(context);
        Expr nameArg = (Expr)invocation.getArguments().get(0);
        String name = this.extractString(nameArg);
        if (name == null) {
            context.diagnostics().error(new CallLocation(context.currentMethod(), invocation.getLocation()), "Invalid JS module import call", new Object[0]);
        }
        WasmGlobal global = this.commonGen.getImportGlobal(jsoContext, name, "__self__");
        return new WasmGetGlobal(global);
    }

    private String extractString(Expr expr) {
        if (!(expr instanceof ConstantExpr)) {
            return null;
        }
        Object constant = ((ConstantExpr)expr).getValue();
        if (!(constant instanceof String)) {
            return null;
        }
        return (String)constant;
    }

    private WasmExpression wrapString(Expr stringExpr, WasmGCIntrinsicContext context) {
        ConstantExpr constantExpr;
        if (stringExpr instanceof ConstantExpr && (constantExpr = (ConstantExpr)stringExpr).getValue() instanceof String) {
            return this.commonGen.jsStringConstant(WasmGCJsoContext.wrap(context), (String)constantExpr.getValue());
        }
        WasmFunction function = context.functions().forStaticMethod(WasmGCJSConstants.STRING_TO_JS);
        return new WasmCall(function, new WasmExpression[]{context.generate(stringExpr)});
    }

    private WasmFunction getGlobalFunction(WasmGCIntrinsicContext context) {
        if (this.globalFunction == null) {
            this.globalFunction = new WasmFunction(context.functionTypes().of((WasmType)WasmType.Reference.EXTERN, new WasmType[]{WasmType.Reference.EXTERN}));
            this.globalFunction.setName(context.names().suggestForMethod(new MethodReference("org.teavm.jso.impl.JS", "global", new ValueType[]{JSMethods.STRING, JSMethods.JS_OBJECT})));
            this.globalFunction.setImportName("global");
            this.globalFunction.setImportModule("teavmJso");
            context.module().functions.add((WasmEntity)this.globalFunction);
        }
        return this.globalFunction;
    }

    private WasmExpression throwCCEIfFalse(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmBlock block = new WasmBlock(false);
        block.setType((WasmBlockType)WasmType.Reference.EXTERN.asBlock());
        WasmBlock innerBlock = new WasmBlock(false);
        block.getBody().add(innerBlock);
        WasmBranch br = new WasmBranch(context.generate((Expr)invocation.getArguments().get(0)), innerBlock);
        innerBlock.getBody().add(br);
        WasmFunction cceFunction = context.functions().forStaticMethod(new MethodReference(WasmGCSupport.class, "cce", new Class[]{ClassCastException.class}));
        WasmCall cce = new WasmCall(cceFunction);
        WasmThrow throwExpr = new WasmThrow(context.exceptionTag());
        throwExpr.getArguments().add(cce);
        innerBlock.getBody().add(throwExpr);
        block.getBody().add(context.generate((Expr)invocation.getArguments().get(1)));
        return block;
    }

    private WasmExpression arrayItem(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmExpression array = context.generate((Expr)invocation.getArguments().get(0));
        WasmArray arrayType = context.classInfoProvider().getClassInfo(ValueType.parse(Object[].class)).getArray();
        return new WasmArrayGet(arrayType, array, context.generate((Expr)invocation.getArguments().get(1)));
    }
}

