/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.backend.javascript.rendering.Precedence;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.InjectorContext;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class JSWrapperGenerator
implements Injector,
DependencyPlugin {
    private DependencyNode externalClassesNode;

    public void generate(InjectorContext context, MethodReference methodRef) {
        switch (methodRef.getName()) {
            case "directJavaToJs": 
            case "directJsToJava": 
            case "dependencyJavaToJs": 
            case "dependencyJsToJava": 
            case "marshallJavaToJs": 
            case "unmarshallJavaFromJs": 
            case "wrapperToJs": 
            case "jsToWrapper": {
                context.writeExpr(context.getArgument(0), context.getPrecedence());
                break;
            }
            case "isJava": {
                if (context.getPrecedence().ordinal() >= Precedence.COMPARISON.ordinal()) {
                    context.getWriter().append("(");
                }
                context.writeExpr(context.getArgument(0));
                context.getWriter().append(" instanceof ").appendFunction("$rt_objcls").append("()");
                if (context.getPrecedence().ordinal() < Precedence.COMPARISON.ordinal()) break;
                context.getWriter().append(")");
            }
        }
    }

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        switch (method.getMethod().getName()) {
            case "jsToWrapper": {
                method.getResult().propagate(agent.getType((ValueType)ValueType.object((String)"org.teavm.jso.impl.JSWrapper")));
                break;
            }
            case "dependencyJavaToJs": {
                method.getVariable(1).connect(this.getExternalClassesNode(agent));
                break;
            }
            case "dependencyJsToJava": {
                this.getExternalClassesNode(agent).connect(method.getResult());
            }
        }
    }

    private DependencyNode getExternalClassesNode(DependencyAgent agent) {
        if (this.externalClassesNode == null) {
            this.externalClassesNode = agent.createNode();
        }
        return this.externalClassesNode;
    }
}

