/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.jso.JSBody;
import org.teavm.jso.impl.JSType;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.BaseTypeInference;
import org.teavm.model.instructions.InvocationType;

class JSTypeInference
extends BaseTypeInference<JSType> {
    private JSTypeHelper typeHelper;
    private ClassReaderSource classes;
    private boolean wasmGC;

    JSTypeInference(JSTypeHelper typeHelper, ClassReaderSource classes, Program program, MethodReference reference, boolean wasmGC) {
        super(program, reference);
        this.typeHelper = typeHelper;
        this.classes = classes;
        this.wasmGC = wasmGC;
    }

    protected JSType mapType(ValueType type) {
        return this.typeHelper.mapType(type);
    }

    protected JSType nullType() {
        return JSType.NULL;
    }

    protected JSType merge(JSType a, JSType b) {
        if (a == JSType.NULL) {
            return b;
        }
        if (b == JSType.NULL) {
            return a;
        }
        if (a == b) {
            return a;
        }
        if (a instanceof JSType.ArrayType) {
            if (b instanceof JSType.ArrayType) {
                JSType elementType = this.merge(((JSType.ArrayType)a).elementType, ((JSType.ArrayType)b).elementType);
                return JSType.arrayOf(elementType);
            }
            if (b == JSType.JAVA) {
                return JSType.JAVA;
            }
            return JSType.MIXED;
        }
        if (b instanceof JSType.ArrayType) {
            if (a == JSType.JAVA) {
                return JSType.JAVA;
            }
            return JSType.MIXED;
        }
        return JSType.MIXED;
    }

    protected JSType elementType(JSType jsType) {
        if (jsType == JSType.NULL) {
            return JSType.NULL;
        }
        return jsType instanceof JSType.ArrayType ? ((JSType.ArrayType)jsType).elementType : JSType.MIXED;
    }

    protected JSType methodReturnType(InvocationType invocationType, MethodReference methodRef) {
        if (!methodRef.getReturnType().isObject(Object.class)) {
            return this.mapType(methodRef.getReturnType());
        }
        return !this.wasmGC && this.isJsMethod(methodRef) ? JSType.MIXED : JSType.JAVA;
    }

    protected JSType fieldType(FieldReference fieldRef, ValueType type) {
        if (!type.isObject(Object.class)) {
            return this.mapType(type);
        }
        return !this.wasmGC && this.isJsField(fieldRef) ? JSType.MIXED : JSType.JAVA;
    }

    private boolean isJsMethod(MethodReference methodRef) {
        if (this.typeHelper.isJavaScriptClass(methodRef.getClassName())) {
            return true;
        }
        MethodReader method = this.classes.resolveImplementation(methodRef);
        return method != null && method.getAnnotations().get(JSBody.class.getName()) != null;
    }

    private boolean isJsField(FieldReference fieldRef) {
        return this.typeHelper.isJavaScriptClass(fieldRef.getClassName());
    }
}

