/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.AstWriter;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringConstant;
import org.teavm.backend.wasm.model.WasmEntity;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExternConversion;
import org.teavm.backend.wasm.model.expression.WasmExternConversionType;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.jso.JSClass;
import org.teavm.jso.JSObject;
import org.teavm.jso.impl.AliasCollector;
import org.teavm.jso.impl.JSBodyAstEmitter;
import org.teavm.jso.impl.JSBodyBloatedEmitter;
import org.teavm.jso.impl.JSBodyEmitter;
import org.teavm.jso.impl.JSMarshallable;
import org.teavm.jso.impl.JsBodyImportInfo;
import org.teavm.jso.impl.wasmgc.WasmGCJSBodyWriter;
import org.teavm.jso.impl.wasmgc.WasmGCJSConstants;
import org.teavm.jso.impl.wasmgc.WasmGCJSFunctions;
import org.teavm.jso.impl.wasmgc.WasmGCJSRuntime;
import org.teavm.jso.impl.wasmgc.WasmGCJsoContext;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

class WasmGCJsoCommonGenerator {
    private WasmGCJSFunctions jsFunctions;
    private boolean initialized;
    private List<Consumer<WasmFunction>> initializerParts = new ArrayList<Consumer<WasmFunction>>();
    private boolean rethrowExported;
    private Map<String, WasmGlobal> stringsConstants = new HashMap<String, WasmGlobal>();
    private WasmFunction createClassFunction;
    private WasmFunction defineFunctionFunction;
    private WasmFunction defineMethodFunction;
    private WasmFunction defineStaticMethodFunction;
    private WasmFunction definePropertyFunction;
    private WasmFunction defineStaticPropertyFunction;
    private WasmFunction exportClassFunction;
    private WasmFunction javaObjectToJSFunction;
    private WasmGlobal defaultWrapperClass;
    private Map<String, WasmGlobal> definedClasses = new HashMap<String, WasmGlobal>();
    private Map<ImportDecl, WasmGlobal> importGlobals = new HashMap<ImportDecl, WasmGlobal>();

    WasmGCJsoCommonGenerator(WasmGCJSFunctions jsFunctions) {
        this.jsFunctions = jsFunctions;
    }

    private void initialize(WasmGCJsoContext context) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        context.addToInitializer(this::writeToInitializer);
        this.exportRethrowException(context);
    }

    private void writeToInitializer(WasmFunction function) {
        for (Consumer<WasmFunction> part : this.initializerParts) {
            part.accept(function);
        }
    }

    private void addInitializerPart(WasmGCJsoContext context, Consumer<WasmFunction> part) {
        this.initialize(context);
        this.initializerParts.add(part);
    }

    WasmGlobal addJSBody(WasmGCJsoContext context, JSBodyEmitter emitter, boolean inlined) {
        this.initialize(context);
        int paramCount = emitter.method().parameterCount();
        if (!emitter.isStatic()) {
            ++paramCount;
        }
        JsBodyImportInfo[] imports = emitter.imports();
        paramCount += imports.length;
        WasmGlobal global = new WasmGlobal(context.names().suggestForMethod(emitter.method()), (WasmType)WasmType.Reference.EXTERN, (WasmExpression)new WasmNullConstant((WasmType.Reference)WasmType.Reference.EXTERN));
        context.module().globals.add((WasmEntity)global);
        String body = "";
        if (emitter instanceof JSBodyBloatedEmitter) {
            body = ((JSBodyBloatedEmitter)emitter).script;
        } else if (emitter instanceof JSBodyAstEmitter) {
            WasmGCJSBodyWriter writer = new WasmGCJSBodyWriter();
            if (inlined) {
                writer.sb.append("return ");
            }
            JSBodyAstEmitter astEmitter = (JSBodyAstEmitter)emitter;
            JsBodyImportInfo[] astWriter = new AstWriter((SourceWriter)writer, name -> (w, prec) -> w.append(name));
            if (!emitter.isStatic()) {
                astWriter.declareNameEmitter("this", (w, prec) -> w.append("__this__"));
            }
            astWriter.print(astEmitter.ast);
            if (inlined) {
                writer.sb.append(";");
            }
            body = writer.sb.toString();
        } else {
            throw new IllegalArgumentException();
        }
        WasmCall constructor = new WasmCall(this.jsFunctions.getFunctionConstructor(context, paramCount));
        ArrayList<String> paramNames = new ArrayList<String>();
        for (JsBodyImportInfo importDecl : imports) {
            paramNames.add(importDecl.alias);
        }
        if (!emitter.isStatic()) {
            paramNames.add("__this__");
        }
        paramNames.addAll(List.of(emitter.parameterNames()));
        for (String parameter : paramNames) {
            WasmGetGlobal paramName = new WasmGetGlobal(context.strings().getStringConstant((String)parameter).global);
            constructor.getArguments().add(this.stringToJs(context, (WasmExpression)paramName));
        }
        WasmGetGlobal functionBody = new WasmGetGlobal(context.strings().getStringConstant((String)body).global);
        constructor.getArguments().add(this.stringToJs(context, (WasmExpression)functionBody));
        WasmCall value = constructor;
        if (imports.length > 0) {
            WasmCall bind = new WasmCall(this.jsFunctions.getBind(context, imports.length));
            bind.getArguments().add(value);
            for (JsBodyImportInfo importDecl : imports) {
                WasmGlobal importGlobal = this.getImportGlobal(context, importDecl.fromModule, "__self__");
                bind.getArguments().add(new WasmGetGlobal(importGlobal));
            }
            value = bind;
        }
        WasmCall result = value;
        this.initializerParts.add(arg_0 -> WasmGCJsoCommonGenerator.lambda$addJSBody$3(global, (WasmExpression)result, arg_0));
        return global;
    }

    WasmGlobal getImportGlobal(WasmGCJsoContext context, String module, String id) {
        return this.importGlobals.computeIfAbsent(new ImportDecl(module, id), m -> {
            String name = context.names().topLevel(WasmGCNameProvider.sanitize((String)("teavm.js@imports:" + module + "#" + id)));
            WasmGlobal global = new WasmGlobal(name, (WasmType)WasmType.Reference.EXTERN, (WasmExpression)new WasmNullConstant((WasmType.Reference)WasmType.Reference.EXTERN));
            global.setImmutable(true);
            context.module().globals.add((WasmEntity)global);
            global.setImportModule(module);
            global.setImportName(id);
            return global;
        });
    }

    private WasmFunction stringToJsFunction(WasmGCJsoContext context) {
        return context.functions().forStaticMethod(WasmGCJSConstants.STRING_TO_JS);
    }

    WasmExpression stringToJs(WasmGCJsoContext context, WasmExpression str) {
        return new WasmCall(this.stringToJsFunction(context), new WasmExpression[]{str});
    }

    private void exportRethrowException(WasmGCJsoContext context) {
        if (this.rethrowExported) {
            return;
        }
        this.rethrowExported = true;
        WasmFunction fn = context.functions().forStaticMethod(new MethodReference(WasmGCJSRuntime.class, "wrapException", new Class[]{JSObject.class, Throwable.class}));
        fn.setExportName("teavm.js.wrapException");
        fn = context.functions().forStaticMethod(new MethodReference(WasmGCJSRuntime.class, "extractException", new Class[]{Throwable.class, JSObject.class}));
        fn.setExportName("teavm.js.extractException");
        this.createThrowExceptionFunction(context);
    }

    private void createThrowExceptionFunction(WasmGCJsoContext context) {
        WasmFunction fn = new WasmFunction(context.functionTypes().of(null, new WasmType[]{WasmType.Reference.EXTERN}));
        fn.setName(context.names().topLevel("teavm@throwException"));
        fn.setExportName("teavm.js.throwException");
        context.module().functions.add((WasmEntity)fn);
        WasmLocal exceptionLocal = new WasmLocal((WasmType)WasmType.Reference.EXTERN);
        fn.add(exceptionLocal);
        WasmExternConversion asAny = new WasmExternConversion(WasmExternConversionType.EXTERN_TO_ANY, (WasmExpression)new WasmGetLocal(exceptionLocal));
        WasmType.Reference throwableType = (WasmType.Reference)context.typeMapper().mapType(ValueType.parse(Throwable.class));
        WasmCast asThrowable = new WasmCast((WasmExpression)asAny, throwableType);
        WasmThrow throwExpr = new WasmThrow(context.exceptionTag());
        throwExpr.getArguments().add(asThrowable);
        fn.getBody().add(throwExpr);
    }

    WasmExpression jsStringConstant(WasmGCJsoContext context, String str) {
        WasmGlobal global = this.stringsConstants.computeIfAbsent(str, s -> {
            WasmGlobal javaGlobal = context.strings().getStringConstant((String)s).global;
            WasmFunction function = context.functions().forStaticMethod(WasmGCJSConstants.STRING_TO_JS);
            int index = this.stringsConstants.size();
            String brief = str.length() > 16 ? str.substring(0, 16) : str;
            String name = context.names().topLevel("teavm.js.strings<" + index + ">:" + WasmGCNameProvider.sanitize((String)brief));
            WasmGlobal jsGlobal = new WasmGlobal(name, (WasmType)WasmType.Reference.EXTERN, (WasmExpression)new WasmNullConstant((WasmType.Reference)WasmType.Reference.EXTERN));
            context.module().globals.add((WasmEntity)jsGlobal);
            this.addInitializerPart(context, initializer -> {
                WasmCall call = new WasmCall(function, new WasmExpression[]{new WasmGetGlobal(javaGlobal)});
                initializer.getBody().add(new WasmSetGlobal(jsGlobal, (WasmExpression)call));
            });
            return jsGlobal;
        });
        return new WasmGetGlobal(global);
    }

    WasmGlobal getDefaultWrapperClass(WasmGCJsoContext context) {
        if (this.defaultWrapperClass == null) {
            String name = context.names().topLevel("teavm.js@defaultWrapperClass");
            this.defaultWrapperClass = new WasmGlobal(name, (WasmType)WasmType.Reference.EXTERN, (WasmExpression)new WasmNullConstant((WasmType.Reference)WasmType.Reference.EXTERN));
            context.module().globals.add((WasmEntity)this.defaultWrapperClass);
            this.addInitializerPart(context, initializer -> {
                WasmCall createClass = new WasmCall(this.createClassFunction(context), new WasmExpression[]{new WasmNullConstant((WasmType.Reference)WasmType.Reference.EXTERN), new WasmNullConstant((WasmType.Reference)WasmType.Reference.EXTERN), new WasmNullConstant((WasmType.Reference)WasmType.Reference.FUNC)});
                initializer.getBody().add(new WasmSetGlobal(this.defaultWrapperClass, (WasmExpression)createClass));
            });
        }
        return this.defaultWrapperClass;
    }

    WasmGlobal getDefinedClass(WasmGCJsoContext context, String className) {
        WasmGlobal result = this.definedClasses.get(className);
        if (result == null) {
            result = this.defineClass(context, className);
            this.definedClasses.put(className, result);
        }
        return result;
    }

    private WasmGlobal defineClass(WasmGCJsoContext context, String className) {
        WasmNullConstant constructor;
        boolean needsExport;
        String name = context.names().topLevel(context.names().suggestForClass(className + "@js"));
        WasmGlobal global = new WasmGlobal(name, (WasmType)WasmType.Reference.EXTERN, (WasmExpression)new WasmNullConstant((WasmType.Reference)WasmType.Reference.EXTERN));
        context.module().globals.add((WasmEntity)global);
        ClassReader cls = context.classes().get(className);
        ArrayList<WasmExpression> expressions = new ArrayList<WasmExpression>();
        boolean isModule = context.entryPoint().equals(className);
        AliasCollector.Members members = AliasCollector.collectMembers(cls, AliasCollector::isInstanceMember);
        this.defineMethods(context, members, cls, global, expressions);
        this.defineProperties(context, members, cls, global, expressions);
        AliasCollector.Members staticMembers = AliasCollector.collectMembers(cls, AliasCollector::isStaticMember);
        String simpleName = className.substring(className.lastIndexOf(46) + 1);
        WasmGCStringConstant javaClassName = context.strings().getStringConstant(simpleName);
        WasmExpression jsClassName = this.stringToJs(context, (WasmExpression)new WasmGetGlobal(javaClassName.global));
        String exportedParent = this.parentExportedClass(context, cls.getParent());
        WasmGetGlobal jsExportedParent = exportedParent != null ? new WasmGetGlobal(this.getDefinedClass(context, exportedParent)) : new WasmNullConstant((WasmType.Reference)WasmType.Reference.EXTERN);
        boolean bl = needsExport = !className.equals(context.entryPoint()) && (!staticMembers.methods.isEmpty() || !staticMembers.properties.isEmpty());
        if (members.constructor != null) {
            WasmFunction function = context.functions().forStaticMethod(members.constructor);
            function.setReferenced(true);
            constructor = new WasmFunctionReference(function);
            needsExport = true;
        } else {
            constructor = new WasmNullConstant((WasmType.Reference)WasmType.Reference.FUNC);
        }
        WasmCall createClass = new WasmCall(this.createClassFunction(context), new WasmExpression[]{jsClassName, jsExportedParent, constructor});
        expressions.add(0, (WasmExpression)new WasmSetGlobal(global, (WasmExpression)createClass));
        WasmGlobal globalForStatic = global;
        if (needsExport) {
            globalForStatic = this.exportClass(context, cls, global, expressions);
        }
        this.defineStaticMethods(context, staticMembers, cls, globalForStatic, expressions, isModule);
        this.defineStaticProperties(context, staticMembers, cls, globalForStatic, expressions);
        context.addToInitializer(f -> f.getBody().addAll(expressions));
        return global;
    }

    private void defineMethods(WasmGCJsoContext context, AliasCollector.Members members, ClassReader cls, WasmGlobal global, List<WasmExpression> expressions) {
        for (Map.Entry<String, MethodReference> aliasEntry : members.methods.entrySet()) {
            if (!aliasEntry.getValue().getClassName().equals(cls.getName())) continue;
            WasmFunction fn = context.functions().forStaticMethod(aliasEntry.getValue());
            fn.setReferenced(true);
            WasmGCStringConstant methodName = context.strings().getStringConstant(aliasEntry.getKey());
            WasmExpression jsMethodName = this.stringToJs(context, (WasmExpression)new WasmGetGlobal(methodName.global));
            WasmCall defineMethod = new WasmCall(this.defineMethodFunction(context), new WasmExpression[]{new WasmGetGlobal(global), jsMethodName, new WasmFunctionReference(fn)});
            expressions.add((WasmExpression)defineMethod);
        }
    }

    private void defineProperties(WasmGCJsoContext context, AliasCollector.Members members, ClassReader cls, WasmGlobal global, List<WasmExpression> expressions) {
        for (Map.Entry<String, AliasCollector.PropertyInfo> aliasEntry : members.properties.entrySet()) {
            AliasCollector.PropertyInfo property = aliasEntry.getValue();
            if (!property.getter.getClassName().equals(cls.getName())) continue;
            WasmFunction getter = context.functions().forStaticMethod(property.getter);
            getter.setReferenced(true);
            WasmFunction setter = null;
            if (property.setter != null) {
                setter = context.functions().forStaticMethod(property.setter);
                setter.setReferenced(true);
            }
            WasmFunctionReference setterRef = setter != null ? new WasmFunctionReference(setter) : new WasmNullConstant((WasmType.Reference)WasmType.Reference.FUNC);
            WasmGCStringConstant methodName = context.strings().getStringConstant(aliasEntry.getKey());
            WasmExpression jsMethodName = this.stringToJs(context, (WasmExpression)new WasmGetGlobal(methodName.global));
            WasmCall defineProperty = new WasmCall(this.definePropertyFunction(context), new WasmExpression[]{new WasmGetGlobal(global), jsMethodName, new WasmFunctionReference(getter), setterRef});
            expressions.add((WasmExpression)defineProperty);
        }
    }

    private void defineStaticMethods(WasmGCJsoContext context, AliasCollector.Members members, ClassReader cls, WasmGlobal global, List<WasmExpression> expressions, boolean isModule) {
        for (Map.Entry<String, MethodReference> aliasEntry : members.methods.entrySet()) {
            if (!aliasEntry.getValue().getClassName().equals(cls.getName())) continue;
            WasmFunction fn = context.functions().forStaticMethod(aliasEntry.getValue());
            fn.setReferenced(true);
            if (isModule) {
                String globalName = context.names().topLevel("teavm.js.export.function@" + aliasEntry.getKey());
                WasmGlobal functionGlobal = new WasmGlobal(globalName, (WasmType)WasmType.Reference.EXTERN, (WasmExpression)new WasmNullConstant((WasmType.Reference)WasmType.Reference.EXTERN));
                functionGlobal.setExportName(aliasEntry.getKey());
                context.module().globals.add((WasmEntity)functionGlobal);
                fn.setReferenced(true);
                WasmCall exportedFn = new WasmCall(this.defineFunctionFunction(context), new WasmExpression[]{new WasmFunctionReference(fn)});
                expressions.add((WasmExpression)new WasmSetGlobal(functionGlobal, (WasmExpression)exportedFn));
            }
            WasmGCStringConstant methodName = context.strings().getStringConstant(aliasEntry.getKey());
            WasmExpression jsMethodName = this.stringToJs(context, (WasmExpression)new WasmGetGlobal(methodName.global));
            WasmCall defineMethod = new WasmCall(this.defineStaticMethodFunction(context), new WasmExpression[]{new WasmGetGlobal(global), jsMethodName, new WasmFunctionReference(fn)});
            expressions.add((WasmExpression)defineMethod);
        }
    }

    private void defineStaticProperties(WasmGCJsoContext context, AliasCollector.Members members, ClassReader cls, WasmGlobal global, List<WasmExpression> expressions) {
        for (Map.Entry<String, AliasCollector.PropertyInfo> aliasEntry : members.properties.entrySet()) {
            AliasCollector.PropertyInfo property = aliasEntry.getValue();
            if (!property.getter.getClassName().equals(cls.getName())) continue;
            WasmFunction getter = context.functions().forStaticMethod(property.getter);
            getter.setReferenced(true);
            WasmFunction setter = null;
            if (property.setter != null) {
                setter = context.functions().forStaticMethod(property.setter);
                setter.setReferenced(true);
            }
            WasmFunctionReference setterRef = setter != null ? new WasmFunctionReference(setter) : new WasmNullConstant((WasmType.Reference)WasmType.Reference.FUNC);
            WasmGCStringConstant methodName = context.strings().getStringConstant(aliasEntry.getKey());
            WasmExpression jsMethodName = this.stringToJs(context, (WasmExpression)new WasmGetGlobal(methodName.global));
            WasmCall defineProperty = new WasmCall(this.defineStaticPropertyFunction(context), new WasmExpression[]{new WasmGetGlobal(global), jsMethodName, new WasmFunctionReference(getter), setterRef});
            expressions.add((WasmExpression)defineProperty);
        }
    }

    private WasmGlobal exportClass(WasmGCJsoContext context, ClassReader cls, WasmGlobal global, List<WasmExpression> expressions) {
        String exportName = this.getClassAliasName(cls);
        String globalName = context.names().topLevel("teavm.js.export.class@" + exportName);
        WasmGlobal exportGlobal = new WasmGlobal(globalName, (WasmType)WasmType.Reference.EXTERN, (WasmExpression)new WasmNullConstant((WasmType.Reference)WasmType.Reference.EXTERN));
        exportGlobal.setExportName(exportName);
        context.module().globals.add((WasmEntity)exportGlobal);
        WasmCall exported = new WasmCall(this.exportClassFunction(context), new WasmExpression[]{new WasmGetGlobal(global)});
        expressions.add((WasmExpression)new WasmSetGlobal(exportGlobal, (WasmExpression)exported));
        return exportGlobal;
    }

    private String parentExportedClass(WasmGCJsoContext context, String className) {
        while (className != null) {
            ClassReader cls = context.classes().get(className);
            if (cls == null) {
                return null;
            }
            if (cls.getInterfaces().contains(JSMarshallable.class.getName())) {
                return className;
            }
            className = cls.getParent();
        }
        return null;
    }

    private WasmFunction createClassFunction(WasmGCJsoContext context) {
        if (this.createClassFunction == null) {
            this.createClassFunction = new WasmFunction(context.functionTypes().of((WasmType)WasmType.Reference.EXTERN, new WasmType[]{WasmType.Reference.EXTERN, WasmType.Reference.EXTERN, WasmType.Reference.FUNC}));
            this.createClassFunction.setName(context.names().suggestForClass("teavm.jso@createClass"));
            this.createClassFunction.setImportName("createClass");
            this.createClassFunction.setImportModule("teavmJso");
            context.module().functions.add((WasmEntity)this.createClassFunction);
        }
        return this.createClassFunction;
    }

    private WasmFunction defineFunctionFunction(WasmGCJsoContext context) {
        if (this.defineFunctionFunction == null) {
            this.defineFunctionFunction = new WasmFunction(context.functionTypes().of((WasmType)WasmType.Reference.EXTERN, new WasmType[]{WasmType.Reference.FUNC}));
            this.defineFunctionFunction.setName(context.names().suggestForClass("teavm.jso@defineFunction"));
            this.defineFunctionFunction.setImportName("defineFunction");
            this.defineFunctionFunction.setImportModule("teavmJso");
            context.module().functions.add((WasmEntity)this.defineFunctionFunction);
        }
        return this.defineFunctionFunction;
    }

    private WasmFunction defineMethodFunction(WasmGCJsoContext context) {
        if (this.defineMethodFunction == null) {
            this.defineMethodFunction = new WasmFunction(context.functionTypes().of(null, new WasmType[]{WasmType.Reference.EXTERN, WasmType.Reference.EXTERN, WasmType.Reference.FUNC}));
            this.defineMethodFunction.setName(context.names().suggestForClass("teavm.jso@defineMethod"));
            this.defineMethodFunction.setImportName("defineMethod");
            this.defineMethodFunction.setImportModule("teavmJso");
            context.module().functions.add((WasmEntity)this.defineMethodFunction);
        }
        return this.defineMethodFunction;
    }

    private WasmFunction defineStaticMethodFunction(WasmGCJsoContext context) {
        if (this.defineStaticMethodFunction == null) {
            this.defineStaticMethodFunction = new WasmFunction(context.functionTypes().of(null, new WasmType[]{WasmType.Reference.EXTERN, WasmType.Reference.EXTERN, WasmType.Reference.FUNC}));
            this.defineStaticMethodFunction.setName(context.names().suggestForClass("teavm.jso@defineStaticMethod"));
            this.defineStaticMethodFunction.setImportName("defineStaticMethod");
            this.defineStaticMethodFunction.setImportModule("teavmJso");
            context.module().functions.add((WasmEntity)this.defineStaticMethodFunction);
        }
        return this.defineStaticMethodFunction;
    }

    private WasmFunction definePropertyFunction(WasmGCJsoContext context) {
        if (this.definePropertyFunction == null) {
            this.definePropertyFunction = new WasmFunction(context.functionTypes().of(null, new WasmType[]{WasmType.Reference.EXTERN, WasmType.Reference.EXTERN, WasmType.Reference.FUNC, WasmType.Reference.FUNC}));
            this.definePropertyFunction.setName(context.names().suggestForClass("teavm.jso@defineProperty"));
            this.definePropertyFunction.setImportName("defineProperty");
            this.definePropertyFunction.setImportModule("teavmJso");
            context.module().functions.add((WasmEntity)this.definePropertyFunction);
        }
        return this.definePropertyFunction;
    }

    private WasmFunction defineStaticPropertyFunction(WasmGCJsoContext context) {
        if (this.defineStaticPropertyFunction == null) {
            this.defineStaticPropertyFunction = new WasmFunction(context.functionTypes().of(null, new WasmType[]{WasmType.Reference.EXTERN, WasmType.Reference.EXTERN, WasmType.Reference.FUNC, WasmType.Reference.FUNC}));
            this.defineStaticPropertyFunction.setName(context.names().suggestForClass("teavm.jso@defineStaticProperty"));
            this.defineStaticPropertyFunction.setImportName("defineStaticProperty");
            this.defineStaticPropertyFunction.setImportModule("teavmJso");
            context.module().functions.add((WasmEntity)this.defineStaticPropertyFunction);
        }
        return this.defineStaticPropertyFunction;
    }

    private WasmFunction exportClassFunction(WasmGCJsoContext context) {
        if (this.exportClassFunction == null) {
            this.exportClassFunction = new WasmFunction(context.functionTypes().of((WasmType)WasmType.Reference.EXTERN, new WasmType[]{WasmType.Reference.EXTERN}));
            this.exportClassFunction.setName(context.names().suggestForClass("teavm.jso@exportClass"));
            this.exportClassFunction.setImportName("exportClass");
            this.exportClassFunction.setImportModule("teavmJso");
            context.module().functions.add((WasmEntity)this.exportClassFunction);
        }
        return this.exportClassFunction;
    }

    WasmFunction javaObjectToJSFunction(WasmGCJsoContext context) {
        if (this.javaObjectToJSFunction == null) {
            this.javaObjectToJSFunction = new WasmFunction(context.functionTypes().of((WasmType)WasmType.Reference.EXTERN, new WasmType[]{context.typeMapper().mapType(ValueType.parse(Object.class)), WasmType.Reference.EXTERN}));
            this.javaObjectToJSFunction.setName(context.names().topLevel("teavm.jso@javaObjectToJS"));
            this.javaObjectToJSFunction.setImportName("javaObjectToJS");
            this.javaObjectToJSFunction.setImportModule("teavmJso");
            context.module().functions.add((WasmEntity)this.javaObjectToJSFunction);
        }
        return this.javaObjectToJSFunction;
    }

    private String getClassAliasName(ClassReader cls) {
        String nameValueString;
        AnnotationValue nameValue;
        AnnotationReader jsExport;
        String name = cls.getSimpleName();
        if (name == null) {
            name = cls.getName().substring(cls.getName().lastIndexOf(46) + 1);
        }
        if ((jsExport = cls.getAnnotations().get(JSClass.class.getName())) != null && (nameValue = jsExport.getValue("name")) != null && !(nameValueString = nameValue.getString()).isEmpty()) {
            name = nameValueString;
        }
        return name;
    }

    private static /* synthetic */ void lambda$addJSBody$3(WasmGlobal global, WasmExpression result, WasmFunction initializer) {
        initializer.getBody().add(new WasmSetGlobal(global, result));
    }

    private static class ImportDecl {
        final String module;
        final String name;

        ImportDecl(String module, String name) {
            this.module = module;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImportDecl)) {
                return false;
            }
            ImportDecl that = (ImportDecl)o;
            return Objects.equals(this.module, that.module) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.module, this.name);
        }
    }
}

