/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.HashMap;
import java.util.Map;
import org.teavm.jso.JSClass;
import org.teavm.jso.JSObject;
import org.teavm.jso.impl.JSType;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.ValueType;

public class JSTypeHelper {
    private ClassReaderSource classSource;
    private Map<String, Boolean> knownJavaScriptClasses = new HashMap<String, Boolean>();
    private Map<String, Boolean> knownJavaScriptImplementations = new HashMap<String, Boolean>();

    public JSTypeHelper(ClassReaderSource classSource) {
        this.classSource = classSource;
        this.knownJavaScriptClasses.put(JSObject.class.getName(), true);
    }

    public JSType mapType(ValueType type) {
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            if (this.isJavaScriptClass(className)) {
                return JSType.JS;
            }
        } else if (type instanceof ValueType.Array) {
            JSType elementType = this.mapType(((ValueType.Array)type).getItemType());
            return JSType.arrayOf(elementType);
        }
        return JSType.JAVA;
    }

    public boolean isJavaScriptClass(String className) {
        Boolean isJsClass = this.knownJavaScriptClasses.get(className);
        if (isJsClass == null) {
            isJsClass = this.examineIfJavaScriptClass(className);
            this.knownJavaScriptClasses.put(className, isJsClass);
        }
        return isJsClass;
    }

    public boolean isJavaScriptImplementation(String className) {
        return this.knownJavaScriptImplementations.computeIfAbsent(className, k -> this.examineIfJavaScriptImplementation(className));
    }

    private boolean examineIfJavaScriptClass(String className) {
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return false;
        }
        if (!cls.hasModifier(ElementModifier.INTERFACE) && !cls.hasModifier(ElementModifier.ABSTRACT) && cls.getAnnotations().get(JSClass.class.getName()) == null) {
            return false;
        }
        if (cls.getParent() != null && this.isJavaScriptClass(cls.getParent())) {
            return true;
        }
        return cls.getInterfaces().stream().anyMatch(this::isJavaScriptClass);
    }

    private boolean examineIfJavaScriptImplementation(String className) {
        if (this.isJavaScriptClass(className)) {
            return false;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null || cls.getAnnotations().get(JSClass.class.getName()) != null || cls.hasModifier(ElementModifier.ABSTRACT)) {
            return false;
        }
        if (cls.getParent() != null && this.isJavaScriptClass(cls.getParent())) {
            return true;
        }
        return cls.getInterfaces().stream().anyMatch(this::isJavaScriptClass);
    }

    public boolean isSupportedByRefType(ValueType type) {
        if (!(type instanceof ValueType.Array)) {
            return false;
        }
        ValueType itemType = ((ValueType.Array)type).getItemType();
        if (itemType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)itemType).getKind()) {
                case BYTE: 
                case SHORT: 
                case CHARACTER: 
                case INTEGER: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

