/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.jso.JSClass;
import org.teavm.jso.JSExport;
import org.teavm.jso.JSMethod;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;
import org.teavm.jso.impl.FunctorImpl;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSClassObjectToExpose;
import org.teavm.jso.impl.JSClassProcessor;
import org.teavm.jso.impl.JSClassToExpose;
import org.teavm.jso.impl.JSConstructorToExpose;
import org.teavm.jso.impl.JSGetterToExpose;
import org.teavm.jso.impl.JSInstanceExpose;
import org.teavm.jso.impl.JSMethodToExpose;
import org.teavm.jso.impl.JSMethods;
import org.teavm.jso.impl.JSSetterToExpose;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.jso.impl.JSValueMarshaller;
import org.teavm.jso.impl.JSVararg;
import org.teavm.jso.impl.JSWrapper;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.Instruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;

class JSObjectClassTransformer
implements ClassHolderTransformer {
    private JSClassProcessor processor;
    private JSBodyRepository repository;
    private JSTypeHelper typeHelper;
    private ClassHierarchy hierarchy;
    private Map<String, ExposedClass> exposedClasses = new HashMap<String, ExposedClass>();
    private Predicate<String> classFilter = n -> true;
    private boolean wasmGC;

    JSObjectClassTransformer(JSBodyRepository repository) {
        this.repository = repository;
    }

    void setClassFilter(Predicate<String> classFilter) {
        this.classFilter = classFilter;
    }

    void forWasmGC() {
        this.wasmGC = true;
    }

    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        ExposedClass exposedClass;
        ClassReader originalClass;
        this.hierarchy = context.getHierarchy();
        if (this.processor == null || this.processor.getClassSource() != this.hierarchy.getClassSource()) {
            this.typeHelper = new JSTypeHelper(this.hierarchy.getClassSource());
            this.processor = new JSClassProcessor(this.hierarchy.getClassSource(), this.hierarchy, this.typeHelper, this.repository, context.getDiagnostics(), context.getIncrementalCache(), context.isStrict());
            this.processor.setWasmGC(this.wasmGC);
            this.processor.setClassFilter(this.classFilter);
        }
        this.processor.processClass(cls);
        if (this.isJavaScriptClass((ClassReader)cls) && !this.isJavaScriptImplementation((ClassReader)cls)) {
            this.processor.processMemberMethods(cls);
        }
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            if (method.getProgram() == null) continue;
            this.processor.processProgram(method);
        }
        this.processor.createJSMethods(cls);
        if (this.isJavaScriptClass((ClassReader)cls) && !this.isJavaScriptImplementation((ClassReader)cls)) {
            return;
        }
        boolean hasStaticMethods = false;
        boolean hasMemberMethods = false;
        MethodReference functorMethod = null;
        if (!cls.hasModifier(ElementModifier.ABSTRACT) && (functorMethod = this.processor.isFunctor(cls.getName())) != null && this.processor.isFunctor(cls.getParent()) != null) {
            functorMethod = null;
        }
        if ((originalClass = this.hierarchy.getClassSource().get(cls.getName())) != null) {
            exposedClass = this.getExposedClass(context.getDiagnostics(), cls.getName());
        } else {
            exposedClass = new ExposedClass();
            this.createExposedClass(context.getDiagnostics(), (ClassReader)cls, exposedClass);
        }
        this.exposeMethods(cls, exposedClass, context.getDiagnostics(), functorMethod);
        if (!exposedClass.methods.isEmpty()) {
            hasMemberMethods = true;
            cls.getAnnotations().add(new AnnotationHolder(JSClassToExpose.class.getName()));
        }
        hasStaticMethods = this.exportStaticMethods(cls, context.getDiagnostics(), context.getEntryPoint());
        if (hasMemberMethods || hasStaticMethods) {
            cls.getAnnotations().add(new AnnotationHolder(JSClassObjectToExpose.class.getName()));
        }
        if (this.wasmGC && hasMemberMethods) {
            MethodHolder createWrapperMethod = new MethodHolder(JSMethods.MARSHALL_TO_JS);
            createWrapperMethod.setLevel(AccessLevel.PUBLIC);
            createWrapperMethod.getModifiers().add(ElementModifier.NATIVE);
            cls.addMethod(createWrapperMethod);
            cls.getInterfaces().add(JSMethods.JS_MARSHALLABLE);
        }
    }

    private void exposeMethods(ClassHolder classHolder, ExposedClass classToExpose, Diagnostics diagnostics, MethodReference functorMethod) {
        int index = 0;
        for (Map.Entry<MethodDescriptor, MethodExport> entry : classToExpose.methods.entrySet()) {
            Variable receiverToPass;
            int i;
            MethodDescriptor method = entry.getKey();
            MethodExport export = entry.getValue();
            MethodReference methodRef = new MethodReference(classHolder.getName(), method);
            CallLocation callLocation = new CallLocation(methodRef);
            boolean isConstructor = entry.getKey().getName().equals("<init>");
            int paramCount = method.parameterCount();
            if (export.vararg) {
                --paramCount;
            }
            if (isConstructor) {
                --paramCount;
            }
            Object[] exportedMethodSignature = new ValueType[paramCount + 2];
            Arrays.fill(exportedMethodSignature, JSMethods.JS_OBJECT);
            if (methodRef.getReturnType() == ValueType.VOID && !isConstructor) {
                exportedMethodSignature[exportedMethodSignature.length - 1] = ValueType.VOID;
            }
            MethodDescriptor exportedMethodDesc = new MethodDescriptor(method.getName() + "$exported$" + index++, (ValueType[])exportedMethodSignature);
            MethodHolder exportedMethod = new MethodHolder(exportedMethodDesc);
            exportedMethod.getModifiers().add(ElementModifier.STATIC);
            exportedMethod.getAnnotations().add(new AnnotationHolder(JSInstanceExpose.class.getName()));
            Program program = new Program();
            exportedMethod.setProgram(program);
            program.createVariable();
            if (!isConstructor) {
                program.createVariable();
            }
            BasicBlock basicBlock = program.createBasicBlock();
            ArrayList<Instruction> marshallInstructions = new ArrayList<Instruction>();
            JSValueMarshaller marshaller = new JSValueMarshaller(diagnostics, this.typeHelper, this.hierarchy.getClassSource(), this.hierarchy, program, marshallInstructions);
            Variable[] variablesToPass = new Variable[method.parameterCount()];
            for (i = 0; i < method.parameterCount(); ++i) {
                variablesToPass[i] = program.createVariable();
            }
            if (export.vararg) {
                this.transformVarargParam(variablesToPass, program, marshallInstructions, exportedMethod, 1);
            }
            for (i = 0; i < method.parameterCount(); ++i) {
                boolean byRef = i == method.parameterCount() - 1 && export.vararg && this.typeHelper.isSupportedByRefType(method.parameterType(i));
                variablesToPass[i] = marshaller.unwrapReturnValue(callLocation, variablesToPass[i], method.parameterType(i), byRef, true);
            }
            basicBlock.addAll(marshallInstructions);
            marshallInstructions.clear();
            if (isConstructor) {
                ConstructInstruction create = new ConstructInstruction();
                create.setReceiver(program.createVariable());
                create.setType(classHolder.getName());
                basicBlock.add((Instruction)create);
                receiverToPass = create.getReceiver();
            } else {
                InvokeInstruction unmarshalledInstance = new InvokeInstruction();
                unmarshalledInstance.setType(InvocationType.SPECIAL);
                unmarshalledInstance.setReceiver(program.createVariable());
                unmarshalledInstance.setArguments(new Variable[]{program.variableAt(1)});
                unmarshalledInstance.setMethod(new MethodReference(JSWrapper.class, "unmarshallJavaFromJs", new Class[]{JSObject.class, Object.class}));
                basicBlock.add((Instruction)unmarshalledInstance);
                CastInstruction castInstance = new CastInstruction();
                castInstance.setValue(unmarshalledInstance.getReceiver());
                castInstance.setReceiver(program.createVariable());
                castInstance.setWeak(true);
                castInstance.setTargetType((ValueType)ValueType.object((String)classHolder.getName()));
                basicBlock.add((Instruction)castInstance);
                receiverToPass = castInstance.getReceiver();
            }
            InvokeInstruction invocation = new InvokeInstruction();
            invocation.setType(isConstructor ? InvocationType.SPECIAL : InvocationType.VIRTUAL);
            invocation.setInstance(receiverToPass);
            invocation.setMethod(methodRef);
            invocation.setArguments(variablesToPass);
            basicBlock.add((Instruction)invocation);
            ExitInstruction exit = new ExitInstruction();
            if (method.getResultType() != ValueType.VOID || isConstructor) {
                ValueType.Object resultType;
                Variable result;
                if (isConstructor) {
                    result = receiverToPass;
                    resultType = ValueType.object((String)classHolder.getName());
                } else {
                    result = program.createVariable();
                    invocation.setReceiver(result);
                    resultType = method.getResultType();
                }
                exit.setValueToReturn(marshaller.wrapArgument(callLocation, result, (ValueType)resultType, this.typeHelper.mapType(method.getResultType()), false, null));
                basicBlock.addAll(marshallInstructions);
                marshallInstructions.clear();
            }
            basicBlock.add((Instruction)exit);
            classHolder.addMethod(exportedMethod);
            exportedMethod.getAnnotations().add(this.createExportAnnotation(export));
            if (!methodRef.equals((Object)functorMethod)) continue;
            this.addFunctorField(classHolder, exportedMethod.getReference());
        }
    }

    private boolean exportStaticMethods(ClassHolder classHolder, Diagnostics diagnostics, String entryPointName) {
        int index = 0;
        boolean hasMethods = false;
        for (MethodHolder method : classHolder.getMethods().toArray(new MethodHolder[0])) {
            int i;
            if (!method.hasModifier(ElementModifier.STATIC) || method.getAnnotations().get(JSExport.class.getName()) == null) continue;
            hasMethods = true;
            int paramCount = method.parameterCount();
            boolean vararg = method.hasModifier(ElementModifier.VARARGS);
            if (vararg) {
                --paramCount;
            }
            CallLocation callLocation = new CallLocation(method.getReference());
            Object[] exportedMethodSignature = new ValueType[paramCount + 1];
            Arrays.fill(exportedMethodSignature, JSMethods.JS_OBJECT);
            if (method.getResultType() == ValueType.VOID) {
                exportedMethodSignature[exportedMethodSignature.length - 1] = ValueType.VOID;
            }
            MethodDescriptor exportedMethodDesc = new MethodDescriptor(method.getName() + "$exported$" + index++, (ValueType[])exportedMethodSignature);
            MethodHolder exportedMethod = new MethodHolder(exportedMethodDesc);
            exportedMethod.getModifiers().add(ElementModifier.STATIC);
            Program program = new Program();
            program.createVariable();
            exportedMethod.setProgram(program);
            BasicBlock basicBlock = program.createBasicBlock();
            if (entryPointName != null && !entryPointName.equals(classHolder.getName())) {
                InitClassInstruction clinit = new InitClassInstruction();
                clinit.setClassName(entryPointName);
                basicBlock.add((Instruction)clinit);
            }
            ArrayList<Instruction> marshallInstructions = new ArrayList<Instruction>();
            JSValueMarshaller marshaller = new JSValueMarshaller(diagnostics, this.typeHelper, this.hierarchy.getClassSource(), this.hierarchy, program, marshallInstructions);
            Variable[] variablesToPass = new Variable[method.parameterCount()];
            for (i = 0; i < method.parameterCount(); ++i) {
                variablesToPass[i] = program.createVariable();
            }
            if (vararg) {
                this.transformVarargParam(variablesToPass, program, marshallInstructions, exportedMethod, 0);
            }
            for (i = 0; i < method.parameterCount(); ++i) {
                boolean byRef = i == method.parameterCount() - 1 && vararg && this.typeHelper.isSupportedByRefType(method.parameterType(i));
                variablesToPass[i] = marshaller.unwrapReturnValue(callLocation, variablesToPass[i], method.parameterType(i), byRef, true);
            }
            basicBlock.addAll(marshallInstructions);
            marshallInstructions.clear();
            InvokeInstruction invocation = new InvokeInstruction();
            invocation.setType(InvocationType.SPECIAL);
            invocation.setMethod(method.getReference());
            invocation.setArguments(variablesToPass);
            basicBlock.add((Instruction)invocation);
            ExitInstruction exit = new ExitInstruction();
            if (method.getResultType() != ValueType.VOID) {
                invocation.setReceiver(program.createVariable());
                exit.setValueToReturn(marshaller.wrapArgument(callLocation, invocation.getReceiver(), method.getResultType(), this.typeHelper.mapType(method.getResultType()), false, null));
                basicBlock.addAll(marshallInstructions);
                marshallInstructions.clear();
            }
            basicBlock.add((Instruction)exit);
            classHolder.addMethod(exportedMethod);
            MethodExport export = this.createMethodExport(diagnostics, (ClassReader)classHolder, (MethodReader)method);
            exportedMethod.getAnnotations().add(this.createExportAnnotation(export));
        }
        return hasMethods;
    }

    private void transformVarargParam(Variable[] variablesToPass, Program program, List<Instruction> instructions, MethodHolder method, int additionalSkip) {
        int last = variablesToPass.length - 1;
        IntegerConstantInstruction lastConstant = new IntegerConstantInstruction();
        lastConstant.setReceiver(program.createVariable());
        lastConstant.setConstant(last + additionalSkip);
        instructions.add((Instruction)lastConstant);
        InvokeInstruction extractVarargs = new InvokeInstruction();
        extractVarargs.setType(InvocationType.SPECIAL);
        extractVarargs.setMethod(JSMethods.ARGUMENTS_BEGINNING_AT);
        extractVarargs.setArguments(new Variable[]{lastConstant.getReceiver()});
        extractVarargs.setReceiver(variablesToPass[last]);
        instructions.add((Instruction)extractVarargs);
        method.getAnnotations().add(new AnnotationHolder(JSVararg.class.getName()));
    }

    private AnnotationHolder createExportAnnotation(MethodExport export) {
        String annotationName;
        switch (export.kind.ordinal()) {
            case 1: {
                annotationName = JSGetterToExpose.class.getName();
                break;
            }
            case 2: {
                annotationName = JSSetterToExpose.class.getName();
                break;
            }
            case 3: {
                annotationName = JSConstructorToExpose.class.getName();
                break;
            }
            default: {
                annotationName = JSMethodToExpose.class.getName();
            }
        }
        AnnotationHolder annot = new AnnotationHolder(annotationName);
        if (export.kind != MethodKind.CONSTRUCTOR) {
            annot.getValues().put("name", new AnnotationValue(export.alias));
        }
        return annot;
    }

    private ExposedClass getExposedClass(Diagnostics diagnostics, String name) {
        ExposedClass cls = this.exposedClasses.get(name);
        if (cls == null) {
            cls = this.createExposedClass(diagnostics, name);
            this.exposedClasses.put(name, cls);
        }
        return cls;
    }

    private ExposedClass createExposedClass(Diagnostics diagnostics, String name) {
        ClassReader cls = this.hierarchy.getClassSource().get(name);
        ExposedClass exposedCls = new ExposedClass();
        if (cls != null) {
            this.createExposedClass(diagnostics, cls, exposedCls);
        }
        return exposedCls;
    }

    private void createExposedClass(Diagnostics diagnostics, ClassReader cls, ExposedClass exposedCls) {
        if (cls.hasModifier(ElementModifier.INTERFACE)) {
            return;
        }
        if (cls.getParent() != null) {
            ExposedClass parent = this.getExposedClass(diagnostics, cls.getParent());
            exposedCls.inheritedMethods.addAll(parent.inheritedMethods);
            exposedCls.inheritedMethods.addAll(parent.methods.keySet());
            exposedCls.implementedInterfaces.addAll(parent.implementedInterfaces);
        }
        if (!this.addInterfaces(diagnostics, exposedCls, cls)) {
            this.addExportedMethods(diagnostics, exposedCls, cls);
        }
    }

    private boolean isJavaScriptClass(ClassReader cls) {
        if (this.typeHelper.isJavaScriptClass(cls.getName())) {
            return true;
        }
        if (cls.getParent() != null && this.typeHelper.isJavaScriptClass(cls.getParent())) {
            return true;
        }
        for (String itf : cls.getInterfaces()) {
            if (!this.typeHelper.isJavaScriptClass(itf)) continue;
            return true;
        }
        return false;
    }

    private boolean isJavaScriptImplementation(ClassReader cls) {
        if (this.typeHelper.isJavaScriptImplementation(cls.getName())) {
            return true;
        }
        if (cls.getAnnotations().get(JSClass.class.getName()) != null || cls.hasModifier(ElementModifier.ABSTRACT)) {
            return false;
        }
        if (cls.getParent() != null && this.typeHelper.isJavaScriptClass(cls.getParent())) {
            return true;
        }
        return cls.getInterfaces().stream().anyMatch(this.typeHelper::isJavaScriptClass);
    }

    private boolean addInterfaces(Diagnostics diagnostics, ExposedClass exposedCls, ClassReader cls) {
        boolean added = false;
        for (String ifaceName : cls.getInterfaces()) {
            ClassReader iface;
            if (exposedCls.implementedInterfaces.contains(ifaceName) || (iface = this.hierarchy.getClassSource().get(ifaceName)) == null) continue;
            if (this.addInterface(diagnostics, exposedCls, iface)) {
                added = true;
                for (MethodReader method : iface.getMethods()) {
                    if (method.hasModifier(ElementModifier.STATIC) || method.getProgram() != null && method.getProgram().basicBlockCount() > 0) continue;
                    this.addExportedMethod(diagnostics, exposedCls, cls, method);
                }
                continue;
            }
            this.addExportedMethods(diagnostics, exposedCls, iface);
        }
        return added;
    }

    private boolean addInterface(Diagnostics diagnostics, ExposedClass exposedCls, ClassReader cls) {
        if (cls.getName().equals(JSObject.class.getName())) {
            return true;
        }
        return this.addInterfaces(diagnostics, exposedCls, cls);
    }

    private void addExportedMethods(Diagnostics diagnostics, ExposedClass exposedCls, ClassReader cls) {
        for (MethodReader method : cls.getMethods()) {
            if (method.hasModifier(ElementModifier.STATIC) || method.getAnnotations().get(JSExport.class.getName()) == null) continue;
            this.addExportedMethod(diagnostics, exposedCls, cls, method);
        }
    }

    private void addExportedMethod(Diagnostics diagnostics, ExposedClass exposedCls, ClassReader cls, MethodReader method) {
        if (method.getDescriptor().getName().equals("<init>") || !exposedCls.inheritedMethods.contains(method.getDescriptor())) {
            exposedCls.methods.put(method.getDescriptor(), this.createMethodExport(diagnostics, cls, method));
        }
    }

    private MethodExport createMethodExport(Diagnostics diagnostics, ClassReader cls, MethodReader method) {
        Object name = null;
        MethodKind kind = MethodKind.METHOD;
        if (method.getName().equals("<init>")) {
            kind = MethodKind.CONSTRUCTOR;
            if (cls.hasModifier(ElementModifier.ABSTRACT)) {
                diagnostics.error(new CallLocation(method.getReference()), "Can't export constructor {{m0}} of abstract class {{c0}}", new Object[]{method.getReference(), cls.getName()});
            }
        } else {
            AnnotationReader methodAnnot = method.getAnnotations().get(JSMethod.class.getName());
            if (methodAnnot != null) {
                String nameStr;
                name = method.getName();
                AnnotationValue nameVal = methodAnnot.getValue("value");
                if (nameVal != null && !(nameStr = nameVal.getString()).isEmpty()) {
                    name = nameStr;
                }
            } else {
                AnnotationReader propertyAnnot = method.getAnnotations().get(JSProperty.class.getName());
                if (propertyAnnot != null) {
                    String expectedPrefix;
                    String nameStr;
                    AnnotationValue nameVal = propertyAnnot.getValue("value");
                    if (nameVal != null && !(nameStr = nameVal.getString()).isEmpty()) {
                        name = nameStr;
                    }
                    if (method.parameterCount() == 0) {
                        expectedPrefix = method.getResultType() == ValueType.BOOLEAN ? "is" : "get";
                        kind = MethodKind.GETTER;
                    } else {
                        expectedPrefix = "set";
                        kind = MethodKind.SETTER;
                    }
                    if (name == null && ((String)(name = method.getName())).startsWith(expectedPrefix) && ((String)name).length() > expectedPrefix.length() && Character.isUpperCase(((String)name).charAt(expectedPrefix.length()))) {
                        name = Character.toLowerCase(((String)name).charAt(expectedPrefix.length())) + ((String)name).substring(expectedPrefix.length() + 1);
                    }
                }
            }
            if (name == null) {
                name = method.getName();
            }
        }
        return new MethodExport((String)name, kind, method.hasModifier(ElementModifier.VARARGS));
    }

    private void addFunctorField(ClassHolder cls, MethodReference method) {
        if (cls.getAnnotations().get(FunctorImpl.class.getName()) != null) {
            return;
        }
        FieldHolder field = new FieldHolder("$$jso_functor$$");
        field.setLevel(AccessLevel.PUBLIC);
        field.setType(ValueType.parse(JSObject.class));
        cls.addField(field);
        AnnotationHolder annot = new AnnotationHolder(FunctorImpl.class.getName());
        annot.getValues().put("value", new AnnotationValue(method.getDescriptor().toString()));
        cls.getAnnotations().add(annot);
    }

    static class ExposedClass {
        Set<MethodDescriptor> inheritedMethods = new HashSet<MethodDescriptor>();
        Map<MethodDescriptor, MethodExport> methods = new HashMap<MethodDescriptor, MethodExport>();
        Set<String> implementedInterfaces = new HashSet<String>();

        ExposedClass() {
        }
    }

    static class MethodExport {
        final String alias;
        final MethodKind kind;
        boolean vararg;

        MethodExport(String alias, MethodKind kind, boolean vararg) {
            this.alias = alias;
            this.kind = kind;
            this.vararg = vararg;
        }
    }

    static enum MethodKind {
        METHOD,
        GETTER,
        SETTER,
        CONSTRUCTOR;

    }
}

