/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.jso.JSObject;
import org.teavm.jso.impl.JSMarshallable;
import org.teavm.jso.impl.JSWrapper;
import org.teavm.jso.impl.wasmgc.WasmGCJSRuntime;
import org.teavm.model.AccessLevel;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;

class WasmGCJSWrapperTransformer
implements ClassHolderTransformer {
    WasmGCJSWrapperTransformer() {
    }

    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (cls.getName().equals(JSWrapper.class.getName())) {
            this.transformMarshallMethod(cls.getMethod(new MethodDescriptor("marshallJavaToJs", new Class[]{Object.class, JSObject.class})), context);
            this.transformDirectJavaToJs(cls.getMethod(new MethodDescriptor("directJavaToJs", new Class[]{Object.class, JSObject.class})), context);
            this.transformDirectJavaToJs(cls.getMethod(new MethodDescriptor("dependencyJavaToJs", new Class[]{Object.class, JSObject.class})), context);
            this.transformDirectJsToJava(cls.getMethod(new MethodDescriptor("dependencyJsToJava", new Class[]{JSObject.class, Object.class})), context);
            this.transformWrapMethod(cls.getMethod(new MethodDescriptor("wrap", new Class[]{JSObject.class, Object.class})));
            this.transformIsJava(cls.getMethod(new MethodDescriptor("isJava", new Class[]{Object.class, Boolean.TYPE})), context);
            this.addCreateWrapperMethod(cls, context);
        }
    }

    private void transformMarshallMethod(MethodHolder method, ClassHolderTransformerContext context) {
        method.getModifiers().remove(ElementModifier.NATIVE);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)context.getHierarchy());
        ValueEmitter obj = pe.var(1, Object.class);
        pe.when(obj.instanceOf(ValueType.parse(JSMarshallable.class)).isFalse()).thenDo(() -> pe.invoke(WasmGCJSRuntime.class, "wrapObject", JSObject.class, new ValueEmitter[]{obj}).returnValue());
        obj.cast(JSMarshallable.class).invokeVirtual("marshallToJs", JSObject.class, new ValueEmitter[0]).returnValue();
    }

    private void transformDirectJavaToJs(MethodHolder method, ClassHolderTransformerContext context) {
        method.getModifiers().remove(ElementModifier.NATIVE);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)context.getHierarchy());
        ValueEmitter obj = pe.var(1, Object.class);
        pe.invoke(JSWrapper.class, "marshallJavaToJs", JSObject.class, new ValueEmitter[]{obj}).returnValue();
    }

    private void transformDirectJsToJava(MethodHolder method, ClassHolderTransformerContext context) {
        method.getModifiers().remove(ElementModifier.NATIVE);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)context.getHierarchy());
        ValueEmitter obj = pe.var(1, JSObject.class);
        pe.invoke(JSWrapper.class, "unmarshallJavaFromJs", Object.class, new ValueEmitter[]{obj}).returnValue();
    }

    private void transformWrapMethod(MethodHolder method) {
        method.getModifiers().add(ElementModifier.NATIVE);
        method.setProgram(null);
    }

    private void addCreateWrapperMethod(ClassHolder cls, ClassHolderTransformerContext context) {
        MethodHolder method = new MethodHolder(new MethodDescriptor("createWrapper", new Class[]{JSObject.class, Object.class}));
        method.getModifiers().add(ElementModifier.STATIC);
        method.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)context.getHierarchy());
        pe.construct(JSWrapper.class, new ValueEmitter[]{pe.var(1, JSObject.class)}).returnValue();
        cls.addMethod(method);
    }

    private void transformIsJava(MethodHolder method, ClassHolderTransformerContext context) {
        method.getModifiers().remove(ElementModifier.NATIVE);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)context.getHierarchy());
        pe.constant(1).returnValue();
    }
}

