/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.MethodDependency;
import org.teavm.jso.JSObject;
import org.teavm.jso.impl.JS;
import org.teavm.jso.impl.JSBodyDelegate;
import org.teavm.jso.impl.JSWrapper;
import org.teavm.jso.impl.wasmgc.WasmGCExceptionWrapper;
import org.teavm.jso.impl.wasmgc.WasmGCJSConstants;
import org.teavm.jso.impl.wasmgc.WasmGCJSRuntime;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

class WasmGCJSDependencies
extends AbstractDependencyListener {
    WasmGCJSDependencies() {
    }

    public void started(DependencyAgent agent) {
        this.reachUtilities(agent);
    }

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        MethodReader methodReader = method.getMethod();
        if (methodReader.getOwnerName().equals(JS.class.getName())) {
            switch (methodReader.getName()) {
                case "jsArrayItem": {
                    method.getVariable(1).getArrayItem().connect(method.getResult());
                    break;
                }
                case "invoke": 
                case "apply": 
                case "construct": 
                case "get": 
                case "getPure": 
                case "set": 
                case "setPure": 
                case "global": {
                    method.getThrown().propagate(agent.getType(WasmGCExceptionWrapper.class.getName()));
                }
            }
        } else if (methodReader.getOwnerName().equals(JSWrapper.class.getName())) {
            if (methodReader.getName().equals("wrap")) {
                agent.linkMethod(new MethodReference(JSWrapper.class, "createWrapper", new Class[]{JSObject.class, Object.class})).use();
            }
        } else if (methodReader.getAnnotations().get(JSBodyDelegate.class.getName()) != null) {
            method.getThrown().propagate(agent.getType(WasmGCExceptionWrapper.class.getName()));
        } else if (methodReader.getOwnerName().equals(WasmGCJSRuntime.CharArrayData.class.getName()) && method.getMethod().getName().equals("asString")) {
            method.getResult().propagate(agent.getType(String.class.getName()));
            agent.linkMethod(new MethodReference(String.class, "fromArray", new Class[]{char[].class, String.class})).use();
        }
    }

    private void reachUtilities(DependencyAgent agent) {
        agent.linkMethod(WasmGCJSConstants.STRING_TO_JS).propagate(1, agent.getType("java.lang.String")).use();
        MethodDependency jsToString = agent.linkMethod(WasmGCJSConstants.JS_TO_STRING);
        jsToString.getResult().propagate(agent.getType("java.lang.String"));
        jsToString.use();
        agent.linkMethod(new MethodReference(WasmGCJSRuntime.class, "wrapException", new Class[]{JSObject.class, Throwable.class})).use();
        agent.linkMethod(new MethodReference(WasmGCJSRuntime.class, "extractException", new Class[]{Throwable.class, JSObject.class})).use();
    }
}

