/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.jso.JSBody;
import org.teavm.jso.impl.JSType;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.BaseTypeInference;

class JSTypeInference
extends BaseTypeInference<JSType> {
    private JSTypeHelper typeHelper;
    private ClassReaderSource classes;

    JSTypeInference(JSTypeHelper typeHelper, ClassReaderSource classes, Program program, MethodReference reference) {
        super(program, reference);
        this.typeHelper = typeHelper;
        this.classes = classes;
    }

    protected JSType mapType(ValueType type) {
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            if (this.typeHelper.isJavaScriptClass(className)) {
                return JSType.JS;
            }
        } else if (type instanceof ValueType.Array) {
            JSType elementType = this.mapType(((ValueType.Array)type).getItemType());
            return JSType.arrayOf(elementType);
        }
        return JSType.JAVA;
    }

    protected JSType nullType() {
        return JSType.NULL;
    }

    protected JSType merge(JSType a, JSType b) {
        if (a == JSType.NULL) {
            return b;
        }
        if (b == JSType.NULL) {
            return a;
        }
        if (a == b) {
            return a;
        }
        if (a instanceof JSType.ArrayType) {
            if (b instanceof JSType.ArrayType) {
                JSType elementType = this.merge(((JSType.ArrayType)a).elementType, ((JSType.ArrayType)b).elementType);
                return JSType.arrayOf(elementType);
            }
            if (b == JSType.JAVA) {
                return JSType.JAVA;
            }
            return JSType.MIXED;
        }
        if (b instanceof JSType.ArrayType) {
            if (a == JSType.JAVA) {
                return JSType.JAVA;
            }
            return JSType.MIXED;
        }
        return JSType.MIXED;
    }

    protected JSType elementType(JSType jsType) {
        if (jsType == JSType.NULL) {
            return JSType.NULL;
        }
        return jsType instanceof JSType.ArrayType ? ((JSType.ArrayType)jsType).elementType : JSType.MIXED;
    }

    protected JSType methodReturnType(MethodReference methodRef) {
        if (!methodRef.getReturnType().isObject(Object.class)) {
            return this.mapType(methodRef.getReturnType());
        }
        return this.isJsMethod(methodRef) ? JSType.MIXED : JSType.JAVA;
    }

    private boolean isJsMethod(MethodReference methodRef) {
        if (this.typeHelper.isJavaScriptClass(methodRef.getClassName())) {
            return true;
        }
        MethodReader method = this.classes.resolveImplementation(methodRef);
        return method != null && method.getAnnotations().get(JSBody.class.getName()) != null;
    }
}

