/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.interop.NoSideEffects;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSClass;
import org.teavm.jso.JSObject;
import org.teavm.jso.core.JSBoolean;
import org.teavm.jso.core.JSFinalizationRegistry;
import org.teavm.jso.core.JSMap;
import org.teavm.jso.core.JSNumber;
import org.teavm.jso.core.JSObjects;
import org.teavm.jso.core.JSString;
import org.teavm.jso.core.JSUndefined;
import org.teavm.jso.core.JSWeakMap;
import org.teavm.jso.core.JSWeakRef;
import org.teavm.jso.impl.JS;

public final class JSWrapper {
    private static final JSWeakMap<JSObject, JSTransparentInt> hashCodes = new JSWeakMap();
    private static final JSWeakMap<JSObject, JSWeakRef<JSObject>> wrappers = JSWeakRef.isSupported() ? new JSWeakMap() : null;
    private static final JSMap<JSString, JSWeakRef<JSObject>> stringWrappers = JSWeakRef.isSupported() ? new JSMap() : null;
    private static final JSMap<JSNumber, JSWeakRef<JSObject>> numberWrappers = JSWeakRef.isSupported() ? new JSMap() : null;
    private static JSWeakRef<JSObject> undefinedWrapper;
    private static final JSFinalizationRegistry stringFinalizationRegistry;
    private static final JSFinalizationRegistry numberFinalizationRegistry;
    private static int hashCodeGen;
    public final JSObject js;

    private JSWrapper(JSObject js) {
        this.js = js;
    }

    public static Object wrap(Object o) {
        boolean isObject;
        if (o == null) {
            return null;
        }
        JSObject js = JSWrapper.directJavaToJs(o);
        String type = JSObjects.typeOf((Object)js);
        boolean bl = isObject = type.equals("object") || type.equals("function");
        if (isObject && JSWrapper.isJSImplementation(o)) {
            return o;
        }
        if (wrappers != null) {
            if (isObject) {
                JSUndefined existing;
                JSWeakRef<JSObject> existingRef = JSWrapper.get(wrappers, js);
                Object object = existing = !JSWrapper.isUndefined(existingRef) ? JSWrapper.deref(existingRef) : JSUndefined.instance();
                if (JSWrapper.isUndefined((JSObject)existing)) {
                    JSWrapper wrapper = new JSWrapper(js);
                    JSWrapper.set(wrappers, js, JSWrapper.createWeakRef(JSWrapper.wrapperToJs(wrapper)));
                    return wrapper;
                }
                return JSWrapper.jsToWrapper((JSObject)existing);
            }
            if (type.equals("string")) {
                JSUndefined existing;
                JSString jsString = (JSString)js;
                JSWeakRef<JSObject> existingRef = JSWrapper.get(stringWrappers, (JSObject)jsString);
                Object object = existing = !JSWrapper.isUndefined(existingRef) ? JSWrapper.deref(existingRef) : JSUndefined.instance();
                if (JSWrapper.isUndefined((JSObject)existing)) {
                    JSWrapper wrapper = new JSWrapper(js);
                    JSObject wrapperAsJs = JSWrapper.wrapperToJs(wrapper);
                    JSWrapper.set(stringWrappers, (JSObject)jsString, JSWrapper.createWeakRef(wrapperAsJs));
                    JSWrapper.register(stringFinalizationRegistry, wrapperAsJs, (JSObject)jsString);
                    return wrapper;
                }
                return JSWrapper.jsToWrapper((JSObject)existing);
            }
            if (type.equals("number")) {
                JSUndefined existing;
                JSNumber jsNumber = (JSNumber)js;
                JSWeakRef<JSObject> existingRef = JSWrapper.get(numberWrappers, (JSObject)jsNumber);
                Object object = existing = !JSWrapper.isUndefined(existingRef) ? JSWrapper.deref(existingRef) : JSUndefined.instance();
                if (JSWrapper.isUndefined((JSObject)existing)) {
                    JSWrapper wrapper = new JSWrapper(js);
                    JSObject wrapperAsJs = JSWrapper.wrapperToJs(wrapper);
                    JSWrapper.set(numberWrappers, (JSObject)jsNumber, JSWrapper.createWeakRef(wrapperAsJs));
                    JSWrapper.register(numberFinalizationRegistry, wrapperAsJs, (JSObject)jsNumber);
                    return wrapper;
                }
                return JSWrapper.jsToWrapper((JSObject)existing);
            }
            if (type.equals("undefined")) {
                JSUndefined existing;
                JSWeakRef<JSObject> existingRef = undefinedWrapper;
                Object object = existing = existingRef != null ? JSWrapper.deref(existingRef) : JSUndefined.instance();
                if (JSWrapper.isUndefined((JSObject)existing)) {
                    JSWrapper wrapper = new JSWrapper(js);
                    JSObject wrapperAsJs = JSWrapper.wrapperToJs(wrapper);
                    undefinedWrapper = JSWrapper.createWeakRef(wrapperAsJs);
                    return wrapper;
                }
                return JSWrapper.jsToWrapper((JSObject)existing);
            }
        }
        return new JSWrapper(js);
    }

    @JSBody(params={"target"}, script="return new WeakRef(target);")
    @NoSideEffects
    private static native JSWeakRef<JSObject> createWeakRef(JSObject var0);

    @JSBody(params={"target"}, script="return target.deref();")
    @NoSideEffects
    private static native JSObject deref(JSWeakRef<JSObject> var0);

    @JSBody(params={"registry", "target", "token"}, script="return registry.register(target, token);")
    @NoSideEffects
    private static native void register(JSFinalizationRegistry var0, JSObject var1, JSObject var2);

    @JSBody(params={"map", "key"}, script="return map.get(key);")
    @NoSideEffects
    private static native JSWeakRef<JSObject> get(JSMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1);

    @JSBody(params={"map", "key", "value"}, script="map.set(key, value);")
    @NoSideEffects
    private static native void set(JSMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1, JSObject var2);

    @JSBody(params={"map", "key"}, script="return map.get(key);")
    @NoSideEffects
    private static native JSWeakRef<JSObject> get(JSWeakMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1);

    @JSBody(params={"map", "key", "value"}, script="map.set(key, value);")
    @NoSideEffects
    private static native void set(JSWeakMap<? extends JSObject, JSWeakRef<JSObject>> var0, JSObject var1, JSObject var2);

    @NoSideEffects
    public static Object maybeWrap(Object o) {
        return o == null || JSWrapper.isJava(o) ? o : JSWrapper.wrap(o);
    }

    @NoSideEffects
    public static native JSObject directJavaToJs(Object var0);

    @NoSideEffects
    public static native Object directJsToJava(JSObject var0);

    @NoSideEffects
    public static native JSObject dependencyJavaToJs(Object var0);

    @NoSideEffects
    public static native Object dependencyJsToJava(JSObject var0);

    @NoSideEffects
    private static native JSObject wrapperToJs(JSWrapper var0);

    @NoSideEffects
    private static native JSWrapper jsToWrapper(JSObject var0);

    @NoSideEffects
    public static native boolean isJava(Object var0);

    @NoSideEffects
    public static native boolean isJava(JSObject var0);

    @NoSideEffects
    private static native boolean isJSImplementation(Object var0);

    public static JSObject unwrap(Object o) {
        if (o == null) {
            return null;
        }
        return JSWrapper.isJSImplementation(o) ? JSWrapper.directJavaToJs(o) : ((JSWrapper)o).js;
    }

    public static JSObject maybeUnwrap(Object o) {
        if (o == null) {
            return null;
        }
        return JSWrapper.isJava(o) ? JSWrapper.unwrap(o) : JSWrapper.directJavaToJs(o);
    }

    public static JSObject javaToJs(Object o) {
        if (o == null) {
            return null;
        }
        return JSWrapper.isJava(o) && o instanceof JSWrapper ? JSWrapper.unwrap(o) : JSWrapper.dependencyJavaToJs(o);
    }

    public static Object jsToJava(JSObject o) {
        if (o == null) {
            return null;
        }
        return !JSWrapper.isJava(o) ? JSWrapper.wrap(JSWrapper.directJsToJava(o)) : JSWrapper.dependencyJsToJava(o);
    }

    public static boolean isJs(Object o) {
        if (o == null) {
            return false;
        }
        return !JSWrapper.isJava(o) || o instanceof JSWrapper;
    }

    public static boolean isPrimitive(Object o, JSObject primitive) {
        return JSWrapper.isJs(o) && JS.isPrimitive(JSWrapper.maybeUnwrap(o), primitive);
    }

    public static boolean instanceOf(Object o, JSObject type) {
        return JSWrapper.isJs(o) && JS.instanceOf(JSWrapper.maybeUnwrap(o), type);
    }

    public int hashCode() {
        String type = JSObjects.typeOf((Object)this.js);
        if (type.equals("object") || type.equals("symbol") || type.equals("function")) {
            JSTransparentInt code = (JSTransparentInt)hashCodes.get((Object)this.js);
            if (JSWrapper.isUndefined(code)) {
                code = JSTransparentInt.valueOf(++hashCodeGen);
                hashCodes.set((Object)this.js, (Object)code);
            }
            return code.intValue();
        }
        if (type.equals("number")) {
            return ((JSNumber)this.js).intValue();
        }
        if (type.equals("bigint")) {
            return JSWrapper.bigintTruncate(this.js);
        }
        if (type.equals("string")) {
            JSString s = (JSString)this.js;
            int hashCode = 0;
            for (int i = 0; i < s.getLength(); ++i) {
                hashCode = 31 * hashCode + s.charCodeAt(i);
            }
            return hashCode;
        }
        if (type.equals("boolean")) {
            return this.js == JSBoolean.valueOf((boolean)true) ? 1 : 0;
        }
        return 0;
    }

    @JSBody(params={"bigint"}, script="return BigInt.asIntN(bigint, 32);")
    @NoSideEffects
    private static native int bigintTruncate(JSObject var0);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSWrapper)) {
            return false;
        }
        return this.js == ((JSWrapper)obj).js;
    }

    public String toString() {
        return JSWrapper.isUndefined(this.js) ? "undefined" : JSObjects.toString((Object)this.js);
    }

    @JSBody(params={"obj"}, script="return typeof obj == 'undefined'")
    private static native boolean isUndefined(JSObject var0);

    static {
        stringFinalizationRegistry = stringWrappers != null ? new JSFinalizationRegistry(token -> stringWrappers.delete((JSObject)((JSString)token))) : null;
        numberFinalizationRegistry = numberWrappers != null ? new JSFinalizationRegistry(token -> numberWrappers.delete((JSObject)((JSNumber)token))) : null;
    }

    @JSClass(transparent=true)
    static abstract class JSTransparentInt
    implements JSObject {
        JSTransparentInt() {
        }

        @JSBody(script="return this;")
        native int intValue();

        @JSBody(params={"value"}, script="return value;")
        static native JSTransparentInt valueOf(int var0);
    }
}

