/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle.tasks;

import java.io.File;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.teavm.gradle.api.JSModuleType;
import org.teavm.gradle.api.SourceFilePolicy;
import org.teavm.gradle.tasks.TeaVMTask;
import org.teavm.tooling.TeaVMSourceFilePolicy;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.builder.BuildStrategy;

public abstract class GenerateJavaScriptTask
extends TeaVMTask {
    public GenerateJavaScriptTask() {
        this.getObfuscated().convention((Object)true);
        this.getStrict().convention((Object)false);
        this.getModuleType().convention((Object)JSModuleType.UMD);
        this.getSourceMap().convention((Object)false);
        this.getSourceFilePolicy().convention((Object)SourceFilePolicy.DO_NOTHING);
        this.getEntryPointName().convention((Object)"main");
    }

    @Input
    @Optional
    public abstract Property<Boolean> getObfuscated();

    @Input
    @Optional
    public abstract Property<Boolean> getStrict();

    @Input
    @Optional
    public abstract Property<JSModuleType> getModuleType();

    @Input
    @Optional
    public abstract Property<Boolean> getSourceMap();

    @Input
    @Optional
    public abstract Property<String> getEntryPointName();

    @InputFiles
    public abstract ConfigurableFileCollection getSourceFiles();

    @Input
    @Optional
    public abstract Property<SourceFilePolicy> getSourceFilePolicy();

    @Override
    protected void setupBuilder(BuildStrategy builder) {
        builder.setTargetType(TeaVMTargetType.JAVASCRIPT);
        builder.setObfuscated(((Boolean)this.getObfuscated().get()).booleanValue());
        builder.setStrict(((Boolean)this.getStrict().get()).booleanValue());
        switch ((JSModuleType)((Object)this.getModuleType().get())) {
            case UMD: {
                builder.setJsModuleType(org.teavm.backend.javascript.JSModuleType.UMD);
                break;
            }
            case COMMON_JS: {
                builder.setJsModuleType(org.teavm.backend.javascript.JSModuleType.COMMON_JS);
                break;
            }
            case NONE: {
                builder.setJsModuleType(org.teavm.backend.javascript.JSModuleType.NONE);
                break;
            }
            case ES2015: {
                builder.setJsModuleType(org.teavm.backend.javascript.JSModuleType.ES2015);
            }
        }
        builder.setSourceMapsFileGenerated(((Boolean)this.getSourceMap().get()).booleanValue());
        builder.setEntryPointName((String)this.getEntryPointName().get());
        for (File file : this.getSourceFiles()) {
            if (file.isFile()) {
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
                builder.addSourcesJar(file.getAbsolutePath());
                continue;
            }
            if (!file.isDirectory()) continue;
            builder.addSourcesDirectory(file.getAbsolutePath());
        }
        switch ((SourceFilePolicy)((Object)this.getSourceFilePolicy().get())) {
            case DO_NOTHING: {
                builder.setSourceFilePolicy(TeaVMSourceFilePolicy.DO_NOTHING);
                break;
            }
            case COPY: {
                builder.setSourceFilePolicy(TeaVMSourceFilePolicy.COPY);
                break;
            }
            case LINK_LOCAL_FILES: {
                builder.setSourceFilePolicy(TeaVMSourceFilePolicy.LINK_LOCAL_FILES);
            }
        }
    }
}

