/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.War;
import org.teavm.gradle.TeaVMExtensionImpl;
import org.teavm.gradle.TeaVMTestConfigurator;
import org.teavm.gradle.api.TeaVMCConfiguration;
import org.teavm.gradle.api.TeaVMConfiguration;
import org.teavm.gradle.api.TeaVMExtension;
import org.teavm.gradle.api.TeaVMJSConfiguration;
import org.teavm.gradle.api.TeaVMWasiConfiguration;
import org.teavm.gradle.api.TeaVMWasmConfiguration;
import org.teavm.gradle.tasks.GenerateCTask;
import org.teavm.gradle.tasks.GenerateJavaScriptTask;
import org.teavm.gradle.tasks.GenerateWasiTask;
import org.teavm.gradle.tasks.GenerateWasmTask;
import org.teavm.gradle.tasks.TeaVMTask;

public class TeaVMPlugin
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "teavm";
    public static final String SOURCE_SET_NAME = "teavm";
    public static final String JS_TASK_NAME = "generateJavaScript";
    public static final String WASM_TASK_NAME = "generateWasm";
    public static final String WASI_TASK_NAME = "generateWasi";
    public static final String C_TASK_NAME = "generateC";
    public static final String CONFIGURATION_NAME = "teavm";
    public static final String CLASSPATH_CONFIGURATION_NAME = "teavmClasspath";
    private ObjectFactory objectFactory;

    @Inject
    public TeaVMPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void apply(Project project) {
        this.registerExtension(project);
        this.registerConfiguration(project);
        this.registerSourceSet(project);
        this.registerTasks(project);
        this.addDependencies(project);
        this.setupWarTask(project);
        TeaVMTestConfigurator.configure(project, ((TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class)).getTests());
    }

    private void registerExtension(Project project) {
        TeaVMExtensionImpl extension = new TeaVMExtensionImpl(project, this.objectFactory);
        project.getExtensions().add(TeaVMExtension.class, "teavm", (Object)extension);
    }

    private void registerConfiguration(Project project) {
        Configuration teavm = (Configuration)project.getConfigurations().create("teavm");
        Configuration teavmClasspath = (Configuration)project.getConfigurations().create(CLASSPATH_CONFIGURATION_NAME);
        project.getConfigurations().configureEach(config -> {
            if (config.getName().equals("runtimeClasspath")) {
                teavmClasspath.extendsFrom(new Configuration[]{config});
            }
            if (config.getName().equals("compileOnly")) {
                config.extendsFrom(new Configuration[]{teavm});
            }
        });
        teavmClasspath.extendsFrom(new Configuration[]{teavm});
    }

    private void registerSourceSet(Project project) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class);
        if (sourceSets != null) {
            SourceSet sourceSet = (SourceSet)sourceSets.create("teavm");
            SourceSetOutput main = ((SourceSet)sourceSets.getByName("main")).getOutput();
            sourceSet.setRuntimeClasspath(sourceSet.getRuntimeClasspath().plus((FileCollection)main).plus((FileCollection)project.getConfigurations().getByName(CLASSPATH_CONFIGURATION_NAME)));
            sourceSet.setCompileClasspath(sourceSet.getCompileClasspath().plus((FileCollection)main).plus((FileCollection)project.getConfigurations().getByName("compileClasspath")));
            sourceSet.java(java -> {});
            project.getDependencies().add("testImplementation", (Object)sourceSet.getOutput());
        }
    }

    private void registerTasks(Project project) {
        Configuration compilerConfig = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)"org.teavm:teavm-tooling:0.9.1")});
        this.registerJsTask(project, compilerConfig);
        this.registerWasmTask(project, compilerConfig);
        this.registerWasiTask(project, compilerConfig);
        this.registerCTask(project, compilerConfig);
    }

    private void registerJsTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().create(JS_TASK_NAME, GenerateJavaScriptTask.class, task -> {
            TeaVMJSConfiguration js = extension.getJs();
            this.applyToTask(js, (TeaVMTask)((Object)task), configuration);
            task.getObfuscated().convention(js.getObfuscated());
            task.getModuleType().convention(js.getModuleType());
            task.getSourceMap().convention(js.getSourceMap());
            task.getTargetFileName().convention(js.getTargetFileName());
            task.getStrict().convention(js.getStrict());
            task.getEntryPointName().convention(js.getEntryPointName());
            task.getSourceFilePolicy().convention(js.getSourceFilePolicy());
            task.getSourceFiles().from(new Object[]{project.provider(() -> {
                ArrayList<File> result = new ArrayList<File>();
                this.addSourceDirs(project, result);
                return result;
            })});
            task.getSourceFiles().from(new Object[]{project.provider(() -> {
                Set dependencies = project.getConfigurations().getByName("compileClasspath").getIncoming().getResolutionResult().getAllDependencies();
                ArrayList<File> result = new ArrayList<File>();
                for (DependencyResult dependencyResult : dependencies) {
                    if (!(dependencyResult instanceof ResolvedDependencyResult)) continue;
                    ComponentIdentifier id = ((ResolvedDependencyResult)dependencyResult).getSelected().getId();
                    if (id instanceof ProjectComponentIdentifier) {
                        String path = ((ProjectComponentIdentifier)id).getProjectPath();
                        Project refProject = project.getRootProject().findProject(path);
                        if (refProject == null) continue;
                        this.addSourceDirs(refProject, result);
                        continue;
                    }
                    if (!(id instanceof ModuleComponentIdentifier)) continue;
                    ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)id;
                    Dependency sourcesDep = project.getDependencies().create(Map.of("group", moduleId.getGroup(), "name", moduleId.getModuleIdentifier().getName(), "version", moduleId.getVersion(), "classifier", "sources"));
                    Configuration tmpConfig = project.getConfigurations().detachedConfiguration(new Dependency[]{sourcesDep});
                    tmpConfig.setTransitive(false);
                    if (tmpConfig.getResolvedConfiguration().hasError()) continue;
                    result.addAll(tmpConfig.getResolvedConfiguration().getLenientConfiguration().getFiles());
                }
                return result;
            })});
        });
    }

    private void addSourceDirs(Project project, List<File> result) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class);
        if (sourceSets != null) {
            for (SourceSet sourceSet : sourceSets) {
                result.addAll(sourceSet.getAllJava().getSourceDirectories().getFiles());
            }
        }
    }

    private void registerWasmTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().create(WASM_TASK_NAME, GenerateWasmTask.class, task -> {
            TeaVMWasmConfiguration wasm = extension.getWasm();
            this.applyToTask(wasm, (TeaVMTask)((Object)task), configuration);
            task.getTargetFileName().convention(wasm.getTargetFileName());
            task.getMinHeapSize().convention(wasm.getMinHeapSize());
            task.getMaxHeapSize().convention(wasm.getMaxHeapSize());
        });
    }

    private void registerWasiTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().create(WASI_TASK_NAME, GenerateWasiTask.class, task -> {
            TeaVMWasiConfiguration wasi = extension.getWasi();
            this.applyToTask(wasi, (TeaVMTask)((Object)task), configuration);
            task.getTargetFileName().convention(wasi.getTargetFileName());
            task.getMinHeapSize().convention(wasi.getMinHeapSize());
            task.getMaxHeapSize().convention(wasi.getMaxHeapSize());
        });
    }

    private void registerCTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().create(C_TASK_NAME, GenerateCTask.class, task -> {
            TeaVMCConfiguration c = extension.getC();
            this.applyToTask(c, (TeaVMTask)((Object)task), configuration);
            task.getMinHeapSize().convention(c.getMinHeapSize());
            task.getMaxHeapSize().convention(c.getMaxHeapSize());
            task.getHeapDump().convention(c.getHeapDump());
            task.getShortFileNames().convention(c.getShortFileNames());
            task.getObfuscated().convention(c.getObfuscated());
        });
    }

    private void addDependencies(Project project) {
        project.getDependencies().add("teavm", (Object)"org.teavm:teavm-classlib:0.9.1");
        project.getDependencies().add("testImplementation", (Object)"org.teavm:teavm-junit:0.9.1");
        project.getDependencies().add("testRuntimeOnly", (Object)"org.teavm:teavm-classlib:0.9.1");
    }

    private void setupWarTask(Project project) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().withType(War.class).configureEach(task -> {
            if (task.getName().equals("war")) {
                Property<String> relPath;
                DirectoryProperty outDir;
                Boolean jsAddedToWebApp = (Boolean)extension.getJs().getAddedToWebApp().get();
                Boolean wasmAddedToWebApp = (Boolean)extension.getWasm().getAddedToWebApp().get();
                if (jsAddedToWebApp.booleanValue()) {
                    task.dependsOn(new Object[]{project.getTasks().named(JS_TASK_NAME)});
                    outDir = extension.getJs().getOutputDir();
                    relPath = extension.getJs().getRelativePathInOutputDir();
                    task.with(new CopySpec[]{project.copySpec(spec -> {
                        spec.into((Object)relPath);
                        spec.from(new Object[]{project.files(new Object[]{outDir.map(dir -> new File(dir.getAsFile(), (String)relPath.get()))})});
                        spec.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
                    })});
                }
                if (wasmAddedToWebApp.booleanValue()) {
                    task.dependsOn(new Object[]{project.getTasks().named(WASM_TASK_NAME)});
                    outDir = extension.getWasm().getOutputDir();
                    relPath = extension.getWasm().getRelativePathInOutputDir();
                    task.with(new CopySpec[]{project.copySpec(spec -> {
                        spec.into((Object)relPath);
                        spec.from(new Object[]{project.files(new Object[]{outDir.map(dir -> new File(dir.getAsFile(), (String)relPath.get()))})});
                    })});
                }
            }
        });
    }

    private void applyToTask(TeaVMConfiguration configuration, TeaVMTask task, Configuration toolsConfiguration) {
        task.getMainClass().convention(configuration.getMainClass());
        task.getClasspath().from(new Object[]{task.getProject().getConfigurations().getByName(CLASSPATH_CONFIGURATION_NAME)});
        task.getPreservedClasses().addAll(configuration.getPreservedClasses());
        task.getDebugInformation().convention(configuration.getDebugInformation());
        task.getFastGlobalAnalysis().convention(configuration.getFastGlobalAnalysis());
        task.getOptimization().convention(configuration.getOptimization());
        task.getOutOfProcess().convention(configuration.getOutOfProcess());
        task.getProcessMemory().convention(configuration.getProcessMemory());
        task.getProperties().putAll(configuration.getProperties());
        task.getDaemonClasspath().from(new Object[]{toolsConfiguration});
        task.getOutputDir().convention(configuration.getOutputDir().map(d -> new File(d.getAsFile(), (String)configuration.getRelativePathInOutputDir().get())));
        Project project = task.getProject();
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class);
        if (sourceSets != null) {
            task.getClasspath().from(new Object[]{((SourceSet)sourceSets.getByName("main")).getOutput()});
            task.getClasspath().from(new Object[]{((SourceSet)sourceSets.getByName("teavm")).getOutput()});
        }
    }
}

