/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.teavm.callgraph.CallGraph;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.gradle.api.OptimizationLevel;
import org.teavm.gradle.tasks.GradleTeaVMToolLog;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.builder.BuildException;
import org.teavm.tooling.builder.BuildResult;
import org.teavm.tooling.builder.BuildStrategy;
import org.teavm.tooling.builder.InProcessBuildStrategy;
import org.teavm.tooling.builder.RemoteBuildStrategy;
import org.teavm.tooling.daemon.BuildDaemon;
import org.teavm.tooling.daemon.DaemonInfo;
import org.teavm.tooling.daemon.DaemonLog;
import org.teavm.tooling.daemon.RemoteBuildService;
import org.teavm.vm.TeaVMOptimizationLevel;

public abstract class TeaVMTask
extends DefaultTask {
    public TeaVMTask() {
        this.setGroup("TeaVM");
        this.getDebugInformation().convention((Object)false);
        this.getTargetFileName().convention((Object)"bundle");
        this.getOptimization().convention((Object)OptimizationLevel.BALANCED);
        this.getFastGlobalAnalysis().convention((Object)false);
        this.getOutOfProcess().convention((Object)false);
        this.getProcessMemory().convention((Object)512);
    }

    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    @Optional
    public abstract Property<Boolean> getDebugInformation();

    @Input
    @Optional
    public abstract Property<String> getTargetFileName();

    @Input
    @Optional
    public abstract Property<OptimizationLevel> getOptimization();

    @Input
    @Optional
    public abstract Property<Boolean> getFastGlobalAnalysis();

    @Input
    @Optional
    public abstract MapProperty<String, String> getProperties();

    @Input
    @Optional
    public abstract ListProperty<String> getPreservedClasses();

    @OutputDirectory
    public abstract Property<File> getOutputDir();

    @Input
    public abstract Property<String> getMainClass();

    @Input
    @Optional
    public abstract Property<Boolean> getOutOfProcess();

    @Input
    @Optional
    public abstract Property<Integer> getProcessMemory();

    @Classpath
    public abstract ConfigurableFileCollection getDaemonClasspath();

    @TaskAction
    public void execute() throws BuildException, IOException, NotBoundException {
        if (((Boolean)this.getOutOfProcess().get()).booleanValue()) {
            this.executeInSeparateProcess();
        } else {
            this.executeWithBuilder((BuildStrategy)new InProcessBuildStrategy(URLClassLoader::new));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInSeparateProcess() throws BuildException, IOException, NotBoundException {
        DaemonInfo daemon = BuildDaemon.start((boolean)false, (int)((Integer)this.getProcessMemory().get()), (DaemonLog)new DaemonLogImpl(), (String[])this.createDaemonClassPath());
        try {
            Registry registry = LocateRegistry.getRegistry("localhost", daemon.getPort());
            RemoteBuildService buildService = (RemoteBuildService)registry.lookup("TeaVM-Daemon");
            RemoteBuildStrategy builder = new RemoteBuildStrategy(buildService);
            this.executeWithBuilder((BuildStrategy)builder);
        }
        finally {
            daemon.getProcess().destroy();
        }
    }

    private void executeWithBuilder(BuildStrategy builder) throws BuildException {
        builder.init();
        GradleTeaVMToolLog toolLog = new GradleTeaVMToolLog(this.getLogger());
        builder.setLog((TeaVMToolLog)toolLog);
        builder.setMainClass((String)this.getMainClass().get());
        builder.setDebugInformationGenerated(((Boolean)this.getDebugInformation().get()).booleanValue());
        ArrayList<String> classPathStrings = new ArrayList<String>();
        for (File file : this.getClasspath()) {
            classPathStrings.add(file.getAbsolutePath());
        }
        builder.setClassPathEntries(classPathStrings);
        builder.setTargetFileName((String)this.getTargetFileName().get());
        builder.setOptimizationLevel(TeaVMTask.map((OptimizationLevel)((Object)this.getOptimization().get())));
        builder.setFastDependencyAnalysis(((Boolean)this.getFastGlobalAnalysis().get()).booleanValue());
        builder.setTargetDirectory(((File)this.getOutputDir().get()).getAbsolutePath());
        builder.setClassesToPreserve(((List)this.getPreservedClasses().get()).toArray(new String[0]));
        if (this.getProperties().isPresent()) {
            Properties properties = new Properties();
            for (Map.Entry entry : ((Map)this.getProperties().get()).entrySet()) {
                properties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            builder.setProperties(properties);
        }
        this.setupBuilder(builder);
        BuildResult result = builder.build();
        TeaVMProblemRenderer.describeProblems((CallGraph)result.getCallGraph(), (ProblemProvider)result.getProblems(), (TeaVMToolLog)toolLog);
        if (!result.getProblems().getSevereProblems().isEmpty()) {
            throw new GradleException("Errors occurred during TeaVM build");
        }
    }

    private static TeaVMOptimizationLevel map(OptimizationLevel level) {
        switch (level) {
            case AGGRESSIVE: {
                return TeaVMOptimizationLevel.FULL;
            }
            case BALANCED: {
                return TeaVMOptimizationLevel.ADVANCED;
            }
        }
        return TeaVMOptimizationLevel.SIMPLE;
    }

    protected abstract void setupBuilder(BuildStrategy var1);

    private String[] createDaemonClassPath() {
        ArrayList<String> result = new ArrayList<String>();
        for (File file : this.getDaemonClasspath()) {
            result.add(file.getAbsolutePath());
        }
        return result.toArray(new String[0]);
    }

    class DaemonLogImpl
    implements DaemonLog {
        DaemonLogImpl() {
        }

        public void error(String message) {
            TeaVMTask.this.getLogger().error(message);
        }

        public void error(String message, Throwable e) {
            TeaVMTask.this.getLogger().error(message, e);
        }

        public void info(String message) {
            TeaVMTask.this.getLogger().info(message);
        }
    }
}

