/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.War;
import org.teavm.gradle.TeaVMExtensionImpl;
import org.teavm.gradle.TeaVMTestConfigurator;
import org.teavm.gradle.api.TeaVMCConfiguration;
import org.teavm.gradle.api.TeaVMConfiguration;
import org.teavm.gradle.api.TeaVMExtension;
import org.teavm.gradle.api.TeaVMJSConfiguration;
import org.teavm.gradle.api.TeaVMWasiConfiguration;
import org.teavm.gradle.api.TeaVMWasmConfiguration;
import org.teavm.gradle.tasks.GenerateCTask;
import org.teavm.gradle.tasks.GenerateJavaScriptTask;
import org.teavm.gradle.tasks.GenerateWasiTask;
import org.teavm.gradle.tasks.GenerateWasmTask;
import org.teavm.gradle.tasks.TeaVMTask;

public class TeaVMPlugin
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "teavm";
    public static final String SOURCE_SET_NAME = "teavm";
    public static final String JS_TASK_NAME = "generateJavaScript";
    public static final String WASM_TASK_NAME = "generateWasm";
    public static final String WASI_TASK_NAME = "generateWasi";
    public static final String C_TASK_NAME = "generateC";
    public static final String CONFIGURATION_NAME = "teavm";
    public static final String CLASSPATH_CONFIGURATION_NAME = "teavmClasspath";
    private ObjectFactory objectFactory;

    @Inject
    public TeaVMPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void apply(Project project) {
        this.registerExtension(project);
        this.registerConfiguration(project);
        this.registerSourceSet(project);
        this.registerTasks(project);
        this.addDependencies(project);
        this.setupWarTask(project);
        TeaVMTestConfigurator.configure(project, ((TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class)).getTests());
    }

    private void registerExtension(Project project) {
        TeaVMExtensionImpl extension = new TeaVMExtensionImpl(project, this.objectFactory);
        project.getExtensions().add(TeaVMExtension.class, "teavm", (Object)extension);
    }

    private void registerConfiguration(Project project) {
        Configuration teavm = (Configuration)project.getConfigurations().create("teavm");
        Configuration teavmClasspath = (Configuration)project.getConfigurations().create(CLASSPATH_CONFIGURATION_NAME);
        project.getConfigurations().configureEach(config -> {
            if (config.getName().equals("runtimeClasspath")) {
                teavmClasspath.extendsFrom(new Configuration[]{config});
            }
            if (config.getName().equals("compileOnly")) {
                config.extendsFrom(new Configuration[]{teavm});
            }
        });
        teavmClasspath.extendsFrom(new Configuration[]{teavm});
    }

    private void registerSourceSet(Project project) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet sourceSet = (SourceSet)sourceSets.create("teavm");
        SourceSetOutput main = ((SourceSet)sourceSets.getByName("main")).getOutput();
        sourceSet.setRuntimeClasspath(sourceSet.getRuntimeClasspath().plus((FileCollection)main).plus((FileCollection)project.getConfigurations().getByName(CLASSPATH_CONFIGURATION_NAME)));
        sourceSet.setCompileClasspath(sourceSet.getCompileClasspath().plus((FileCollection)main).plus((FileCollection)project.getConfigurations().getByName("compileClasspath")));
        sourceSet.java(java -> {});
        project.getDependencies().add("testImplementation", (Object)sourceSet.getOutput());
    }

    private void registerTasks(Project project) {
        Configuration compilerConfig = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)"org.teavm:teavm-tooling:0.8.0")});
        this.registerJsTask(project, compilerConfig);
        this.registerWasmTask(project, compilerConfig);
        this.registerWasiTask(project, compilerConfig);
        this.registerCTask(project, compilerConfig);
    }

    private void registerJsTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().create(JS_TASK_NAME, GenerateJavaScriptTask.class, task -> {
            TeaVMJSConfiguration js = extension.getJs();
            this.applyToTask(js, (TeaVMTask)((Object)task), configuration);
            task.getObfuscated().convention(js.getObfuscated());
            task.getSourceMap().convention(js.getSourceMap());
            task.getTargetFileName().convention(js.getTargetFileName());
            task.getStrict().convention(js.getStrict());
            task.getEntryPointName().convention(js.getEntryPointName());
        });
    }

    private void registerWasmTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().create(WASM_TASK_NAME, GenerateWasmTask.class, task -> {
            TeaVMWasmConfiguration wasm = extension.getWasm();
            this.applyToTask(wasm, (TeaVMTask)((Object)task), configuration);
            task.getTargetFileName().convention(wasm.getTargetFileName());
            task.getMinHeapSize().convention(wasm.getMinHeapSize());
            task.getMaxHeapSize().convention(wasm.getMaxHeapSize());
        });
    }

    private void registerWasiTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().create(WASI_TASK_NAME, GenerateWasiTask.class, task -> {
            TeaVMWasiConfiguration wasi = extension.getWasi();
            this.applyToTask(wasi, (TeaVMTask)((Object)task), configuration);
            task.getTargetFileName().convention(wasi.getTargetFileName());
            task.getMinHeapSize().convention(wasi.getMinHeapSize());
            task.getMaxHeapSize().convention(wasi.getMaxHeapSize());
        });
    }

    private void registerCTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().create(C_TASK_NAME, GenerateCTask.class, task -> {
            TeaVMCConfiguration c = extension.getC();
            this.applyToTask(c, (TeaVMTask)((Object)task), configuration);
            task.getMinHeapSize().convention(c.getMinHeapSize());
            task.getMaxHeapSize().convention(c.getMaxHeapSize());
            task.getHeapDump().convention(c.getHeapDump());
            task.getShortFileNames().convention(c.getShortFileNames());
            task.getObfuscated().convention(c.getObfuscated());
        });
    }

    private void addDependencies(Project project) {
        project.getDependencies().add("teavm", (Object)"org.teavm:teavm-classlib:0.8.0");
        project.getDependencies().add("testImplementation", (Object)"org.teavm:teavm-junit:0.8.0");
        project.getDependencies().add("testRuntimeOnly", (Object)"org.teavm:teavm-classlib:0.8.0");
    }

    private void setupWarTask(Project project) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().withType(War.class).configureEach(task -> {
            if (task.getName().equals("war")) {
                Property<String> relPath;
                Property<File> outDir;
                Boolean jsAddedToWebApp = (Boolean)extension.getJs().getAddedToWebApp().get();
                Boolean wasmAddedToWebApp = (Boolean)extension.getWasm().getAddedToWebApp().get();
                if (jsAddedToWebApp.booleanValue()) {
                    task.dependsOn(new Object[]{project.getTasks().named(JS_TASK_NAME)});
                    outDir = extension.getJs().getOutputDir();
                    relPath = extension.getJs().getRelativePathInOutputDir();
                    task.with(new CopySpec[]{project.copySpec(spec -> {
                        spec.into((Object)relPath);
                        spec.from(new Object[]{project.files(new Object[]{outDir.map(dir -> new File((File)dir, (String)relPath.get()))})});
                        spec.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
                    })});
                }
                if (wasmAddedToWebApp.booleanValue()) {
                    task.dependsOn(new Object[]{project.getTasks().named(WASM_TASK_NAME)});
                    outDir = extension.getWasm().getOutputDir();
                    relPath = extension.getWasm().getRelativePathInOutputDir();
                    task.with(new CopySpec[]{project.copySpec(spec -> {
                        spec.into((Object)relPath);
                        spec.from(new Object[]{project.files(new Object[]{outDir.map(dir -> new File((File)dir, (String)relPath.get()))})});
                    })});
                }
            }
        });
    }

    private static String joinPath(String first, String second) {
        if (first.endsWith("/") || first.isEmpty()) {
            return first + second;
        }
        return first + "/" + second;
    }

    private void applyToTask(TeaVMConfiguration configuration, TeaVMTask task, Configuration toolsConfiguration) {
        task.getMainClass().convention(configuration.getMainClass());
        task.getClasspath().from(new Object[]{task.getProject().getConfigurations().getByName(CLASSPATH_CONFIGURATION_NAME)});
        task.getPreservedClasses().addAll(configuration.getPreservedClasses());
        task.getDebugInformation().convention(configuration.getDebugInformation());
        task.getFastGlobalAnalysis().convention(configuration.getFastGlobalAnalysis());
        task.getOutOfProcess().convention(configuration.getOutOfProcess());
        task.getProcessMemory().convention(configuration.getProcessMemory());
        task.getProperties().putAll(configuration.getProperties());
        task.getDaemonClasspath().from(new Object[]{toolsConfiguration});
        task.getOutputDir().convention(configuration.getOutputDir().map(d -> new File((File)d, (String)configuration.getRelativePathInOutputDir().get())));
        Project project = task.getProject();
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        task.getClasspath().from(new Object[]{((SourceSet)sourceSets.getByName("main")).getOutput()});
        task.getClasspath().from(new Object[]{((SourceSet)sourceSets.getByName("teavm")).getOutput()});
    }
}

