/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle.tasks;

import java.io.File;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.teavm.gradle.api.SourceFilePolicy;
import org.teavm.tooling.TeaVMSourceFilePolicy;
import org.teavm.tooling.builder.BuildStrategy;

final class TaskUtils {
    private TaskUtils() {
    }

    static void applySourceFiles(ConfigurableFileCollection sourceFiles, BuildStrategy builder) {
        for (File file : sourceFiles) {
            if (file.isFile()) {
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
                builder.addSourcesJar(file.getAbsolutePath());
                continue;
            }
            if (!file.isDirectory()) continue;
            builder.addSourcesDirectory(file.getAbsolutePath());
        }
    }

    static void applySourceFilePolicy(Property<SourceFilePolicy> policy, BuildStrategy builder) {
        switch ((SourceFilePolicy)((Object)policy.get())) {
            case DO_NOTHING: {
                builder.setSourceFilePolicy(TeaVMSourceFilePolicy.DO_NOTHING);
                break;
            }
            case COPY: {
                builder.setSourceFilePolicy(TeaVMSourceFilePolicy.COPY);
                break;
            }
            case LINK_LOCAL_FILES: {
                builder.setSourceFilePolicy(TeaVMSourceFilePolicy.LINK_LOCAL_FILES);
            }
        }
    }
}

